/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.tech.docmosis.AnahataODFTemplateAnalyzer;
import com.docmosis.SystemManager;
import com.docmosis.template.analysis.TemplateAnalysis;
import java.io.File;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="TEMPLATE")
public class TemplateDocument
extends Document
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(TemplateDocument.class);
    private String templateId;
    @Lob
    private TemplateAnalysis docmosisAnalysis;
    @Basic
    private String docmosisWorkingRevisionId;
    @Lob
    private byte[] docmosisWorkingCopy;
    static final long serialVersionUID = -4514935974002293838L;

    public TemplateDocument(Revision firstRevision) {
        super(firstRevision);
    }

    public Revision getDocmosisWorkingRevision() {
        for (Revision r : this.getRevisions()) {
            if (!r.getId().equals(this._persistence_get_docmosisWorkingRevisionId())) continue;
            return r;
        }
        throw new IllegalStateException("Could not find working revision " + this._persistence_get_docmosisWorkingRevisionId());
    }

    @Override
    protected void revisionAdded(Revision r, Mirror m) {
        File file = r.getFile();
        if (file != null) {
            try {
                byte[] data = FileUtils.readFileToByteArray((File)file);
                this.checkState(r, data);
            }
            catch (Exception e) {
                log.error("Error reading file to byte array " + this.getId(), (Throwable)e);
                throw new RuntimeException("Error reading file to byte array " + this.getId(), e);
            }
        } else if (r.getData() != null) {
            this.checkState(r, r.getData().getBytes());
        }
    }

    @Override
    protected void revisionUploaded(Revision revision) {
        this.checkState(revision, revision.getBytes());
    }

    private void checkState(@NonNull Revision revision, @NonNull byte[] data) {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        try {
            if (SystemManager.isInitialized()) {
                this._persistence_set_docmosisWorkingRevisionId(revision.getId());
                log.debug("Generating analysis of templateId {} wcr={} addedBy={}", new Object[]{this.getTemplateId(), this.getDocmosisWorkingRevision(), revision.getAddedBy()});
                AnahataODFTemplateAnalyzer ata = new AnahataODFTemplateAnalyzer(data);
                this._persistence_set_docmosisAnalysis(ata.getAnalysis());
                this._persistence_set_docmosisWorkingCopy(ata.getWorkingTemplate());
                Validate.notNull((Object)this.getDocmosisWorkingRevision(), (String)"Could not create template working copy", (Object[])new Object[0]);
                Validate.notNull((Object)this._persistence_get_docmosisAnalysis(), (String)"Could not create template analysis", (Object[])new Object[0]);
                log.debug("Analysis and thumbnail of template {} generated, analysys={}=", (Object)this.getTemplateId(), (Object)this._persistence_get_docmosisAnalysis());
            }
        }
        catch (Exception e) {
            log.error("Error creating analysis and thumbnail of " + this.getTitle(), (Throwable)e);
            throw new RuntimeException("Error creating analysis and thumbnail of " + this.getTitle(), e);
        }
    }

    @PrePersist
    public void validate() {
        if (this._persistence_get_templateId() == null) {
            this._persistence_set_templateId(UUID.randomUUID().toString());
        }
        if (this.getHeadRevision().isUploaded()) {
            Validate.notNull((Object)this._persistence_get_docmosisWorkingRevisionId(), (String)"docmosisWorkingRevisionId cannot be null", (Object[])new Object[0]);
            Validate.notNull((Object)this._persistence_get_docmosisWorkingCopy(), (String)"docmosisWorkingRevisionId cannot be null", (Object[])new Object[0]);
        }
    }

    public String getTemplateId() {
        return this._persistence_get_templateId();
    }

    public TemplateAnalysis getDocmosisAnalysis() {
        return this._persistence_get_docmosisAnalysis();
    }

    public String getDocmosisWorkingRevisionId() {
        return this._persistence_get_docmosisWorkingRevisionId();
    }

    public byte[] getDocmosisWorkingCopy() {
        return this._persistence_get_docmosisWorkingCopy();
    }

    public void setTemplateId(String templateId) {
        this._persistence_set_templateId(templateId);
    }

    public void setDocmosisAnalysis(TemplateAnalysis docmosisAnalysis) {
        this._persistence_set_docmosisAnalysis(docmosisAnalysis);
    }

    public void setDocmosisWorkingRevisionId(String docmosisWorkingRevisionId) {
        this._persistence_set_docmosisWorkingRevisionId(docmosisWorkingRevisionId);
    }

    public void setDocmosisWorkingCopy(byte[] docmosisWorkingCopy) {
        this._persistence_set_docmosisWorkingCopy(docmosisWorkingCopy);
    }

    public TemplateDocument() {
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TemplateDocument();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "docmosisWorkingCopy") {
            return this.docmosisWorkingCopy;
        }
        if (string == "docmosisAnalysis") {
            return this.docmosisAnalysis;
        }
        if (string == "templateId") {
            return this.templateId;
        }
        if (string == "docmosisWorkingRevisionId") {
            return this.docmosisWorkingRevisionId;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "docmosisWorkingCopy") {
            this.docmosisWorkingCopy = (byte[])object;
            return;
        }
        if (string == "docmosisAnalysis") {
            this.docmosisAnalysis = (TemplateAnalysis)object;
            return;
        }
        if (string == "templateId") {
            this.templateId = (String)object;
            return;
        }
        if (string == "docmosisWorkingRevisionId") {
            this.docmosisWorkingRevisionId = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public byte[] _persistence_get_docmosisWorkingCopy() {
        this._persistence_checkFetched("docmosisWorkingCopy");
        return this.docmosisWorkingCopy;
    }

    public void _persistence_set_docmosisWorkingCopy(byte[] byArray) {
        this._persistence_checkFetchedForSet("docmosisWorkingCopy");
        this._persistence_propertyChange("docmosisWorkingCopy", this.docmosisWorkingCopy, byArray);
        this.docmosisWorkingCopy = byArray;
    }

    public TemplateAnalysis _persistence_get_docmosisAnalysis() {
        this._persistence_checkFetched("docmosisAnalysis");
        return this.docmosisAnalysis;
    }

    public void _persistence_set_docmosisAnalysis(TemplateAnalysis templateAnalysis) {
        this._persistence_checkFetchedForSet("docmosisAnalysis");
        this._persistence_propertyChange("docmosisAnalysis", this.docmosisAnalysis, templateAnalysis);
        this.docmosisAnalysis = templateAnalysis;
    }

    public String _persistence_get_templateId() {
        this._persistence_checkFetched("templateId");
        return this.templateId;
    }

    public void _persistence_set_templateId(String string) {
        this._persistence_checkFetchedForSet("templateId");
        this._persistence_propertyChange("templateId", this.templateId, string);
        this.templateId = string;
    }

    public String _persistence_get_docmosisWorkingRevisionId() {
        this._persistence_checkFetched("docmosisWorkingRevisionId");
        return this.docmosisWorkingRevisionId;
    }

    public void _persistence_set_docmosisWorkingRevisionId(String string) {
        this._persistence_checkFetchedForSet("docmosisWorkingRevisionId");
        this._persistence_propertyChange("docmosisWorkingRevisionId", this.docmosisWorkingRevisionId, string);
        this.docmosisWorkingRevisionId = string;
    }
}

