/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.util.formatting.Displayable;
import com.anahata.util.image.ScaleImage;
import com.anahata.util.lang.Nvl;
import com.anahata.util.mime.MimeUtils;
import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.RevisionData;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.model.dms.storage.RevisionStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.model.user.User;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlTransient;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="DMSREVISION", uniqueConstraints={@UniqueConstraint(columnNames={"DOCUMENT_ID", "NUMBER"})})
public class Revision
implements Serializable,
Displayable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final Logger log = LoggerFactory.getLogger(Revision.class);
    public static final Comparator<Revision> DEFAULT_REVSIONSORT = new DefaultRevisionSort();
    @Id
    @NotNull
    private String id = UUID.randomUUID().toString();
    @ManyToOne
    @JoinColumn
    @NotNull
    private Document document;
    @NotNull
    @Column
    private Integer number;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    @NotNull
    private Date addedOn;
    @ManyToOne
    @NotNull
    @JoinColumn
    private User addedBy;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private RevisionSynchStatus synchStatus = RevisionSynchStatus.PENDING_UPLOAD;
    @NotNull
    @Column
    private String fileName;
    private Float uploadProgress;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date uploadProgressTimestamp;
    @NotNull
    @Column
    private String mimeType;
    @NotNull
    @Column
    private Long fileSize;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column
    private Date createdOn;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column
    private Date modifiedOn;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.DETACH, CascadeType.PERSIST})
    private RevisionData data;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="DMSREVISION_DMSMIRROR", joinColumns={@JoinColumn(name="DMSREVISION_ID")}, inverseJoinColumns={@JoinColumn(name="DMSMIRROR_ID")})
    private List<Mirror> mirrors = new ArrayList<Mirror>();
    @ManyToOne
    private Revision copyOf;
    @OneToMany(mappedBy="copyOf", cascade={CascadeType.ALL})
    private List<Revision> copies = new ArrayList<Revision>();
    @OneToMany(mappedBy="revision", cascade={CascadeType.ALL})
    private List<RevisionStorage> storage = new ArrayList<RevisionStorage>();
    @Transient
    private transient File file;
    static final long serialVersionUID = 7483033855156736973L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_data_vh;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Revision(@NonNull byte[] data, @NonNull String name, User user) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.addedOn = new Date();
        this.fileName = name;
        this.mimeType = MimeUtils.getMimeType((byte[])data, (String)name);
        this.fileSize = data.length;
        this.createdOn = new Date();
        this.modifiedOn = new Date();
        this.synchStatus = RevisionSynchStatus.UPLOADED;
        this.addedBy = user;
        this.data = new RevisionData(data);
    }

    public Revision(@NonNull File file, User addedBy) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        Validate.isTrue((boolean)file.isFile(), (String)"File %s must be a file", (Object[])new Object[]{file});
        Validate.isTrue((boolean)file.exists(), (String)"File %s must exist", (Object[])new Object[]{file});
        this.addedOn = new Date();
        this.addedBy = addedBy;
        this.file = file;
        this.fileName = file.getName();
        this.mimeType = MimeUtils.getMimeType((File)file);
        this.fileSize = file.length();
        Path p = Paths.get(file.toURI());
        BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        this.createdOn = new Date(view.creationTime().toMillis());
        this.modifiedOn = new Date(view.lastModifiedTime().toMillis());
    }

    public static List<Revision> newList(List<File> files) throws IOException {
        ArrayList<Revision> ret = new ArrayList<Revision>();
        for (File file : files) {
            ret.add(new Revision(file, null));
        }
        return ret;
    }

    public boolean isHead() {
        return this.equals(this._persistence_get_document().getHeadRevision());
    }

    public boolean isRemoved() {
        return this._persistence_get_document().isRemoved();
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this._persistence_get_fileName());
    }

    public boolean isImage() {
        return this._persistence_get_mimeType().startsWith("image");
    }

    public boolean isPdf() {
        return this._persistence_get_mimeType().contains("pdf");
    }

    public boolean addMirror(Mirror mirror) {
        log.debug("revision.addMirror {}, {}");
        if (!this.isUploaded()) {
            if (!this._persistence_get_mirrors().contains(mirror)) {
                log.debug("adding mirror");
                this._persistence_get_mirrors().add(mirror);
            }
            if (!mirror.getRevisionsPendingUpload().contains(this)) {
                log.debug("adding revision");
                mirror.getRevisionsPendingUpload().add(this);
            }
            return true;
        }
        return false;
    }

    public boolean isUploaded() {
        return this._persistence_get_synchStatus() == RevisionSynchStatus.UPLOADED;
    }

    public boolean isUploading(long gracePeriodMillis) {
        if (this._persistence_get_synchStatus() != RevisionSynchStatus.UPLOADING) {
            return false;
        }
        long millisSinceLastTouch = new Date().getTime() - this.getUploadProgressTimestamp().getTime();
        return millisSinceLastTouch < gracePeriodMillis;
    }

    public boolean startUpload() {
        if (!this.isUploaded()) {
            this._persistence_set_synchStatus(RevisionSynchStatus.UPLOADING);
            this._persistence_set_uploadProgress(Float.valueOf(0.0f));
            this._persistence_set_uploadProgressTimestamp(new Date());
            return true;
        }
        return false;
    }

    public boolean progressUpload(Float progress) {
        if (!this.isUploaded()) {
            this._persistence_set_synchStatus(RevisionSynchStatus.UPLOADING);
            this._persistence_set_uploadProgress(Float.valueOf(Math.max(progress.floatValue(), Nvl.nvl((Float)this._persistence_get_uploadProgress()).floatValue())));
            this._persistence_set_uploadProgressTimestamp(new Date());
            return true;
        }
        return false;
    }

    public boolean cancelUpload() {
        if (!this.isUploaded()) {
            this._persistence_set_synchStatus(RevisionSynchStatus.PENDING_UPLOAD);
            this._persistence_set_uploadProgress(null);
            this._persistence_set_uploadProgressTimestamp(null);
            return true;
        }
        return false;
    }

    public boolean completeUpload(byte[] bytes) {
        if (!this.isUploaded()) {
            this._persistence_set_data(new RevisionData(bytes));
            this.markAsUploaded();
            this._persistence_set_uploadProgress(null);
            this._persistence_set_uploadProgressTimestamp(null);
            for (Mirror m : this._persistence_get_mirrors()) {
                boolean success = m.getRevisionsPendingUpload().remove(this);
                log.info("completeUpload Removed {} from mirror {} success = {}", new Object[]{this, m, success});
            }
            this._persistence_get_mirrors().clear();
            this._persistence_get_document().revisionUploaded(this);
            return true;
        }
        return false;
    }

    private void markAsUploaded() {
        this._persistence_set_synchStatus(RevisionSynchStatus.UPLOADED);
        for (Revision copy : this._persistence_get_copies()) {
            RevisionData rd = new RevisionData(this._persistence_get_data().getBytes());
            copy._persistence_set_data(rd);
            copy.markAsUploaded();
        }
    }

    public void clearData() {
        Validate.isTrue((this._persistence_get_data() != null ? 1 : 0) != 0, (String)" data is null", (Object[])new Object[0]);
        this._persistence_set_data(null);
    }

    public byte[] getBytes() {
        return this._persistence_get_data() != null ? this._persistence_get_data().getBytes() : null;
    }

    Revision copy(User addedBy) {
        Revision copy = new Revision();
        copy._persistence_set_addedBy(addedBy);
        copy._persistence_set_addedOn(new Date());
        copy._persistence_set_createdOn(this._persistence_get_createdOn());
        copy._persistence_set_copyOf(this);
        this._persistence_get_copies().add(copy);
        if (this._persistence_get_synchStatus() == RevisionSynchStatus.UPLOADED && this._persistence_get_data() != null) {
            copy._persistence_set_data(new RevisionData(this._persistence_get_data().getBytes()));
            copy._persistence_set_synchStatus(RevisionSynchStatus.UPLOADED);
            log.debug("Copied revision content and status to UPLOADED");
        } else {
            copy._persistence_set_synchStatus(RevisionSynchStatus.PENDING_COPY);
            log.debug("Revision status to PENDING_COPY");
        }
        copy._persistence_set_fileName(this._persistence_get_fileName());
        copy._persistence_set_fileSize(this._persistence_get_fileSize());
        copy._persistence_set_mimeType(this._persistence_get_mimeType());
        copy._persistence_set_modifiedOn(this._persistence_get_modifiedOn());
        return copy;
    }

    public Revision getMasterRevision() {
        Revision ret = this;
        while (ret._persistence_get_copyOf() != null) {
            ret = ret._persistence_get_copyOf();
        }
        return ret;
    }

    public Set<Document> getAllDocuments() {
        HashSet<Document> s = new HashSet<Document>();
        s.add(this._persistence_get_document());
        for (Revision copy : this._persistence_get_copies()) {
            s.addAll(copy.getAllDocuments());
        }
        return s;
    }

    public byte[] getThumbnail(int maxWidth, int maxHeight) throws IOException, InterruptedException, ExecutionException {
        Validate.notNull((Object)this.getBytes(), (String)"bytes not available", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.isImage(), (String)"only imagages can be thumbnailed by this method", (Object[])new Object[0]);
        return Revision.makeThumbnail(this, new ByteArrayInputStream(this.getBytes()), maxWidth, maxHeight);
    }

    public byte[] getThumbnailForPdf(int maxWidth, int maxHeight) throws IOException, InterruptedException, ExecutionException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.getBytes());){
            byte[] byArray = Revision.makeThumbnailForPdf(is, maxWidth, maxHeight);
            return byArray;
        }
    }

    public static byte[] makeThumbnail(Revision r, InputStream is, int maxWidth, int maxHeight) throws IOException, InterruptedException, ExecutionException {
        if (r.isImage()) {
            return Revision.makeThumbnailForImage(is, maxWidth, maxHeight);
        }
        if (r.isPdf()) {
            return Revision.makeThumbnailForPdf(is, maxWidth, maxHeight);
        }
        throw new IOException("mimeType " + r._persistence_get_mimeType() + " not supported for local thumbnail");
    }

    public static byte[] makeThumbnailForPdf(InputStream is, int maxWidth, int maxHeight) throws IOException, InterruptedException, ExecutionException {
        try (PDDocument pdDocument = PDDocument.load((InputStream)is);){
            byte[] imageInByte;
            PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)bim, "png", baos);
                baos.flush();
                try (ByteArrayInputStream imageIS = new ByteArrayInputStream(baos.toByteArray());){
                    imageInByte = Revision.makeThumbnailForImage(imageIS, maxWidth, maxHeight);
                }
            }
            byte[] byArray = imageInByte;
            return byArray;
        }
    }

    public static byte[] makeThumbnailForImage(InputStream is, int maxWidth, int maxHeight) throws IOException, InterruptedException, ExecutionException {
        return ScaleImage.scale((InputStream)is, (int)maxWidth, (int)maxHeight, (String)"png");
    }

    public static String getThumbnailFileName(String revisionId, int maxWidth, int maxHeight) {
        return revisionId + "_" + maxWidth + "x" + maxHeight;
    }

    public RevisionStorage getRevisionStorage(StorageProvider sp) {
        for (RevisionStorage rs : this._persistence_get_storage()) {
            if (!((Base)rs.getProvider()).equals(sp)) continue;
            return rs;
        }
        return null;
    }

    public boolean isSynched(StorageProvider sp) {
        RevisionStorage rs = this.getRevisionStorage(sp);
        return rs != null;
    }

    public String toString() {
        return "Revision{id=" + this._persistence_get_id() + ", number=" + this._persistence_get_number() + ", document=" + this._persistence_get_document().getTitle() + " synchStatus=" + (Object)((Object)this._persistence_get_synchStatus()) + '}';
    }

    public String getDisplayValue() {
        return this._persistence_get_number() + "";
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public Document getDocument() {
        return this._persistence_get_document();
    }

    public Integer getNumber() {
        return this._persistence_get_number();
    }

    public Date getAddedOn() {
        return this._persistence_get_addedOn();
    }

    public User getAddedBy() {
        return this._persistence_get_addedBy();
    }

    public RevisionSynchStatus getSynchStatus() {
        return this._persistence_get_synchStatus();
    }

    public String getFileName() {
        return this._persistence_get_fileName();
    }

    public Float getUploadProgress() {
        return this._persistence_get_uploadProgress();
    }

    public Date getUploadProgressTimestamp() {
        return this._persistence_get_uploadProgressTimestamp();
    }

    public String getMimeType() {
        return this._persistence_get_mimeType();
    }

    public Long getFileSize() {
        return this._persistence_get_fileSize();
    }

    public Date getCreatedOn() {
        return this._persistence_get_createdOn();
    }

    public Date getModifiedOn() {
        return this._persistence_get_modifiedOn();
    }

    public RevisionData getData() {
        return this._persistence_get_data();
    }

    public List<Mirror> getMirrors() {
        return this._persistence_get_mirrors();
    }

    public Revision getCopyOf() {
        return this._persistence_get_copyOf();
    }

    public List<Revision> getCopies() {
        return this._persistence_get_copies();
    }

    public List<RevisionStorage> getStorage() {
        return this._persistence_get_storage();
    }

    public File getFile() {
        return this.file;
    }

    protected Revision() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Revision;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    void setDocument(Document document) {
        this._persistence_set_document(document);
    }

    void setNumber(Integer number) {
        this._persistence_set_number(number);
    }

    public void setAddedBy(User addedBy) {
        this._persistence_set_addedBy(addedBy);
    }

    private void setSynchStatus(RevisionSynchStatus synchStatus) {
        this._persistence_set_synchStatus(synchStatus);
    }

    public void setFileName(String fileName) {
        this._persistence_set_fileName(fileName);
    }

    public void setCreatedOn(Date createdOn) {
        this._persistence_set_createdOn(createdOn);
    }

    public void setModifiedOn(Date modifiedOn) {
        this._persistence_set_modifiedOn(modifiedOn);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Object _persistence_post_clone() {
        if (this._persistence_data_vh != null) {
            this._persistence_data_vh = (WeavedAttributeValueHolderInterface)this._persistence_data_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Revision();
    }

    public Object _persistence_get(String string) {
        if (string == "fileName") {
            return this.fileName;
        }
        if (string == "data") {
            return this.data;
        }
        if (string == "mirrors") {
            return this.mirrors;
        }
        if (string == "addedBy") {
            return this.addedBy;
        }
        if (string == "uploadProgress") {
            return this.uploadProgress;
        }
        if (string == "document") {
            return this.document;
        }
        if (string == "mimeType") {
            return this.mimeType;
        }
        if (string == "storage") {
            return this.storage;
        }
        if (string == "copyOf") {
            return this.copyOf;
        }
        if (string == "createdOn") {
            return this.createdOn;
        }
        if (string == "addedOn") {
            return this.addedOn;
        }
        if (string == "number") {
            return this.number;
        }
        if (string == "uploadProgressTimestamp") {
            return this.uploadProgressTimestamp;
        }
        if (string == "modifiedOn") {
            return this.modifiedOn;
        }
        if (string == "copies") {
            return this.copies;
        }
        if (string == "fileSize") {
            return this.fileSize;
        }
        if (string == "synchStatus") {
            return this.synchStatus;
        }
        if (string == "id") {
            return this.id;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "fileName") {
            this.fileName = (String)object;
            return;
        }
        if (string == "data") {
            this.data = (RevisionData)object;
            return;
        }
        if (string == "mirrors") {
            this.mirrors = (List)object;
            return;
        }
        if (string == "addedBy") {
            this.addedBy = (User)object;
            return;
        }
        if (string == "uploadProgress") {
            this.uploadProgress = (Float)object;
            return;
        }
        if (string == "document") {
            this.document = (Document)object;
            return;
        }
        if (string == "mimeType") {
            this.mimeType = (String)object;
            return;
        }
        if (string == "storage") {
            this.storage = (List)object;
            return;
        }
        if (string == "copyOf") {
            this.copyOf = (Revision)object;
            return;
        }
        if (string == "createdOn") {
            this.createdOn = (Date)object;
            return;
        }
        if (string == "addedOn") {
            this.addedOn = (Date)object;
            return;
        }
        if (string == "number") {
            this.number = (Integer)object;
            return;
        }
        if (string == "uploadProgressTimestamp") {
            this.uploadProgressTimestamp = (Date)object;
            return;
        }
        if (string == "modifiedOn") {
            this.modifiedOn = (Date)object;
            return;
        }
        if (string == "copies") {
            this.copies = (List)object;
            return;
        }
        if (string == "fileSize") {
            this.fileSize = (Long)object;
            return;
        }
        if (string == "synchStatus") {
            this.synchStatus = (RevisionSynchStatus)((Object)object);
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
    }

    public String _persistence_get_fileName() {
        this._persistence_checkFetched("fileName");
        return this.fileName;
    }

    public void _persistence_set_fileName(String string) {
        this._persistence_checkFetchedForSet("fileName");
        this._persistence_propertyChange("fileName", this.fileName, string);
        this.fileName = string;
    }

    protected void _persistence_initialize_data_vh() {
        if (this._persistence_data_vh == null) {
            this._persistence_data_vh = new ValueHolder((Object)this.data);
            this._persistence_data_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_data_vh() {
        RevisionData revisionData;
        this._persistence_initialize_data_vh();
        if ((this._persistence_data_vh.isCoordinatedWithProperty() || this._persistence_data_vh.isNewlyWeavedValueHolder()) && (revisionData = this._persistence_get_data()) != this._persistence_data_vh.getValue()) {
            this._persistence_set_data(revisionData);
        }
        return this._persistence_data_vh;
    }

    public void _persistence_set_data_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_data_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RevisionData revisionData = this._persistence_get_data();
            if (revisionData != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_data((RevisionData)object);
            }
        } else {
            this.data = null;
        }
    }

    public RevisionData _persistence_get_data() {
        this._persistence_checkFetched("data");
        this._persistence_initialize_data_vh();
        this.data = (RevisionData)this._persistence_data_vh.getValue();
        return this.data;
    }

    public void _persistence_set_data(RevisionData revisionData) {
        this._persistence_checkFetchedForSet("data");
        this._persistence_initialize_data_vh();
        this.data = (RevisionData)this._persistence_data_vh.getValue();
        this._persistence_propertyChange("data", this.data, revisionData);
        this.data = revisionData;
        this._persistence_data_vh.setValue((Object)revisionData);
    }

    public List _persistence_get_mirrors() {
        this._persistence_checkFetched("mirrors");
        return this.mirrors;
    }

    public void _persistence_set_mirrors(List list) {
        this._persistence_checkFetchedForSet("mirrors");
        this._persistence_propertyChange("mirrors", this.mirrors, list);
        this.mirrors = list;
    }

    public User _persistence_get_addedBy() {
        this._persistence_checkFetched("addedBy");
        return this.addedBy;
    }

    public void _persistence_set_addedBy(User user) {
        this._persistence_checkFetchedForSet("addedBy");
        this._persistence_propertyChange("addedBy", this.addedBy, user);
        this.addedBy = user;
    }

    public Float _persistence_get_uploadProgress() {
        this._persistence_checkFetched("uploadProgress");
        return this.uploadProgress;
    }

    public void _persistence_set_uploadProgress(Float f) {
        this._persistence_checkFetchedForSet("uploadProgress");
        this._persistence_propertyChange("uploadProgress", this.uploadProgress, f);
        this.uploadProgress = f;
    }

    public Document _persistence_get_document() {
        this._persistence_checkFetched("document");
        return this.document;
    }

    public void _persistence_set_document(Document document) {
        this._persistence_checkFetchedForSet("document");
        this._persistence_propertyChange("document", this.document, document);
        this.document = document;
    }

    public String _persistence_get_mimeType() {
        this._persistence_checkFetched("mimeType");
        return this.mimeType;
    }

    public void _persistence_set_mimeType(String string) {
        this._persistence_checkFetchedForSet("mimeType");
        this._persistence_propertyChange("mimeType", this.mimeType, string);
        this.mimeType = string;
    }

    public List _persistence_get_storage() {
        this._persistence_checkFetched("storage");
        return this.storage;
    }

    public void _persistence_set_storage(List list) {
        this._persistence_checkFetchedForSet("storage");
        this._persistence_propertyChange("storage", this.storage, list);
        this.storage = list;
    }

    public Revision _persistence_get_copyOf() {
        this._persistence_checkFetched("copyOf");
        return this.copyOf;
    }

    public void _persistence_set_copyOf(Revision revision) {
        this._persistence_checkFetchedForSet("copyOf");
        this._persistence_propertyChange("copyOf", this.copyOf, revision);
        this.copyOf = revision;
    }

    public Date _persistence_get_createdOn() {
        this._persistence_checkFetched("createdOn");
        return this.createdOn;
    }

    public void _persistence_set_createdOn(Date date) {
        this._persistence_checkFetchedForSet("createdOn");
        this._persistence_propertyChange("createdOn", this.createdOn, date);
        this.createdOn = date;
    }

    public Date _persistence_get_addedOn() {
        this._persistence_checkFetched("addedOn");
        return this.addedOn;
    }

    public void _persistence_set_addedOn(Date date) {
        this._persistence_checkFetchedForSet("addedOn");
        this._persistence_propertyChange("addedOn", this.addedOn, date);
        this.addedOn = date;
    }

    public Integer _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(Integer n) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, n);
        this.number = n;
    }

    public Date _persistence_get_uploadProgressTimestamp() {
        this._persistence_checkFetched("uploadProgressTimestamp");
        return this.uploadProgressTimestamp;
    }

    public void _persistence_set_uploadProgressTimestamp(Date date) {
        this._persistence_checkFetchedForSet("uploadProgressTimestamp");
        this._persistence_propertyChange("uploadProgressTimestamp", this.uploadProgressTimestamp, date);
        this.uploadProgressTimestamp = date;
    }

    public Date _persistence_get_modifiedOn() {
        this._persistence_checkFetched("modifiedOn");
        return this.modifiedOn;
    }

    public void _persistence_set_modifiedOn(Date date) {
        this._persistence_checkFetchedForSet("modifiedOn");
        this._persistence_propertyChange("modifiedOn", this.modifiedOn, date);
        this.modifiedOn = date;
    }

    public List _persistence_get_copies() {
        this._persistence_checkFetched("copies");
        return this.copies;
    }

    public void _persistence_set_copies(List list) {
        this._persistence_checkFetchedForSet("copies");
        this._persistence_propertyChange("copies", this.copies, list);
        this.copies = list;
    }

    public Long _persistence_get_fileSize() {
        this._persistence_checkFetched("fileSize");
        return this.fileSize;
    }

    public void _persistence_set_fileSize(Long l) {
        this._persistence_checkFetchedForSet("fileSize");
        this._persistence_propertyChange("fileSize", this.fileSize, l);
        this.fileSize = l;
    }

    public RevisionSynchStatus _persistence_get_synchStatus() {
        this._persistence_checkFetched("synchStatus");
        return this.synchStatus;
    }

    public void _persistence_set_synchStatus(RevisionSynchStatus revisionSynchStatus) {
        this._persistence_checkFetchedForSet("synchStatus");
        this._persistence_propertyChange("synchStatus", (Object)this.synchStatus, (Object)revisionSynchStatus);
        this.synchStatus = revisionSynchStatus;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }

    private static class DefaultRevisionSort
    implements Comparator<Revision> {
        private DefaultRevisionSort() {
        }

        @Override
        public int compare(Revision revision1, Revision revision2) {
            return revision2.getNumber().compareTo(revision1.getNumber());
        }
    }
}

