/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.NodeEventType;
import com.anahata.yam.model.user.User;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="DMSNODEEVENT")
@NodeEventType(description="Generic Node Event")
public abstract class NodeEvent<T extends Node>
extends Base
implements Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(NodeEvent.class);
    @NotNull
    @ManyToOne
    private Node node;
    @NotNull
    @ManyToOne
    private User user;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date createdOn = new Date();
    static final long serialVersionUID = -8561139579733848686L;

    protected NodeEvent(@NonNull Node node, @NonNull User user) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.node = node;
        this.user = user;
    }

    public static String getEventTypeDescription(Class<? extends NodeEvent> clazz) {
        NodeEventType nodeEventType = clazz.getAnnotation(NodeEventType.class);
        return nodeEventType.description();
    }

    public static Map<Class<? extends NodeEvent>, String> getEventTypeDescriptions(List<? extends NodeEvent> list) {
        HashMap<Class<? extends NodeEvent>, String> map = new HashMap<Class<? extends NodeEvent>, String>();
        for (NodeEvent nodeEvent : list) {
            map.put(nodeEvent.getClass(), NodeEvent.getEventTypeDescription(nodeEvent.getClass()));
        }
        return map;
    }

    public String getEventTypeDescription() {
        return NodeEvent.getEventTypeDescription(this.getClass());
    }

    public Node getNode() {
        return this._persistence_get_node();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public Date getCreatedOn() {
        return this._persistence_get_createdOn();
    }

    public void setNode(Node node) {
        this._persistence_set_node(node);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    public void setCreatedOn(Date createdOn) {
        this._persistence_set_createdOn(createdOn);
    }

    protected NodeEvent() {
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NodeEvent<T>();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "node") {
            return this.node;
        }
        if (string == "createdOn") {
            return this.createdOn;
        }
        if (string == "user") {
            return this.user;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "node") {
            this.node = (Node)object;
            return;
        }
        if (string == "createdOn") {
            this.createdOn = (Date)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Node _persistence_get_node() {
        this._persistence_checkFetched("node");
        return this.node;
    }

    public void _persistence_set_node(Node node) {
        this._persistence_checkFetchedForSet("node");
        this._persistence_propertyChange("node", this.node, node);
        this.node = node;
    }

    public Date _persistence_get_createdOn() {
        this._persistence_checkFetched("createdOn");
        return this.createdOn;
    }

    public void _persistence_set_createdOn(Date date) {
        this._persistence_checkFetchedForSet("createdOn");
        this._persistence_propertyChange("createdOn", this.createdOn, date);
        this.createdOn = date;
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
    }
}

