/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.util.formatting.Displayable;
import com.anahata.util.model.Activatable;
import com.anahata.yam.model.Base;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.NodeEvent;
import com.anahata.yam.model.dms.security.NodeSecurityPolicy;
import com.anahata.yam.model.dms.storage.NodeStorage;
import com.anahata.yam.model.dms.storage.StorageProvider;
import com.anahata.yam.model.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="DMSNODE")
public abstract class Node
extends Base
implements Serializable,
Activatable,
Displayable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    @ManyToOne
    protected Folder parent;
    @Size(min=1, max=1024)
    @NotNull
    protected String title;
    @Size(max=65535)
    protected String notes;
    protected boolean readOnly = false;
    protected boolean trashed = false;
    protected boolean removed = false;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    protected Date accessedOn = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    protected Date changedOn = new Date();
    @OneToMany(mappedBy="node", cascade={CascadeType.ALL})
    private List<NodeStorage> storage = new ArrayList<NodeStorage>();
    @OneToMany(mappedBy="node", cascade={CascadeType.ALL})
    private List<NodeEvent> events = new ArrayList<NodeEvent>();
    @Transient
    private transient boolean securityPolicyDisabled = false;
    static final long serialVersionUID = 7983737639935552336L;

    protected Node(Long id) {
        super(id);
    }

    public abstract <N extends Node, T extends NodeSecurityPolicy<N>> T getSecurityPolicy();

    public abstract <N extends Node, T extends NodeSecurityPolicy<N>> T getSecurityPolicy(Enum var1);

    protected void setSecurityPolicyEnabled(boolean value) {
        log.debug("call to setSecurityPolicyEnabled old= {}, newValue= {}", (Object)this.securityPolicyDisabled, (Object)value);
        this.securityPolicyDisabled = !value;
    }

    public boolean isSecurityPolicyEnabled() {
        return !this.securityPolicyDisabled;
    }

    public void disableSecurityPolicy() {
        log.debug("disabling SecurityPolicy empty setter on node= {} securityPolicyEnabled= {}", (Object)this, (Object)this.securityPolicyDisabled);
        this.securityPolicyDisabled = true;
    }

    public void enableSecurityPolicy() {
        log.debug("enabling SecurityPolicy empty setter on node= {}, securityPolicyEnabled= {}", (Object)this, (Object)this.securityPolicyDisabled);
        this.securityPolicyDisabled = false;
    }

    protected final void validateNew() {
        Validate.isTrue((this.getId() == null ? 1 : 0) != 0, (String)"%s has a set id", (Object[])new Object[]{this});
    }

    public void setParent(Folder parent) {
        this._persistence_set_parent(this.propertyUpdate(this._persistence_get_parent(), parent));
    }

    public void setReadOnly(boolean readOnly) {
        this._persistence_set_readOnly(this.propertyUpdate(this._persistence_get_readOnly(), readOnly));
    }

    public boolean isReadable(User user) {
        return this.getSecurityPolicy().isReadable(user, (Node)this);
    }

    public final void trash(User user) {
        Validate.isTrue((boolean)this.isTrashable(user), (String)(this + " cannot be trashed"), (Object[])new Object[0]);
        this._persistence_set_trashed(this.propertyUpdate(this._persistence_get_trashed(), true));
    }

    public boolean isTrashable(User user) {
        return !this._persistence_get_readOnly() && !this._persistence_get_trashed() && this.getSecurityPolicy().isTrashable(user, (Node)this);
    }

    public boolean isActive() {
        return !this._persistence_get_trashed();
    }

    public void setActive(boolean active) {
        throw new UnsupportedOperationException("use trash() or untrash() as user needs to be specified");
    }

    public final void untrash(User user) {
        Validate.isTrue((boolean)this.isUntrashable(user), (String)(this + " cannot be trashed"), (Object[])new Object[0]);
        this._persistence_set_trashed(this.propertyUpdate(this._persistence_get_trashed(), false));
    }

    public boolean isUntrashable(User user) {
        return !this._persistence_get_readOnly() && this._persistence_get_trashed() && this.getSecurityPolicy().isUntrashable(user, (Node)this);
    }

    public void remove(User user) {
        Validate.isTrue((boolean)this.isRemovable(user), (String)"%s cannot be removed by %s, readonly=%s, secPolicy.isRemovable(user)=%s", (Object[])new Object[]{this, user, this._persistence_get_readOnly(), this.getSecurityPolicy().isRemovable(user, (Node)this)});
        this._persistence_set_removed(this.propertyUpdate(this._persistence_get_removed(), true));
    }

    public boolean isRemovable(User user) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isRemovable(user, (Node)this);
    }

    protected final void validateNotRemoved() {
        Validate.isTrue((!this._persistence_get_removed() ? 1 : 0) != 0, (String)"%s has been removed", (Object[])new Object[]{this});
    }

    public boolean isRenamable(User user) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isRenamable(user, (Node)this);
    }

    public boolean isRenamable(User user, String title) {
        return this.isRenamable(user);
    }

    public void rename(User user, String title) {
        Validate.isTrue((boolean)this.isRenamable(user), (String)"%s cannot be renamed", (Object[])new Object[]{this});
        this._persistence_set_title(this.propertyUpdate(this._persistence_get_title(), title));
    }

    public void setNotes(String notes) {
        this._persistence_set_notes(this.propertyUpdate(this._persistence_get_notes(), notes));
    }

    public boolean isNotesEditable(User user) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isNotesEditable(user, (Node)this);
    }

    public boolean isCopyable(User user) {
        return this.isReadable(user) && this.getSecurityPolicy().isCopyable(user, (Node)this);
    }

    public boolean isCopyableTo(User user, Folder newParent) {
        return this.isCopyable(user);
    }

    public abstract Node copy(User var1, Folder var2, User var3);

    public boolean isMovable(User user) {
        return !this._persistence_get_readOnly() && this.isReadable(user) && this.getSecurityPolicy().isMovable(user, (Node)this);
    }

    public boolean isMovableTo(User user, Folder newParent) {
        return this.isMovable(user) && !Objects.equals(this._persistence_get_parent(), newParent);
    }

    public void move(User user, Folder newParent) {
        this.move(user, newParent, true, true);
    }

    public void move(User user, Folder newParent, boolean removeFromOldParent, boolean addToNewParent) {
        log.debug("Moving {} to {} removeFromOldParent={} addToNewParent={}", new Object[]{this, newParent, removeFromOldParent, addToNewParent});
        this.validateNotRemoved();
        if (this.isMovableTo(user, newParent)) {
            if (removeFromOldParent) {
                this._persistence_get_parent().removeChild(this);
            }
            if (addToNewParent) {
                newParent.addChild(this);
            }
        } else {
            throw new IllegalArgumentException("Can not move " + this + " to " + newParent + ". movable=" + this.isMovable(user) + " isMovableTo(newParent)=" + this.isMovableTo(user, newParent) + " isReadOnly=" + this.isReadOnly());
        }
        this.setParent(newParent);
    }

    public abstract Long getSize();

    public final String getSizeDisplayValue() {
        return this.getSize() != null ? FileUtils.byteCountToDisplaySize((long)this.getSize()) : "";
    }

    public abstract Long getUsedSize();

    public final String getUsedSizeDisplayValue() {
        return this.getSize() != null ? FileUtils.byteCountToDisplaySize((long)this.getSize()) : "";
    }

    public abstract User getCreatedBy();

    public abstract Date getCreatedOn();

    public abstract User getModifiedBy();

    public abstract Date getModifiedOn();

    public String getTypeDisplayValue() {
        return this.getMimeType();
    }

    public abstract String getMimeType();

    public List<Folder> getParentPath() {
        ArrayList<Folder> path = new ArrayList<Folder>();
        Folder pathItem = this._persistence_get_parent();
        while (pathItem != null) {
            path.add(0, pathItem);
            pathItem = pathItem.parent;
        }
        return path;
    }

    public String getIdPath(boolean includeThis) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        for (Folder f : this.getParentPath()) {
            sb.append("/");
            sb.append(f.getId());
        }
        if (includeThis) {
            sb.append("/");
            sb.append(this.getId());
        }
        return sb.toString();
    }

    public String getTitlePath() {
        return this.getTitlePath(true);
    }

    public String getTitlePath(boolean includeThis) {
        StringBuilder sb = new StringBuilder();
        for (Folder f : this.getParentPath()) {
            sb.append("/");
            sb.append(f.getTitle());
        }
        if (includeThis) {
            sb.append("/");
            sb.append(this.getTitle());
        }
        return sb.toString();
    }

    protected final void changed() {
        Date now = new Date();
        this._persistence_set_changedOn(now);
        this._persistence_set_accessedOn(now);
    }

    public final void accessed() {
        this._persistence_set_accessedOn(new Date());
    }

    protected <T> T propertyUpdate(T oldValue, T newValue) {
        this.validateNotRemoved();
        if (!Objects.equals(oldValue, newValue)) {
            this.changed();
        }
        return newValue;
    }

    public <T extends StorageProvider> NodeStorage<T> getNodeStorage(T sp) {
        for (NodeStorage ns : this._persistence_get_storage()) {
            if (!((Base)ns.getProvider()).equals(sp)) continue;
            return ns;
        }
        return null;
    }

    public boolean isSynched(StorageProvider sp) {
        NodeStorage<StorageProvider> ns = this.getNodeStorage(sp);
        if (ns == null) {
            return false;
        }
        return ns.getSynchedChange().equals(this._persistence_get_changedOn());
    }

    public boolean isSynched(List<StorageProvider> providers) {
        for (StorageProvider provider : providers) {
            if (this.isSynched(provider)) continue;
            return false;
        }
        return true;
    }

    protected void copyBasicFields(@NonNull Node newState) {
        if (newState == null) {
            throw new NullPointerException("newState");
        }
        Validate.isTrue((boolean)newState.getClass().equals(this.getClass()));
        this._persistence_set_notes(newState._persistence_get_notes());
        this._persistence_set_readOnly(newState._persistence_get_readOnly());
        this._persistence_set_accessedOn(newState._persistence_get_accessedOn());
        this._persistence_set_changedOn(newState._persistence_get_changedOn());
        this._persistence_set_title(newState._persistence_get_title());
        this._persistence_set_trashed(newState._persistence_get_trashed());
        this._persistence_set_removed(newState._persistence_get_removed());
        this.basicFieldsUpdateReceived();
    }

    protected void basicFieldsUpdateReceived() {
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getTitle();
    }

    public String getDisplayValue() {
        return this._persistence_get_title();
    }

    public static Folder getCommonParent(List<Node> nodes) {
        List<Folder> path = nodes.get(0).getParentPath();
        block0: for (Node node : nodes) {
            List<Folder> nodePath = node.getParentPath();
            for (int i = 0; i < path.size(); ++i) {
                Folder curr = path.get(i);
                if (nodePath.get(i).equals(curr)) continue;
                path = path.subList(0, i - 1);
                continue block0;
            }
        }
        return path.get(path.size() - 1);
    }

    public static <T extends Node> Set<Folder> getAllParents(List<T> nodes) {
        HashSet<Folder> ret = new HashSet<Folder>();
        for (Node node : nodes) {
            ret.add(node.getParent());
        }
        return ret;
    }

    protected void parentUpdated() {
    }

    public Folder getParent() {
        return this._persistence_get_parent();
    }

    public String getTitle() {
        return this._persistence_get_title();
    }

    public String getNotes() {
        return this._persistence_get_notes();
    }

    public boolean isReadOnly() {
        return this._persistence_get_readOnly();
    }

    public boolean isTrashed() {
        return this._persistence_get_trashed();
    }

    public boolean isRemoved() {
        return this._persistence_get_removed();
    }

    public List<NodeStorage> getStorage() {
        return this._persistence_get_storage();
    }

    public List<NodeEvent> getEvents() {
        return this._persistence_get_events();
    }

    public boolean isSecurityPolicyDisabled() {
        return this.securityPolicyDisabled;
    }

    public void setTitle(String title) {
        this._persistence_set_title(title);
    }

    public void setTrashed(boolean trashed) {
        this._persistence_set_trashed(trashed);
    }

    public void setRemoved(boolean removed) {
        this._persistence_set_removed(removed);
    }

    public void setStorage(List<NodeStorage> storage) {
        this._persistence_set_storage(storage);
    }

    public void setEvents(List<NodeEvent> events) {
        this._persistence_set_events(events);
    }

    public void setSecurityPolicyDisabled(boolean securityPolicyDisabled) {
        this.securityPolicyDisabled = securityPolicyDisabled;
    }

    protected Node() {
    }

    public Date getAccessedOn() {
        return this._persistence_get_accessedOn();
    }

    protected void setAccessedOn(Date accessedOn) {
        this._persistence_set_accessedOn(accessedOn);
    }

    public Date getChangedOn() {
        return this._persistence_get_changedOn();
    }

    protected void setChangedOn(Date changedOn) {
        this._persistence_set_changedOn(changedOn);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Node();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "parent") {
            return this.parent;
        }
        if (string == "notes") {
            return this.notes;
        }
        if (string == "removed") {
            return this.removed;
        }
        if (string == "accessedOn") {
            return this.accessedOn;
        }
        if (string == "readOnly") {
            return this.readOnly;
        }
        if (string == "storage") {
            return this.storage;
        }
        if (string == "title") {
            return this.title;
        }
        if (string == "changedOn") {
            return this.changedOn;
        }
        if (string == "events") {
            return this.events;
        }
        if (string == "trashed") {
            return this.trashed;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "parent") {
            this.parent = (Folder)object;
            return;
        }
        if (string == "notes") {
            this.notes = (String)object;
            return;
        }
        if (string == "removed") {
            this.removed = (Boolean)object;
            return;
        }
        if (string == "accessedOn") {
            this.accessedOn = (Date)object;
            return;
        }
        if (string == "readOnly") {
            this.readOnly = (Boolean)object;
            return;
        }
        if (string == "storage") {
            this.storage = (List)object;
            return;
        }
        if (string == "title") {
            this.title = (String)object;
            return;
        }
        if (string == "changedOn") {
            this.changedOn = (Date)object;
            return;
        }
        if (string == "events") {
            this.events = (List)object;
            return;
        }
        if (string == "trashed") {
            this.trashed = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Folder _persistence_get_parent() {
        this._persistence_checkFetched("parent");
        return this.parent;
    }

    public void _persistence_set_parent(Folder folder) {
        this._persistence_checkFetchedForSet("parent");
        this._persistence_propertyChange("parent", this.parent, folder);
        this.parent = folder;
    }

    public String _persistence_get_notes() {
        this._persistence_checkFetched("notes");
        return this.notes;
    }

    public void _persistence_set_notes(String string) {
        this._persistence_checkFetchedForSet("notes");
        this._persistence_propertyChange("notes", this.notes, string);
        this.notes = string;
    }

    public boolean _persistence_get_removed() {
        this._persistence_checkFetched("removed");
        return this.removed;
    }

    public void _persistence_set_removed(boolean bl) {
        this._persistence_checkFetchedForSet("removed");
        this._persistence_propertyChange("removed", new Boolean(this.removed), new Boolean(bl));
        this.removed = bl;
    }

    public Date _persistence_get_accessedOn() {
        this._persistence_checkFetched("accessedOn");
        return this.accessedOn;
    }

    public void _persistence_set_accessedOn(Date date) {
        this._persistence_checkFetchedForSet("accessedOn");
        this._persistence_propertyChange("accessedOn", this.accessedOn, date);
        this.accessedOn = date;
    }

    public boolean _persistence_get_readOnly() {
        this._persistence_checkFetched("readOnly");
        return this.readOnly;
    }

    public void _persistence_set_readOnly(boolean bl) {
        this._persistence_checkFetchedForSet("readOnly");
        this._persistence_propertyChange("readOnly", new Boolean(this.readOnly), new Boolean(bl));
        this.readOnly = bl;
    }

    public List _persistence_get_storage() {
        this._persistence_checkFetched("storage");
        return this.storage;
    }

    public void _persistence_set_storage(List list) {
        this._persistence_checkFetchedForSet("storage");
        this._persistence_propertyChange("storage", this.storage, list);
        this.storage = list;
    }

    public String _persistence_get_title() {
        this._persistence_checkFetched("title");
        return this.title;
    }

    public void _persistence_set_title(String string) {
        this._persistence_checkFetchedForSet("title");
        this._persistence_propertyChange("title", this.title, string);
        this.title = string;
    }

    public Date _persistence_get_changedOn() {
        this._persistence_checkFetched("changedOn");
        return this.changedOn;
    }

    public void _persistence_set_changedOn(Date date) {
        this._persistence_checkFetchedForSet("changedOn");
        this._persistence_propertyChange("changedOn", this.changedOn, date);
        this.changedOn = date;
    }

    public List _persistence_get_events() {
        this._persistence_checkFetched("events");
        return this.events;
    }

    public void _persistence_set_events(List list) {
        this._persistence_checkFetchedForSet("events");
        this._persistence_propertyChange("events", this.events, list);
        this.events = list;
    }

    public boolean _persistence_get_trashed() {
        this._persistence_checkFetched("trashed");
        return this.trashed;
    }

    public void _persistence_set_trashed(boolean bl) {
        this._persistence_checkFetchedForSet("trashed");
        this._persistence_propertyChange("trashed", new Boolean(this.trashed), new Boolean(bl));
        this.trashed = bl;
    }
}

