/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.util.io.AnahataFileUtils;
import com.anahata.util.lang.Nvl;
import com.anahata.util.model.ActivePredicate;
import com.anahata.yam.model.dms.Document;
import com.anahata.yam.model.dms.DocumentLockedException;
import com.anahata.yam.model.dms.FolderId;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.NodeEvent;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.model.dms.security.FolderSecurityPolicy;
import com.anahata.yam.model.user.User;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="FOL")
public class Folder
extends Node
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(Folder.class);
    @ManyToOne
    @NotNull
    private User createdBy;
    @ManyToOne
    User modifiedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    Date createdOn = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    Date modifiedOn;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    private List<Folder> folders = new ArrayList<Folder>();
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
    private List<Document> documents = new ArrayList<Document>();
    private Long quota;
    @Transient
    private boolean includeTrashedChildren = true;
    @Transient
    private transient User loggedInUser = null;
    private static final AllowAllFolderSecurityPolicy ALLOW_ALL_SECURITY_POLICY = new AllowAllFolderSecurityPolicy();
    static final long serialVersionUID = 4471734722761102229L;

    public Folder(Long id) {
        super(id);
    }

    protected Folder(@NonNull String title, @NonNull User createdBy) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (createdBy == null) {
            throw new NullPointerException("createdBy");
        }
        this.setTitle(title);
        this.createdBy = createdBy;
    }

    public Folder(Folder parent, @NonNull String title, @NonNull User createdBy) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (createdBy == null) {
            throw new NullPointerException("createdBy");
        }
        this.setTitle(title);
        this.parent = parent;
        this.createdBy = createdBy;
    }

    public Folder(Long id, @NonNull String title, @NonNull User createdBy) {
        super(id);
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (createdBy == null) {
            throw new NullPointerException("createdBy");
        }
        if (id != null) {
            Validate.isTrue((id < 0L ? 1 : 0) != 0, (String)"Custom ids must be less than zero", (Object[])new Object[0]);
        }
        this.setTitle(title);
        this.createdBy = createdBy;
    }

    protected FolderSecurityPolicy getCustomSecurityPolicy() {
        return null;
    }

    protected FolderSecurityPolicy getCustomSecurityPolicy(Enum id) {
        return null;
    }

    public final FolderSecurityPolicy getSecurityPolicy() {
        FolderSecurityPolicy custom = this.getCustomSecurityPolicy();
        FolderSecurityPolicy effectieve = custom != null ? custom : ALLOW_ALL_SECURITY_POLICY;
        return this.isSecurityPolicyEnabled() ? effectieve : ALLOW_ALL_SECURITY_POLICY;
    }

    public final FolderSecurityPolicy getSecurityPolicy(Enum id) {
        FolderSecurityPolicy custom = this.getCustomSecurityPolicy(id);
        FolderSecurityPolicy effectieve = custom != null ? custom : this.getSecurityPolicy();
        return this.isSecurityPolicyEnabled() ? effectieve : ALLOW_ALL_SECURITY_POLICY;
    }

    public static Folder newRoot(String title, @NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        Folder folder = new Folder(FolderId.ROOT.getId(), title, user);
        return folder;
    }

    public final boolean isRoot() {
        return this.getId().longValue() == FolderId.ROOT.getId();
    }

    public int getIndexInParent() {
        return this._persistence_get_parent().getFolders().indexOf(this);
    }

    @Override
    public boolean isMovableTo(@NonNull User user, @NonNull Folder newParent) {
        boolean movable;
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (newParent == null) {
            throw new NullPointerException("newParent");
        }
        boolean superMovable = super.isMovableTo(user, newParent);
        boolean parentCanAddFolder = newParent.isCanAddFolder(user, newParent);
        boolean bl = movable = superMovable && !parentCanAddFolder;
        if (!movable) {
            log.warn("Folder {} not movable to {} by {}. superMovable={} parentCanAddFolder={}", new Object[]{this, newParent, user, superMovable, parentCanAddFolder});
        } else {
            log.debug("Folder {} movable to {} by {}. ", new Object[]{this, newParent, user});
        }
        return movable;
    }

    @Override
    public boolean isCopyableTo(User user, Folder newParent) {
        return super.isCopyableTo(user, newParent) && newParent.isCanAddFolder(user, newParent);
    }

    @Override
    public Folder copy(User user, Folder parent, User copiedBy) {
        if (this.isCopyableTo(user, parent)) {
            Folder copy = this.newCopyFolder();
            copy.setTitle(this._persistence_get_title());
            copy._persistence_set_createdBy(copiedBy);
            copy = parent.addFolder(copiedBy, copy);
            for (Node n : this.getChildNodes(user, false)) {
                n.copy(user, copy, copiedBy);
            }
            return copy;
        }
        throw new IllegalArgumentException("Can not copy " + this + " to " + parent);
    }

    protected Folder newCopyFolder() {
        try {
            return (Folder)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCanCreateFolder(User user) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isCanAddFolder(user, null, this);
    }

    public boolean isCanAddFolder(User user, Folder folder) {
        return !this._persistence_get_readOnly() && !folder.equals(this) && !this.getParentPath().contains(folder) && this.isCanIncreaseQuota(folder) && this.getSecurityPolicy().isCanAddFolder(user, folder, this);
    }

    public Folder newFolder() {
        return new Folder();
    }

    public final Folder addFolder(@NonNull String title, @NonNull User createdBy) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (createdBy == null) {
            throw new NullPointerException("createdBy");
        }
        return this.addFolder(null, title, createdBy);
    }

    public final Folder addFolder(Long id, @NonNull String title, @NonNull User createdBy) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (createdBy == null) {
            throw new NullPointerException("createdBy");
        }
        Folder folder = this.newFolder();
        folder.setId(id);
        folder.setTitle(title);
        folder._persistence_set_createdBy(createdBy);
        return this.addFolder(createdBy, folder);
    }

    public Folder addFolder(User user, Folder folder) {
        Validate.isTrue((boolean)this.isCanAddFolder(user, folder), (String)"Folder %s cannot be added by %s to %s", (Object[])new Object[]{folder, user, this});
        folder.setParent(this);
        this._persistence_get_folders().add(folder);
        return folder;
    }

    @Override
    public void remove(User user) {
        super.remove(user);
        this.getChildDocuments().stream().forEach(doc -> doc.remove(user));
        this.getChildFolders().stream().forEach(fol -> fol.remove(user));
    }

    public boolean isCanAddDocument(User user) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isCanAddDocument(user, null, this);
    }

    public boolean isCanAddDocument(User user, Document document) {
        return !this._persistence_get_readOnly() && this.getSecurityPolicy().isCanAddDocument(user, document, this) && this.isCanIncreaseQuota(document);
    }

    public List<String> getValidExtensionsForNewDocuments() {
        return this.newDocument().getValidExtensions();
    }

    public List<String> getPreferredExtensionsForNewDocuments() {
        return this.newDocument().getPreferredExtensions();
    }

    public boolean isValidExtensionForNewDocument(String ext) {
        return Document.matchesExtension(this.getValidExtensionsForNewDocuments(), ext);
    }

    public boolean isPreferredExtensionForNewDocument(String ext) {
        return Document.matchesExtension(this.getPreferredExtensionsForNewDocuments(), ext);
    }

    public Document newDocument(File file) {
        return this.newDocument();
    }

    public Document newDocument() {
        return new Document();
    }

    public Document addDocument(@NonNull byte[] data, @NonNull String name, @NonNull User user) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (user == null) {
            throw new NullPointerException("user");
        }
        Revision r = new Revision(data, name, user);
        return this.addDocument(user, r);
    }

    public <T extends Document> void addDocument(@NonNull User user, @NonNull Document document, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        document.getHeadRevision().getMirrors().add(mirror);
        mirror.getRevisionsPendingUpload().add(document.getHeadRevision());
        this.addDocument(user, document);
    }

    private Document addDocument(User user, Revision firstRevision) {
        Document document = this.newDocument();
        try {
            document.addRevision(firstRevision);
        }
        catch (DocumentLockedException e) {
            log.error("Unexpected DocumentLockedException when adding first revision to document", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.addDocument(user, document);
        return document;
    }

    public void addDocument(User user, Document doc) {
        Validate.isTrue((boolean)this.isCanAddDocument(user, doc), (String)"Document %s cannot be added by %s to %s. readOnly=%s, policy=%s, quota=%s", (Object[])new Object[]{doc, user, this, this._persistence_get_readOnly(), this.getSecurityPolicy().isCanAddDocument(user, doc, this), this.isCanIncreaseQuota(doc)});
        doc.setParent(this);
        this._persistence_get_documents().add(doc);
        doc.parentUpdated();
        this.documentAdded(doc);
    }

    protected void documentAdded(Document doc) {
    }

    public List<Folder> getChildFolders() {
        return this.getChildFolders(this.loggedInUser, this.includeTrashedChildren);
    }

    public List<Folder> getChildFolders(User user, boolean includeTrashed) {
        List ret = Folder.nonRemoved(this._persistence_get_folders());
        if (user != null) {
            ret = Folder.readable(ret, user);
        }
        if (!includeTrashed) {
            ret = ActivePredicate.list(ret);
        }
        return Collections.unmodifiableList(ret);
    }

    public <T extends Folder> T findChildFolderByType(Class<T> folderType) {
        T t = null;
        for (Folder f : this.getChildFolders(null, false)) {
            if (!folderType.isInstance(f)) continue;
            return (T)f;
        }
        for (Folder f : this.getChildFolders(null, false)) {
            t = f.findChildFolderByType(folderType);
            if (t == null) continue;
            return t;
        }
        return t;
    }

    public List<Document> getChildDocuments() {
        return this.getChildDocuments(this.loggedInUser, this.includeTrashedChildren);
    }

    public List<Document> getActiveChildDocuments() {
        return this.getChildDocuments(this.loggedInUser, false);
    }

    public List<Document> getChildDocuments(User user, boolean includeTrashed) {
        List ret = Folder.nonRemoved(this._persistence_get_documents());
        if (!includeTrashed) {
            ret = ActivePredicate.list(ret);
        }
        if (user != null) {
            ret = Folder.readable(ret, user);
        }
        return Collections.unmodifiableList(ret);
    }

    public <T extends Document> T findChildDocumentByType(Class<T> documentType) {
        T t = null;
        for (Document document : this.getChildDocuments()) {
            if (!documentType.isInstance(document)) continue;
            return (T)document;
        }
        for (Folder folder : this.getChildFolders()) {
            t = folder.findChildDocumentByType(documentType);
            if (t == null) continue;
            return t;
        }
        return t;
    }

    public Document findLatestDocumentByExtension(String extension) {
        return this.findLatestDocumentByExtension(extension, false);
    }

    public Document findLatestDocumentByExtension(String extension, boolean includeDeleted) {
        Document ret = null;
        for (Document d : this.getChildDocuments(null, includeDeleted)) {
            if (!d.getTitle().toLowerCase().endsWith(extension) || ret != null && !d.getCreatedOn().after(ret.getCreatedOn())) continue;
            ret = d;
        }
        return ret;
    }

    public List<Node> getChildNodes() {
        ArrayList<Folder> all = new ArrayList<Folder>(this.getChildFolders(this.loggedInUser, this.includeTrashedChildren));
        all.addAll(this.getChildDocuments(this.loggedInUser, this.includeTrashedChildren));
        return Collections.unmodifiableList(all);
    }

    public List<Node> getChildNodes(User user, boolean includeTrashed) {
        ArrayList<Folder> all = new ArrayList<Folder>(this.getChildFolders(user, includeTrashed));
        all.addAll(this.getChildDocuments(user, includeTrashed));
        return Collections.unmodifiableList(all);
    }

    void addChild(Node node) {
        if (node instanceof Document) {
            this._persistence_get_documents().add((Document)node);
        } else if (node instanceof Folder) {
            this._persistence_get_folders().add((Folder)node);
        } else {
            throw new IllegalArgumentException("Unsupported node type " + node);
        }
    }

    void removeChild(Node node) {
        if (node instanceof Document) {
            this._persistence_get_documents().remove((Document)node);
        } else if (node instanceof Folder) {
            this._persistence_get_folders().remove((Folder)node);
        } else {
            throw new IllegalArgumentException("Unsupported node type " + node);
        }
    }

    protected static <T extends Node> List<T> readable(List<T> nodes, User user) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!node.isReadable(user)) continue;
            ret.add(node);
        }
        return Collections.unmodifiableList(ret);
    }

    protected static <T extends Node> List<T> nonRemoved(List<T> nodes) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node.isRemoved()) continue;
            ret.add(node);
        }
        return Collections.unmodifiableList(ret);
    }

    public Node find(long id) {
        return this.find(id, true);
    }

    public Node find(long id, boolean recurseDown) {
        if (this.getId() == id) {
            return this;
        }
        for (Node node : this.getChildNodes(null, true)) {
            if (node.getId() == null || node.getId() != id) continue;
            return node;
        }
        for (Folder folder : this.getChildFolders(null, true)) {
            Node node;
            if (!recurseDown || (node = folder.find(id)) == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public Long getSize() {
        Long ret = 0L;
        for (Document document : this._persistence_get_documents()) {
            if (document.isRemoved()) continue;
            Long size = document.getSize();
            if (size != null) {
                ret = ret + size;
                continue;
            }
            log.error("{} Could not get size of document {} ", (Object)this, (Object)document);
        }
        for (Folder folder : this._persistence_get_folders()) {
            ret = ret + folder.getSize();
        }
        return ret;
    }

    private boolean isDocumentsFetched() {
        try {
            this._persistence_get_documents().size();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Long getUsedSize() {
        Long ret = 0L;
        if (!this.isDocumentsFetched()) {
            return ret;
        }
        for (Document document : this._persistence_get_documents()) {
            if (document.isRemoved()) continue;
            ret = ret + document.getUsedSize();
        }
        for (Folder folder : this._persistence_get_folders()) {
            ret = ret + folder.getUsedSize();
        }
        return ret;
    }

    public Long getRemainingQuota() {
        if (this._persistence_get_quota() == null) {
            return null;
        }
        if (this.isDocumentsFetched()) {
            Long ret = this._persistence_get_quota() - this.getUsedSize();
            return ret;
        }
        return null;
    }

    public Long getEffectiveRemainingQuota() {
        Long minQuota = this.getRemainingQuota();
        for (Folder f : this.getParentPath()) {
            Long frq = f.getRemainingQuota();
            if (frq == null || minQuota != null && frq >= minQuota) continue;
            minQuota = frq;
        }
        return minQuota;
    }

    public boolean isCanIncreaseQuota(Revision revision) {
        if (this.getEffectiveRemainingQuota() == null) {
            return true;
        }
        return revision.getFileSize() <= this.getEffectiveRemainingQuota();
    }

    public boolean isCanIncreaseQuota(Node node) {
        if (this.getEffectiveRemainingQuota() == null) {
            return true;
        }
        return node.getUsedSize() <= this.getEffectiveRemainingQuota();
    }

    @Override
    public String getMimeType() {
        return null;
    }

    public boolean isAllDocumentsUploaded(boolean recursive) {
        for (Document document : this._persistence_get_documents()) {
            if (document.getHeadRevision().isUploaded()) continue;
            return false;
        }
        if (recursive) {
            for (Folder folder : this._persistence_get_folders()) {
                if (folder.isAllDocumentsUploaded(recursive)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + " id=");
        sb.append(this.getId());
        sb.append(" ");
        sb.append(super.getTitlePath());
        return sb.toString();
    }

    public List<NodeEvent> getEventsRecursively() {
        ArrayList<NodeEvent> events = new ArrayList<NodeEvent>();
        events.addAll(this.getEvents());
        for (Folder folder : this._persistence_get_folders()) {
            events.addAll(folder.getEventsRecursively());
        }
        for (Document document : this._persistence_get_documents()) {
            events.addAll(document.getEvents());
        }
        return events;
    }

    @Override
    protected void copyBasicFields(Node newState) {
        Folder newStateFolder = (Folder)newState;
        this._persistence_set_quota(newStateFolder._persistence_get_quota());
        this._persistence_set_modifiedBy(newStateFolder._persistence_get_modifiedBy());
        this._persistence_set_modifiedOn(newStateFolder._persistence_get_modifiedOn());
        super.copyBasicFields(newState);
    }

    protected void childUpdateReceived() {
        log.debug("Folder childUpdateReceived");
    }

    public List<String> getAddFileValidationErrors(@NonNull User user, Folder folder, List<File> files) {
        long totalSize;
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (folder == null) {
            folder = this;
        }
        ArrayList<String> ret = new ArrayList<String>();
        Long erq = folder.getEffectiveRemainingQuota();
        if (erq != null && (totalSize = AnahataFileUtils.getTotalSize(files)) >= erq) {
            ret.add("Insuficcient Quota");
            return ret;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                if (!folder.isCanCreateFolder(user)) {
                    ret.add("Folder " + f.getPath() + " cannot be created under " + folder.getTitle());
                } else {
                    Folder dryRun = folder.newFolder();
                    dryRun.setParent(folder);
                    ret.addAll(this.getAddFileValidationErrors(user, dryRun, Arrays.asList(f.listFiles())));
                }
            } else {
                String ext = FilenameUtils.getExtension((String)f.getName());
                if (!folder.isValidExtensionForNewDocument(ext)) {
                    ret.add("Document " + f.getPath() + " cannot be added to " + folder.getTitle() + " as its extension '" + Nvl.nvl((String)ext) + "' is not one of: " + folder.getValidExtensionsForNewDocuments());
                    continue;
                }
                Document dryRun = folder.newDocument(f);
                if (!folder.isCanAddDocument(user, dryRun)) {
                    ret.add("Document " + f.getPath() + " cannot be added to " + folder.getTitle());
                    continue;
                }
            }
            if (ret.size() <= 5) continue;
            break;
        }
        return ret;
    }

    @AssertTrue
    public boolean assertParentNotNull() {
        return this._persistence_get_parent() != null || this.isRoot();
    }

    @Override
    public User getCreatedBy() {
        return this._persistence_get_createdBy();
    }

    @Override
    public User getModifiedBy() {
        return this._persistence_get_modifiedBy();
    }

    @Override
    public Date getCreatedOn() {
        return this._persistence_get_createdOn();
    }

    @Override
    public Date getModifiedOn() {
        return this._persistence_get_modifiedOn();
    }

    public Folder() {
    }

    public void setCreatedBy(User createdBy) {
        this._persistence_set_createdBy(createdBy);
    }

    protected List<Folder> getFolders() {
        return this._persistence_get_folders();
    }

    protected List<Document> getDocuments() {
        return this._persistence_get_documents();
    }

    public void setQuota(Long quota) {
        this._persistence_set_quota(quota);
    }

    public Long getQuota() {
        return this._persistence_get_quota();
    }

    public void setIncludeTrashedChildren(boolean includeTrashedChildren) {
        this.includeTrashedChildren = includeTrashedChildren;
    }

    public boolean isIncludeTrashedChildren() {
        return this.includeTrashedChildren;
    }

    public void setLoggedInUser(User loggedInUser) {
        this.loggedInUser = loggedInUser;
    }

    public User getLoggedInUser() {
        return this.loggedInUser;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Folder();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "modifiedOn") {
            return this.modifiedOn;
        }
        if (string == "folders") {
            return this.folders;
        }
        if (string == "createdBy") {
            return this.createdBy;
        }
        if (string == "documents") {
            return this.documents;
        }
        if (string == "quota") {
            return this.quota;
        }
        if (string == "modifiedBy") {
            return this.modifiedBy;
        }
        if (string == "createdOn") {
            return this.createdOn;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "modifiedOn") {
            this.modifiedOn = (Date)object;
            return;
        }
        if (string == "folders") {
            this.folders = (List)object;
            return;
        }
        if (string == "createdBy") {
            this.createdBy = (User)object;
            return;
        }
        if (string == "documents") {
            this.documents = (List)object;
            return;
        }
        if (string == "quota") {
            this.quota = (Long)object;
            return;
        }
        if (string == "modifiedBy") {
            this.modifiedBy = (User)object;
            return;
        }
        if (string == "createdOn") {
            this.createdOn = (Date)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_modifiedOn() {
        this._persistence_checkFetched("modifiedOn");
        return this.modifiedOn;
    }

    public void _persistence_set_modifiedOn(Date date) {
        this._persistence_checkFetchedForSet("modifiedOn");
        this._persistence_propertyChange("modifiedOn", this.modifiedOn, date);
        this.modifiedOn = date;
    }

    public List _persistence_get_folders() {
        this._persistence_checkFetched("folders");
        return this.folders;
    }

    public void _persistence_set_folders(List list) {
        this._persistence_checkFetchedForSet("folders");
        this._persistence_propertyChange("folders", this.folders, list);
        this.folders = list;
    }

    public User _persistence_get_createdBy() {
        this._persistence_checkFetched("createdBy");
        return this.createdBy;
    }

    public void _persistence_set_createdBy(User user) {
        this._persistence_checkFetchedForSet("createdBy");
        this._persistence_propertyChange("createdBy", this.createdBy, user);
        this.createdBy = user;
    }

    public List _persistence_get_documents() {
        this._persistence_checkFetched("documents");
        return this.documents;
    }

    public void _persistence_set_documents(List list) {
        this._persistence_checkFetchedForSet("documents");
        this._persistence_propertyChange("documents", this.documents, list);
        this.documents = list;
    }

    public Long _persistence_get_quota() {
        this._persistence_checkFetched("quota");
        return this.quota;
    }

    public void _persistence_set_quota(Long l) {
        this._persistence_checkFetchedForSet("quota");
        this._persistence_propertyChange("quota", this.quota, l);
        this.quota = l;
    }

    public User _persistence_get_modifiedBy() {
        this._persistence_checkFetched("modifiedBy");
        return this.modifiedBy;
    }

    public void _persistence_set_modifiedBy(User user) {
        this._persistence_checkFetchedForSet("modifiedBy");
        this._persistence_propertyChange("modifiedBy", this.modifiedBy, user);
        this.modifiedBy = user;
    }

    public Date _persistence_get_createdOn() {
        this._persistence_checkFetched("createdOn");
        return this.createdOn;
    }

    public void _persistence_set_createdOn(Date date) {
        this._persistence_checkFetchedForSet("createdOn");
        this._persistence_propertyChange("createdOn", this.createdOn, date);
        this.createdOn = date;
    }

    public static class AllowAllFolderSecurityPolicy
    implements FolderSecurityPolicy<Folder> {
    }
}

