/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.NodeEvent;
import com.anahata.yam.model.dms.NodeEventType;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.user.User;
import java.io.Serializable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="DOCUMENT")
@NodeEventType(description="Generic Document Event")
public class DocumentEvent<T extends Node>
extends NodeEvent<T>
implements Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(DocumentEvent.class);
    @NotNull
    @ManyToOne
    private Revision revision;
    static final long serialVersionUID = -4503596418384987695L;

    public DocumentEvent(@NonNull Revision revision, @NonNull User user) {
        super(revision.getDocument(), user);
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.revision = revision;
    }

    public Revision getRevision() {
        return this._persistence_get_revision();
    }

    public void setRevision(Revision revision) {
        this._persistence_set_revision(revision);
    }

    protected DocumentEvent() {
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentEvent<T>();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "revision") {
            return this.revision;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "revision") {
            this.revision = (Revision)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Revision _persistence_get_revision() {
        this._persistence_checkFetched("revision");
        return this.revision;
    }

    public void _persistence_set_revision(Revision revision) {
        this._persistence_checkFetchedForSet("revision");
        this._persistence_propertyChange("revision", this.revision, revision);
        this.revision = revision;
    }
}

