/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.dms;

import com.anahata.util.lang.Nvl;
import com.anahata.yam.model.dms.DocumenNotEditableException;
import com.anahata.yam.model.dms.DocumentLockedException;
import com.anahata.yam.model.dms.Folder;
import com.anahata.yam.model.dms.Node;
import com.anahata.yam.model.dms.Revision;
import com.anahata.yam.model.dms.RevisionSynchStatus;
import com.anahata.yam.model.dms.mirror.Mirror;
import com.anahata.yam.model.dms.security.DocumentSecurityPolicy;
import com.anahata.yam.model.user.User;
import com.google.common.base.Objects;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="DOC")
public class Document
extends Node
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    private static final AllowAllDocumentSecurityPolicy ALLOW_ALL_SECURITY_POLICY = new AllowAllDocumentSecurityPolicy();
    @ManyToOne
    @JoinColumn(name="LOCKEDBY_ID")
    private User lockedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lockedOn;
    @ManyToOne
    private Mirror workingCopyMirror;
    private String workingCopyPath;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date workingCopyModifiedOn;
    @OneToMany(mappedBy="document", cascade={CascadeType.ALL})
    @Size(min=1)
    private List<Revision> revisions = new ArrayList<Revision>();
    static final long serialVersionUID = 4533032180262019888L;

    public Document(Long id) {
        super(id);
    }

    public Document(@NonNull Revision firstRevision) {
        if (firstRevision == null) {
            throw new NullPointerException("firstRevision");
        }
        this.addRevision(firstRevision);
    }

    protected DocumentSecurityPolicy getCustomSecurityPolicy() {
        return null;
    }

    protected DocumentSecurityPolicy getCustomSecurityPolicy(Enum id) {
        return null;
    }

    public final DocumentSecurityPolicy getSecurityPolicy() {
        DocumentSecurityPolicy custom = this.getCustomSecurityPolicy();
        DocumentSecurityPolicy effectieve = custom != null ? custom : ALLOW_ALL_SECURITY_POLICY;
        return this.isSecurityPolicyEnabled() ? effectieve : ALLOW_ALL_SECURITY_POLICY;
    }

    public final DocumentSecurityPolicy getSecurityPolicy(Enum id) {
        DocumentSecurityPolicy custom = this.getCustomSecurityPolicy(id);
        DocumentSecurityPolicy effectieve = custom != null ? custom : this.getSecurityPolicy();
        return this.isSecurityPolicyEnabled() ? effectieve : ALLOW_ALL_SECURITY_POLICY;
    }

    public int getIndexInParent() {
        return this._persistence_get_parent().getDocuments().indexOf(this);
    }

    @Override
    public Document copy(User user, Folder parent, User addedBy) {
        Revision revisionCopy = this.getHeadRevision().copy(addedBy);
        Document d = this.newCopyDocument();
        d.addRevision(revisionCopy);
        d.setTitle(this.getTitle());
        d.setParent(parent);
        parent.addChild(d);
        if (parent.equals(this._persistence_get_parent())) {
            String extension = this.getExtension();
            if (!StringUtils.isBlank((CharSequence)extension)) {
                extension = "." + extension;
            }
            d.setTitle(d.getBaseName() + " (copy)" + extension);
        }
        return d;
    }

    protected Document newCopyDocument() {
        try {
            return (Document)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isTrashable(User user) {
        return super.isRemovable(user) && !this.isWorkInProgress();
    }

    public String getBaseName() {
        return FilenameUtils.getBaseName((String)this.getTitle());
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this.getTitle());
    }

    @Override
    public boolean isRenamable(User user, String title) {
        String ext = FilenameUtils.getExtension((String)title);
        return super.isRenamable(user) && this.isValidExtension(ext);
    }

    public List<String> getValidExtensions() {
        return null;
    }

    public List<String> getPreferredExtensions() {
        return null;
    }

    public boolean isValidExtension(String ext) {
        return Document.matchesExtension(this.getValidExtensions(), ext);
    }

    static boolean matchesExtension(List<String> extensionList, String ext) {
        if (extensionList == null) {
            return true;
        }
        String ext2 = Nvl.nvl((String)ext).toLowerCase();
        return extensionList.stream().filter(e -> Nvl.nvl((String)e).toLowerCase().equals(ext2)).findAny().isPresent();
    }

    @Override
    public String getMimeType() {
        Revision head = this.getHeadRevision();
        Validate.notNull((Object)head, (String)"No head revision found for %s. revisions: %s", (Object[])new Object[]{this, this._persistence_get_revisions()});
        return head.getMimeType();
    }

    @Override
    public String getTypeDisplayValue() {
        return this.getClass().equals(Document.class) ? this.getMimeType() : this.getClass().getSimpleName() + " " + this.getMimeType();
    }

    @Override
    public boolean isRemovable(User user) {
        return super.isRemovable(user) && !this.isWorkInProgress();
    }

    @Override
    public boolean isMovableTo(@NonNull User user, @NonNull Folder newParent) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (newParent == null) {
            throw new NullPointerException("newParent");
        }
        return super.isMovableTo(user, newParent) && newParent.isCanAddDocument(user, this);
    }

    @Override
    public boolean isCopyableTo(User user, Folder newParent) {
        return super.isCopyableTo(user, newParent) && newParent.isCanAddDocument(user, this);
    }

    @Override
    public final User getCreatedBy() {
        Revision current = this.getFirstRevision();
        return current != null ? current.getAddedBy() : null;
    }

    @Override
    public final Date getCreatedOn() {
        Revision current = this.getFirstRevision();
        return current != null ? current.getCreatedOn() : null;
    }

    @Override
    public final User getModifiedBy() {
        Revision current = this.getHeadRevision();
        return current != null ? current.getAddedBy() : null;
    }

    @Override
    public final Date getModifiedOn() {
        Revision current = this.getHeadRevision();
        Date revModifiedOn = current != null ? current.getModifiedOn() : null;
        Date nodeModifedOn = this._persistence_get_changedOn();
        if (revModifiedOn == null || nodeModifedOn.after(revModifiedOn)) {
            return nodeModifedOn;
        }
        return revModifiedOn;
    }

    @Override
    public Long getSize() {
        return this.getHeadRevision() != null ? this.getHeadRevision().getFileSize() : null;
    }

    @Override
    public Long getUsedSize() {
        Long ret = 0L;
        for (Revision r : this.getRevisions()) {
            ret = ret + r.getFileSize();
        }
        return ret;
    }

    public final boolean isUploaded() {
        Revision current = this.getHeadRevision();
        return current != null ? current.isUploaded() : false;
    }

    public RevisionSynchStatus getSynchStatus() {
        Revision head = this.getHeadRevision();
        Validate.notNull((Object)head, (String)"No head revision found for %s. revisions: %s", (Object[])new Object[]{this, this._persistence_get_revisions()});
        return head.getSynchStatus();
    }

    public double getUploadProgress() {
        return this.getHeadRevision().getUploadProgress().floatValue();
    }

    public List<Revision> getRevisions() {
        Collections.sort(this._persistence_get_revisions(), (a, b) -> a.getNumber().compareTo(b.getNumber()));
        return this._persistence_get_revisions();
    }

    public final Revision getFirstRevision() {
        return this.getRevisions().get(0);
    }

    public final Revision getHeadRevision() {
        return !this._persistence_get_revisions().isEmpty() ? this.getRevisions().get(this._persistence_get_revisions().size() - 1) : null;
    }

    public boolean isCanAddRevision(@NonNull User user, Revision r) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return !(this.isLocked() && !this.isLockedBy(user) || !this.getSecurityPolicy().isCanAddRevision(user, this) || r != null && this._persistence_get_parent() != null && !this._persistence_get_parent().isCanIncreaseQuota(r) || r != null && !this.isValidExtension(r.getExtension()));
    }

    public final Revision addRevision(@NonNull Revision r) throws DocumentLockedException {
        if (r == null) {
            throw new NullPointerException("r");
        }
        return this.addRevision(r, null);
    }

    public final Revision addRevision(@NonNull Revision r, Mirror mirror) throws DocumentLockedException {
        if (r == null) {
            throw new NullPointerException("r");
        }
        Validate.isTrue((boolean)this.isCanAddRevision(r.getAddedBy(), r));
        if (this.isLocked() && !r.getAddedBy().equals(this._persistence_get_lockedBy())) {
            this.throwDocumentLockedException();
        }
        if (!this._persistence_get_revisions().contains(r)) {
            r.setDocument(this);
            r.setNumber(this._persistence_get_revisions().size() + 1);
            this._persistence_get_revisions().add(r);
            this.setTitle(r.getFileName());
            this.changed();
        } else {
            for (Revision revision : this._persistence_get_revisions()) {
                if (!revision.getId().equals(r.getId())) continue;
                r = revision;
                break;
            }
        }
        if (mirror != null) {
            r.addMirror(mirror);
        }
        this.revisionAdded(r, mirror);
        return r;
    }

    protected void revisionAdded(Revision r, Mirror m) {
    }

    protected void revisionUploaded(Revision r) {
    }

    public int getHeadRevisionNumber() {
        return this.getHeadRevision().getNumber();
    }

    public boolean isRevertableTo(@NonNull User user, Revision r) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return this.isCanAddRevision(user, null);
    }

    public Revision revertToRevision(@NonNull Revision revision, @NonNull User addedBy) {
        if (revision == null) {
            throw new NullPointerException("revision");
        }
        if (addedBy == null) {
            throw new NullPointerException("addedBy");
        }
        Revision r = revision.copy(addedBy);
        Validate.isTrue((boolean)this.isRevertableTo(addedBy, r), (String)"%s Cannot revert %s to previous revision", (Object[])new Object[]{addedBy, revision});
        this.addRevision(r);
        return r;
    }

    public boolean isLockable(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return !this._persistence_get_readOnly() && !this.isLocked() && this.getSecurityPolicy().isLockable(user, this);
    }

    public void lock(User user) throws DocumentLockedException {
        if (!this.isLockable(user)) {
            // empty if block
        }
        if (this._persistence_get_lockedBy() != null) {
            this.throwDocumentLockedException();
        }
        if (user == null) {
            Validate.notNull((Object)user, (String)"user must be specified when locking files ", (Object[])new Object[0]);
        } else {
            log.debug("Locking document {} without a mirror", (Object)this);
        }
        this._persistence_set_lockedBy(user);
        this._persistence_set_lockedOn(new Date());
    }

    public boolean isLocked() {
        return this._persistence_get_lockedBy() != null;
    }

    public boolean isLockedBy(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return this.isLocked() && user.equals(this._persistence_get_lockedBy());
    }

    private void throwDocumentLockedException() throws DocumentLockedException {
        throw new DocumentLockedException(this.getTitle() + " currently locked by " + this._persistence_get_lockedBy().getUserName() + " on " + DateFormat.getDateTimeInstance(3, 3).format(this._persistence_get_lockedOn()));
    }

    public boolean isValidLock(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        return this.isLockedBy(user);
    }

    public boolean isUnlockable(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isLockedBy(user) && (this._persistence_get_workingCopyMirror() == null || Objects.equal((Object)this._persistence_get_workingCopyMirror(), (Object)mirror));
    }

    public boolean isForceUnlockable(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isLocked() && this.getSecurityPolicy().isForceUnLockable(user, this);
    }

    public void unlock() {
        Validate.isTrue((boolean)this.isLocked(), (String)"%s is not locked", (Object[])new Object[]{this});
        this._persistence_set_lockedBy(null);
        this._persistence_set_lockedOn(null);
        this._persistence_set_workingCopyMirror(null);
        this._persistence_set_workingCopyPath(null);
    }

    public void createWorkingCopy(@NonNull User user, @NonNull Mirror mirror, @NonNull String workingCopyPath) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (workingCopyPath == null) {
            throw new NullPointerException("workingCopyPath");
        }
        Validate.isTrue((boolean)this.getLockedBy().equals(user));
        Validate.isTrue((!this.isWorkInProgress() ? 1 : 0) != 0, (String)"Work already in progress. Working copy at %s %s", (Object[])new Object[]{this._persistence_get_workingCopyMirror(), workingCopyPath});
        Validate.isTrue((boolean)this.getSecurityPolicy().isEditable(user, this), (String)"Document not editable by user %s", (Object[])new Object[]{user});
        this._persistence_set_workingCopyMirror(mirror);
        mirror.getWorkingCopies().add(this);
        this._persistence_set_workingCopyPath(workingCopyPath);
        this._persistence_set_workingCopyModifiedOn(this.getHeadRevision().getModifiedOn());
    }

    public void touchWorkingCopy(@NonNull User user, @NonNull Mirror mirror, @NonNull String workingCopyPath, @NonNull Date modifiedOn) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (workingCopyPath == null) {
            throw new NullPointerException("workingCopyPath");
        }
        if (modifiedOn == null) {
            throw new NullPointerException("modifiedOn");
        }
        Validate.isTrue((boolean)this.isWorkInProgress(), (String)"Work not in progress", (Object[])new Object[0]);
        Validate.isTrue((boolean)this._persistence_get_lockedBy().equals(user), (String)"document locked by %s but change notification from %s", (Object[])new Object[]{this._persistence_get_lockedBy(), user});
        Validate.isTrue((boolean)mirror.equals(this._persistence_get_workingCopyMirror()), (String)"working copy at %s but change notification from %s", (Object[])new Object[]{this._persistence_get_workingCopyMirror(), mirror});
        this._persistence_set_workingCopyModifiedOn(modifiedOn);
    }

    public void relocateWorkingCopy(@NonNull User user, @NonNull Mirror mirror, @NonNull String workingCopyPath, @NonNull Date lastModified) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (workingCopyPath == null) {
            throw new NullPointerException("workingCopyPath");
        }
        if (lastModified == null) {
            throw new NullPointerException("lastModified");
        }
        Validate.isTrue((boolean)this.isWorkInProgress(), (String)"Work not in progress", (Object[])new Object[0]);
        Validate.isTrue((boolean)this._persistence_get_lockedBy().equals(user), (String)"document locked by %s but change notification from %s", (Object[])new Object[]{this._persistence_get_lockedBy(), user});
        Validate.isTrue((boolean)mirror.equals(this._persistence_get_workingCopyMirror()), (String)"working copy at %s but change notification from %s", (Object[])new Object[]{this._persistence_get_workingCopyMirror(), mirror});
        this._persistence_set_workingCopyModifiedOn(lastModified);
        this._persistence_set_workingCopyPath(workingCopyPath);
    }

    public void discardWorkingCopy() {
        Validate.isTrue((boolean)this.isWorkInProgress(), (String)"Working not in progress", (Object[])new Object[0]);
        this._persistence_get_workingCopyMirror().getWorkingCopies().remove(this);
        this._persistence_set_workingCopyMirror(null);
        this._persistence_set_workingCopyPath(null);
        this._persistence_set_workingCopyModifiedOn(null);
    }

    public boolean isWorkInProgress() {
        return this._persistence_get_workingCopyPath() != null;
    }

    public boolean isWorkInProgress(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isWorkInProgress() && this.isWorkable(user, mirror);
    }

    public boolean isWorkingCopyAt(@NonNull Mirror mirror) {
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isLocked() && Objects.equal((Object)this._persistence_get_workingCopyMirror(), (Object)mirror);
    }

    public boolean isWorkable(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isLockedBy(user) && (this._persistence_get_workingCopyMirror() == null || Objects.equal((Object)this._persistence_get_workingCopyMirror(), (Object)mirror)) && this.getSecurityPolicy().isEditable(user, this);
    }

    public boolean isWorkingCopyFileLost(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (this._persistence_get_workingCopyPath() == null) {
            throw new IllegalStateException("No working copy registered against this document");
        }
        return !this.getWorkingCopyFile(user, mirror).exists();
    }

    public boolean isWorkingCopyFileAvailable(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        return this.isWorkable(user, mirror) && this.getWorkingCopyFile(user, mirror) != null && this.getWorkingCopyFile(user, mirror).exists();
    }

    public File getWorkingCopyFile(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (this._persistence_get_workingCopyPath() == null) {
            return null;
        }
        Validate.validState((boolean)this.isValidLock(user), (String)"document locked by %s , not by %s", (Object[])new Object[]{this._persistence_get_lockedBy(), user});
        Validate.validState((boolean)mirror.equals(this._persistence_get_workingCopyMirror()), (String)"working copy at %s, not at %s", (Object[])new Object[]{this._persistence_get_workingCopyMirror(), mirror});
        File f = new File(this.getWorkingCopyPath());
        return f;
    }

    public File getWorkingCopyFile() {
        if (this.getWorkingCopyPath() == null) {
            return null;
        }
        File f = new File(this.getWorkingCopyPath());
        return f;
    }

    public boolean isWorkingCopyModified(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (this.isWorkInProgress()) {
            if (this.isWorkingCopyModified()) {
                return true;
            }
            if (this.isWorkInProgress(user, mirror)) {
                return this.isWorkingCopyFileAfterHead(user, mirror);
            }
        }
        return false;
    }

    public boolean isWorkingCopyModified() {
        return this.isWorkInProgress() && this._persistence_get_workingCopyModifiedOn().after(this.getHeadRevision().getModifiedOn());
    }

    public boolean isWorkingCopyFileAfterHead(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        File f = this.getWorkingCopyFile(user, mirror);
        if (f != null && f.exists()) {
            return f.lastModified() > this.getHeadRevision().getModifiedOn().getTime();
        }
        return false;
    }

    public boolean isWorkingCopyFileAfterModifiedOn(@NonNull User user, @NonNull Mirror mirror) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        File f = this.getWorkingCopyFile(user, mirror);
        return f != null && f.exists() && f.lastModified() > this._persistence_get_workingCopyModifiedOn().getTime();
    }

    public boolean isWorkingCopyAutoSave(User user, Mirror mirror) {
        return false;
    }

    public void checkEditable(@NonNull User user, @NonNull Mirror mirror) throws DocumenNotEditableException {
        if (user == null) {
            throw new NullPointerException("user");
        }
        if (mirror == null) {
            throw new NullPointerException("mirror");
        }
        if (this.isLocked() && !this.getLockedBy().equals(user)) {
            throw new DocumenNotEditableException("Document " + this + " is locked by different user (" + this.getLockedBy() + ")");
        }
        if (this.getWorkingCopyMirror() != null && !mirror.equals(this.getWorkingCopyMirror())) {
            throw new DocumenNotEditableException("Document " + this.getTitle() + " can not be edited. Working copy located on " + this.getWorkingCopyMirror());
        }
    }

    @Override
    protected void copyBasicFields(Node newState) {
        Document newStateDocument = (Document)newState;
        this._persistence_set_revisions(newStateDocument._persistence_get_revisions());
        this._persistence_set_lockedBy(newStateDocument._persistence_get_lockedBy());
        this._persistence_set_lockedOn(newStateDocument._persistence_get_lockedOn());
        this._persistence_set_workingCopyMirror(newStateDocument._persistence_get_workingCopyMirror());
        this._persistence_set_workingCopyPath(newStateDocument._persistence_get_workingCopyPath());
        this._persistence_set_workingCopyModifiedOn(newStateDocument._persistence_get_workingCopyModifiedOn());
        super.copyBasicFields(newState);
    }

    public User getLockedBy() {
        return this._persistence_get_lockedBy();
    }

    public Date getLockedOn() {
        return this._persistence_get_lockedOn();
    }

    public Mirror getWorkingCopyMirror() {
        return this._persistence_get_workingCopyMirror();
    }

    public String getWorkingCopyPath() {
        return this._persistence_get_workingCopyPath();
    }

    public Date getWorkingCopyModifiedOn() {
        return this._persistence_get_workingCopyModifiedOn();
    }

    public void setLockedBy(User lockedBy) {
        this._persistence_set_lockedBy(lockedBy);
    }

    public void setLockedOn(Date lockedOn) {
        this._persistence_set_lockedOn(lockedOn);
    }

    public void setWorkingCopyMirror(Mirror workingCopyMirror) {
        this._persistence_set_workingCopyMirror(workingCopyMirror);
    }

    public void setWorkingCopyPath(String workingCopyPath) {
        this._persistence_set_workingCopyPath(workingCopyPath);
    }

    protected Document() {
    }

    public void setWorkingCopyModifiedOn(Date workingCopyModifiedOn) {
        this._persistence_set_workingCopyModifiedOn(workingCopyModifiedOn);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Document();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "lockedBy") {
            return this.lockedBy;
        }
        if (string == "workingCopyMirror") {
            return this.workingCopyMirror;
        }
        if (string == "workingCopyModifiedOn") {
            return this.workingCopyModifiedOn;
        }
        if (string == "revisions") {
            return this.revisions;
        }
        if (string == "lockedOn") {
            return this.lockedOn;
        }
        if (string == "workingCopyPath") {
            return this.workingCopyPath;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "lockedBy") {
            this.lockedBy = (User)object;
            return;
        }
        if (string == "workingCopyMirror") {
            this.workingCopyMirror = (Mirror)object;
            return;
        }
        if (string == "workingCopyModifiedOn") {
            this.workingCopyModifiedOn = (Date)object;
            return;
        }
        if (string == "revisions") {
            this.revisions = (List)object;
            return;
        }
        if (string == "lockedOn") {
            this.lockedOn = (Date)object;
            return;
        }
        if (string == "workingCopyPath") {
            this.workingCopyPath = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public User _persistence_get_lockedBy() {
        this._persistence_checkFetched("lockedBy");
        return this.lockedBy;
    }

    public void _persistence_set_lockedBy(User user) {
        this._persistence_checkFetchedForSet("lockedBy");
        this._persistence_propertyChange("lockedBy", this.lockedBy, user);
        this.lockedBy = user;
    }

    public Mirror _persistence_get_workingCopyMirror() {
        this._persistence_checkFetched("workingCopyMirror");
        return this.workingCopyMirror;
    }

    public void _persistence_set_workingCopyMirror(Mirror mirror) {
        this._persistence_checkFetchedForSet("workingCopyMirror");
        this._persistence_propertyChange("workingCopyMirror", this.workingCopyMirror, mirror);
        this.workingCopyMirror = mirror;
    }

    public Date _persistence_get_workingCopyModifiedOn() {
        this._persistence_checkFetched("workingCopyModifiedOn");
        return this.workingCopyModifiedOn;
    }

    public void _persistence_set_workingCopyModifiedOn(Date date) {
        this._persistence_checkFetchedForSet("workingCopyModifiedOn");
        this._persistence_propertyChange("workingCopyModifiedOn", this.workingCopyModifiedOn, date);
        this.workingCopyModifiedOn = date;
    }

    public List _persistence_get_revisions() {
        this._persistence_checkFetched("revisions");
        return this.revisions;
    }

    public void _persistence_set_revisions(List list) {
        this._persistence_checkFetchedForSet("revisions");
        this._persistence_propertyChange("revisions", this.revisions, list);
        this.revisions = list;
    }

    public Date _persistence_get_lockedOn() {
        this._persistence_checkFetched("lockedOn");
        return this.lockedOn;
    }

    public void _persistence_set_lockedOn(Date date) {
        this._persistence_checkFetchedForSet("lockedOn");
        this._persistence_propertyChange("lockedOn", this.lockedOn, date);
        this.lockedOn = date;
    }

    public String _persistence_get_workingCopyPath() {
        this._persistence_checkFetched("workingCopyPath");
        return this.workingCopyPath;
    }

    public void _persistence_set_workingCopyPath(String string) {
        this._persistence_checkFetchedForSet("workingCopyPath");
        this._persistence_propertyChange("workingCopyPath", this.workingCopyPath, string);
        this.workingCopyPath = string;
    }

    public static class AllowAllDocumentSecurityPolicy
    implements DocumentSecurityPolicy<Document> {
    }
}

