/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.delivery;

import com.anahata.util.email.EmailUtils;
import com.anahata.util.validator.constraints.AssertFieldTrue;
import com.anahata.yam.model.delivery.DocumentDeliveryAttachment;
import com.anahata.yam.model.delivery.DocumentDeliveryMethod;
import com.anahata.yam.model.phone.PhoneNumber;
import com.anahata.yam.model.user.User;
import com.anahata.yam.util.jpa.eclipselink.PhoneNumberConverter;
import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlTransient;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embeddable
public class DocumentDelivery
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final Logger log = LoggerFactory.getLogger(DocumentDelivery.class);
    @JoinColumn(name="DELIVERYUSER_ID")
    @ManyToOne(optional=false)
    private User user;
    @Column(name="DELIVERYDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @Enumerated(value=EnumType.STRING)
    @Column(name="DELIVERYMETHOD")
    private DocumentDeliveryMethod method;
    @Column(name="DELIVERYEMAIL")
    @Size(max=128)
    private String email;
    @Column(name="DELIVERYEMAILCC")
    @Size(max=500)
    private String emailCc;
    @Converter(name="phoneNumberConverter", converterClass=PhoneNumberConverter.class)
    @Convert(value="phoneNumberConverter")
    @Column(name="DELIVERYFAX")
    @Valid
    private PhoneNumber fax;
    @Column(name="DELIVERYEMAILTEXT")
    @Size(max=1000)
    private String emailText;
    @Transient
    private Long toContactId;
    @Transient
    private List<DocumentDeliveryAttachment> emailAttachments = new ArrayList<DocumentDeliveryAttachment>();
    @Transient
    private List<Long> dmsEmailAttachments = new ArrayList<Long>();
    static final long serialVersionUID = 6899422235227308280L;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public void setUser(User user) {
        if (user != null) {
            this._persistence_set_date(new Date());
        }
        this._persistence_set_user(user);
    }

    public boolean isDelivered() {
        return this._persistence_get_date() != null;
    }

    public boolean isDeliveredBySurfaceMail() {
        return this._persistence_get_method() == DocumentDeliveryMethod.SURFACE_MAIL;
    }

    public void setDeliveredBySurfaceMail(boolean b) {
        if (b && !this.isDeliveredBySurfaceMail()) {
            this.setMethodAndClearDetails(DocumentDeliveryMethod.SURFACE_MAIL);
        }
    }

    public boolean isDeliveredByEmail() {
        return this._persistence_get_method() == DocumentDeliveryMethod.EMAIL;
    }

    public void setDeliveredByEmail(boolean b) {
        if (b && !this.isDeliveredByEmail()) {
            this.setMethodAndClearDetails(DocumentDeliveryMethod.EMAIL);
        }
    }

    public boolean isDeliveredByFax() {
        return this._persistence_get_method() == DocumentDeliveryMethod.FAX;
    }

    public void setDeliveredByFax(boolean b) {
        if (b && !this.isDeliveredByFax()) {
            this.setMethodAndClearDetails(DocumentDeliveryMethod.FAX);
        }
    }

    private void setMethodAndClearDetails(DocumentDeliveryMethod method) {
        this._persistence_set_method(method);
        this._persistence_set_email(null);
        this._persistence_set_emailCc(null);
        this._persistence_set_fax(null);
        if (method != null && this._persistence_get_date() == null) {
            this._persistence_set_date(new Date());
        }
    }

    public void email(String email) {
        Validate.notNull((Object)email, (String)"email is required", (Object[])new Object[0]);
        this._persistence_set_method(DocumentDeliveryMethod.EMAIL);
        this._persistence_set_email(email);
        this._persistence_set_fax(null);
    }

    public void fax(PhoneNumber fax) {
        Validate.notNull((Object)fax, (String)"fax is required", (Object[])new Object[0]);
        this._persistence_set_method(DocumentDeliveryMethod.FAX);
        this._persistence_set_fax(fax);
        this._persistence_set_email(null);
    }

    public void mail() {
        this._persistence_set_method(DocumentDeliveryMethod.SURFACE_MAIL);
        this._persistence_set_fax(null);
        this._persistence_set_email(null);
    }

    public Object getSentTo() {
        if (this._persistence_get_method() == null) {
            return null;
        }
        switch (this._persistence_get_method()) {
            case EMAIL: {
                return this._persistence_get_email();
            }
            case FAX: {
                return this._persistence_get_fax();
            }
        }
        return null;
    }

    public String getSentToDisplayValue() {
        if (this._persistence_get_method() == null) {
            return null;
        }
        switch (this._persistence_get_method()) {
            case EMAIL: {
                return this._persistence_get_email();
            }
            case FAX: {
                return this._persistence_get_fax().getDisplayValue();
            }
        }
        return null;
    }

    public DocumentDeliveryAttachment addAttachment(@NonNull String fileName, @NonNull String filePath) {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath");
        }
        DocumentDeliveryAttachment attachment = new DocumentDeliveryAttachment(this, fileName, filePath);
        this.emailAttachments.add(attachment);
        return attachment;
    }

    @AssertFieldTrue(field="fax", message="A valid fax number is required")
    public boolean isFaxValid() {
        return this._persistence_get_method() != DocumentDeliveryMethod.FAX || this._persistence_get_fax() != null;
    }

    @AssertFieldTrue(field="email", message="A valid email address is required")
    public boolean isEmailValid() {
        return this._persistence_get_method() != DocumentDeliveryMethod.EMAIL || this._persistence_get_email() != null && EmailUtils.isValidEmailAddresses((String)this._persistence_get_email());
    }

    @AssertFieldTrue(field="emailCc", message="A valid email cc is required")
    public boolean isEmailCcValid() {
        return this._persistence_get_method() != DocumentDeliveryMethod.EMAIL || StringUtils.isBlank((CharSequence)this._persistence_get_emailCc()) || EmailUtils.isValidEmailAddresses((String)this._persistence_get_emailCc());
    }

    public String[] getEmailCcAddresses() throws AddressException {
        return EmailUtils.parseAddresses((String)this._persistence_get_emailCc());
    }

    public String[] getEmailAddressesOnly() throws AddressException {
        return EmailUtils.parseAddressesOnly((String)this._persistence_get_email());
    }

    public String getFirstEmailAddressOnly() {
        try {
            String[] s = this.getEmailAddressesOnly();
            if (s.length > 0) {
                return s[0];
            }
        }
        catch (Exception e) {
            log.warn("Could not parse email address", (Throwable)e);
        }
        return null;
    }

    public DocumentDelivery() {
    }

    @ConstructorProperties(value={"user", "date", "method", "email", "emailCc", "fax", "emailText", "toContactId", "emailAttachments", "dmsEmailAttachments"})
    public DocumentDelivery(User user, Date date, DocumentDeliveryMethod method, String email, String emailCc, PhoneNumber fax, String emailText, Long toContactId, List<DocumentDeliveryAttachment> emailAttachments, List<Long> dmsEmailAttachments) {
        this.user = user;
        this.date = date;
        this.method = method;
        this.email = email;
        this.emailCc = emailCc;
        this.fax = fax;
        this.emailText = emailText;
        this.toContactId = toContactId;
        this.emailAttachments = emailAttachments;
        this.dmsEmailAttachments = dmsEmailAttachments;
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public DocumentDeliveryMethod getMethod() {
        return this._persistence_get_method();
    }

    public String getEmail() {
        return this._persistence_get_email();
    }

    public String getEmailCc() {
        return this._persistence_get_emailCc();
    }

    public PhoneNumber getFax() {
        return this._persistence_get_fax();
    }

    public String getEmailText() {
        return this._persistence_get_emailText();
    }

    public Long getToContactId() {
        return this.toContactId;
    }

    public List<DocumentDeliveryAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public List<Long> getDmsEmailAttachments() {
        return this.dmsEmailAttachments;
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setMethod(DocumentDeliveryMethod method) {
        this._persistence_set_method(method);
    }

    public void setEmail(String email) {
        this._persistence_set_email(email);
    }

    public void setEmailCc(String emailCc) {
        this._persistence_set_emailCc(emailCc);
    }

    public void setFax(PhoneNumber fax) {
        this._persistence_set_fax(fax);
    }

    public void setEmailText(String emailText) {
        this._persistence_set_emailText(emailText);
    }

    public void setToContactId(Long toContactId) {
        this.toContactId = toContactId;
    }

    public void setEmailAttachments(List<DocumentDeliveryAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public void setDmsEmailAttachments(List<Long> dmsEmailAttachments) {
        this.dmsEmailAttachments = dmsEmailAttachments;
    }

    public String toString() {
        return "DocumentDelivery(user=" + this.getUser() + ", date=" + this.getDate() + ", method=" + (Object)((Object)this.getMethod()) + ", email=" + this.getEmail() + ", emailCc=" + this.getEmailCc() + ", fax=" + this.getFax() + ", emailText=" + this.getEmailText() + ", toContactId=" + this.getToContactId() + ", emailAttachments=" + this.getEmailAttachments() + ", dmsEmailAttachments=" + this.getDmsEmailAttachments() + ")";
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DocumentDelivery();
    }

    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "emailCc") {
            return this.emailCc;
        }
        if (string == "method") {
            return this.method;
        }
        if (string == "emailText") {
            return this.emailText;
        }
        if (string == "fax") {
            return this.fax;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "email") {
            return this.email;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "emailCc") {
            this.emailCc = (String)object;
            return;
        }
        if (string == "method") {
            this.method = (DocumentDeliveryMethod)((Object)object);
            return;
        }
        if (string == "emailText") {
            this.emailText = (String)object;
            return;
        }
        if (string == "fax") {
            this.fax = (PhoneNumber)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "email") {
            this.email = (String)object;
            return;
        }
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public String _persistence_get_emailCc() {
        this._persistence_checkFetched("emailCc");
        return this.emailCc;
    }

    public void _persistence_set_emailCc(String string) {
        this._persistence_checkFetchedForSet("emailCc");
        this._persistence_propertyChange("emailCc", this.emailCc, string);
        this.emailCc = string;
    }

    public DocumentDeliveryMethod _persistence_get_method() {
        this._persistence_checkFetched("method");
        return this.method;
    }

    public void _persistence_set_method(DocumentDeliveryMethod documentDeliveryMethod) {
        this._persistence_checkFetchedForSet("method");
        this._persistence_propertyChange("method", (Object)this.method, (Object)documentDeliveryMethod);
        this.method = documentDeliveryMethod;
    }

    public String _persistence_get_emailText() {
        this._persistence_checkFetched("emailText");
        return this.emailText;
    }

    public void _persistence_set_emailText(String string) {
        this._persistence_checkFetchedForSet("emailText");
        this._persistence_propertyChange("emailText", this.emailText, string);
        this.emailText = string;
    }

    public PhoneNumber _persistence_get_fax() {
        this._persistence_checkFetched("fax");
        return this.fax;
    }

    public void _persistence_set_fax(PhoneNumber phoneNumber) {
        this._persistence_checkFetchedForSet("fax");
        this._persistence_propertyChange("fax", this.fax, phoneNumber);
        this.fax = phoneNumber;
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
    }

    public String _persistence_get_email() {
        this._persistence_checkFetched("email");
        return this.email;
    }

    public void _persistence_set_email(String string) {
        this._persistence_checkFetchedForSet("email");
        this._persistence_propertyChange("email", this.email, string);
        this.email = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

