/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.company;

import com.anahata.yam.model.company.Abn;
import com.anahata.yam.model.company.AbnValue;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

public class AbnValueValidator
implements ConstraintValidator<AbnValue, String> {
    private static final String MSG_ONLY_NUMBERS_SPACES = "The ABN can only contain numbers and spaces";
    private static final String MSG_11_DIGITS = "The ABN must be 11 digits in length";

    public void initialize(AbnValue constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        int length;
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String message = AbnValueValidator.validateAllowedCharacters(value);
        if (message == null && (length = value.replace(" ", "").length()) > 11) {
            message = MSG_11_DIGITS;
        }
        if (message != null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
            return false;
        }
        return Abn.validate(value);
    }

    public static String validateAllowedCharacters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (!StringUtils.containsOnly((CharSequence)value, (String)" 0123456789")) {
            return MSG_ONLY_NUMBERS_SPACES;
        }
        return null;
    }
}

