/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.company;

import au.gov.business.abr.abrxmlsearch.AddressDetails;
import au.gov.business.abr.abrxmlsearch.AddressSimple;
import au.gov.business.abr.abrxmlsearch.Identifier;
import au.gov.business.abr.abrxmlsearch.IdentifierSummary;
import au.gov.business.abr.abrxmlsearch.IndividualName;
import au.gov.business.abr.abrxmlsearch.IndividualSimpleName;
import au.gov.business.abr.abrxmlsearch.OrganisationName;
import au.gov.business.abr.abrxmlsearch.OrganisationSimpleName;
import au.gov.business.abr.abrxmlsearch.Response;
import au.gov.business.abr.abrxmlsearch.ResponseBusinessEntity;
import au.gov.business.abr.abrxmlsearch.SearchResultsRecord;
import com.anahata.util.xml.XMLUtils;
import com.anahata.yam.model.company.AbnSearchResult;
import java.beans.ConstructorProperties;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Node;

public class AbnSearchResultImpl
implements AbnSearchResult {
    private DateFormat dateFormat = new SimpleDateFormat("YYYY-MM-DD");
    private String abn;
    private boolean exception;
    private String exceptionDescription;
    private Date recordLastUpdatedDate;
    private String organisationName;
    private boolean current;
    private EntityStatus entityStatus;
    private String asicNumber;
    private String entityTypeDescription;
    private String mainTradingName;
    private String mainPostcode;
    private String mainState;

    public AbnSearchResultImpl(Response response) {
        boolean bl = this.exception = response.getException() != null;
        if (this.exception) {
            this.exceptionDescription = response.getException().getExceptionDescription();
        }
        ResponseBusinessEntity be = response.getBusinessEntity();
        this.abn = ((Identifier)be.getABN().get(0)).getIdentifierValue();
        this.recordLastUpdatedDate = this.getDate(be.getRecordLastUpdatedDate().toString());
        Object o = be.getMainNameOrLegalName().get(0);
        this.organisationName = o instanceof OrganisationName ? ((OrganisationName)o).getOrganisationName() : (o instanceof IndividualName ? ((IndividualName)o).getFullName() : o.toString());
        this.current = this.getBoolean(((Identifier)be.getABN().get(0)).getIsCurrentIndicator());
        this.asicNumber = be.getASICNumber();
        this.entityStatus = EntityStatus.valueOf(((au.gov.business.abr.abrxmlsearch.EntityStatus)be.getEntityStatus().get(0)).getEntityStatusCode());
        this.entityTypeDescription = be.getEntityType().getEntityDescription();
        this.mainTradingName = be.getMainTradingName().isEmpty() ? this.organisationName : ((OrganisationName)be.getMainTradingName().get(0)).getOrganisationName();
        this.mainPostcode = ((AddressDetails)be.getMainBusinessPhysicalAddress().get(0)).getPostcode();
        this.mainState = ((AddressDetails)be.getMainBusinessPhysicalAddress().get(0)).getStateCode();
    }

    public AbnSearchResultImpl(SearchResultsRecord searchResultsRecord1) {
        this.abn = ((IdentifierSummary)searchResultsRecord1.getABN().get(0)).getIdentifierValue();
        this.entityStatus = EntityStatus.valueOf(((IdentifierSummary)searchResultsRecord1.getABN().get(0)).getIdentifierStatus());
        this.current = this.entityStatus == EntityStatus.Active;
        List mainName = searchResultsRecord1.getDgrFundNameOrPBIENameOrOtherTradingName();
        JAXBElement mainName0 = (JAXBElement)mainName.get(0);
        if (mainName0.getValue() instanceof OrganisationSimpleName) {
            OrganisationSimpleName company = (OrganisationSimpleName)mainName0.getValue();
            this.organisationName = company.getOrganisationName();
        } else if (mainName0.getValue() instanceof IndividualSimpleName) {
            IndividualSimpleName individual = (IndividualSimpleName)mainName0.getValue();
            this.organisationName = individual.getFullName();
        } else {
            this.organisationName = String.valueOf(mainName0.getValue());
        }
        this.mainTradingName = this.organisationName;
        List adresses = searchResultsRecord1.getMainBusinessPhysicalAddress();
        for (AddressSimple addressSimple : adresses) {
            this.mainPostcode = addressSimple.getPostcode();
            this.mainState = addressSimple.getStateCode();
        }
    }

    @Deprecated
    public AbnSearchResultImpl(String abn, Node searchResultsPayload) {
        Validate.notNull((Object)abn);
        Validate.notNull((Object)searchResultsPayload);
        this.abn = abn;
        boolean bl = this.exception = XMLUtils.getNode((Node)searchResultsPayload, (String)"/ABRPayloadSearchResults/response/exception") != null;
        if (this.exception) {
            this.exceptionDescription = this.getString(searchResultsPayload, "/exception/exceptionDescription");
        } else {
            this.recordLastUpdatedDate = this.getDate(searchResultsPayload, "/businessEntity/recordLastUpdatedDate");
            this.organisationName = this.getString(searchResultsPayload, "/businessEntity/mainName/organisationName");
            this.current = this.getBoolean(searchResultsPayload, "/businessEntity/ABN/isCurrentIndicator");
            this.asicNumber = this.getString(searchResultsPayload, "/businessEntity/ASICNumber");
            this.entityStatus = EntityStatus.valueOf(this.getString(searchResultsPayload, "/businessEntity/entityStatus/entityStatusCode"));
            this.entityTypeDescription = this.getString(searchResultsPayload, "/businessEntity/entityType/entityDescription");
            this.mainTradingName = this.getString(searchResultsPayload, "/businessEntity/mainTradingName/organisationName");
            this.mainPostcode = this.getString(searchResultsPayload, "/businessEntity/mainBusinessPhysicalAddress/postcode");
            this.mainState = this.getString(searchResultsPayload, "/businessEntity/mainBusinessPhysicalAddress/stateCode");
        }
    }

    @Override
    public String getAsicURL() {
        if (this.asicNumber != null) {
            return "https://connectonline.asic.gov.au/RegistrySearch/faces/adf.task-flow?adf.tfId=panelSearch&adf.tfDoc=/taskflows/panelSearch.xml&searchType=OrgAndBusNm&searchText=" + this.asicNumber;
        }
        return null;
    }

    @Override
    public String getAbrURL() {
        return "http://abr.business.gov.au/SearchByAbn.aspx?abn=" + StringUtils.remove((String)this.abn, (String)" ");
    }

    private String getString(Node searchResultsPayload, String path) {
        return XMLUtils.getNodeText((Node)searchResultsPayload, (String)("/ABRPayloadSearchResults/response" + path));
    }

    private Date getDate(String string) {
        if (!StringUtils.isBlank((CharSequence)string) && !string.equals("0001-01-01")) {
            try {
                return this.dateFormat.parse(string);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Date getDate(Node searchResultsPayload, String path) {
        String string = this.getString(searchResultsPayload, path);
        return this.getDate(string);
    }

    private boolean getBoolean(String string) {
        return "Y".equals(string);
    }

    private boolean getBoolean(Node searchResultsPayload, String path) {
        return this.getBoolean(this.getString(searchResultsPayload, path));
    }

    @ConstructorProperties(value={"dateFormat", "abn", "exception", "exceptionDescription", "recordLastUpdatedDate", "organisationName", "current", "entityStatus", "asicNumber", "entityTypeDescription", "mainTradingName", "mainPostcode", "mainState"})
    public AbnSearchResultImpl(DateFormat dateFormat, String abn, boolean exception, String exceptionDescription, Date recordLastUpdatedDate, String organisationName, boolean current, EntityStatus entityStatus, String asicNumber, String entityTypeDescription, String mainTradingName, String mainPostcode, String mainState) {
        this.dateFormat = dateFormat;
        this.abn = abn;
        this.exception = exception;
        this.exceptionDescription = exceptionDescription;
        this.recordLastUpdatedDate = recordLastUpdatedDate;
        this.organisationName = organisationName;
        this.current = current;
        this.entityStatus = entityStatus;
        this.asicNumber = asicNumber;
        this.entityTypeDescription = entityTypeDescription;
        this.mainTradingName = mainTradingName;
        this.mainPostcode = mainPostcode;
        this.mainState = mainState;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public String getAbn() {
        return this.abn;
    }

    @Override
    public boolean isException() {
        return this.exception;
    }

    @Override
    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    public Date getRecordLastUpdatedDate() {
        return this.recordLastUpdatedDate;
    }

    @Override
    public String getOrganisationName() {
        return this.organisationName;
    }

    @Override
    public boolean isCurrent() {
        return this.current;
    }

    @Override
    public EntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    @Override
    public String getAsicNumber() {
        return this.asicNumber;
    }

    @Override
    public String getEntityTypeDescription() {
        return this.entityTypeDescription;
    }

    @Override
    public String getMainTradingName() {
        return this.mainTradingName;
    }

    @Override
    public String getMainPostcode() {
        return this.mainPostcode;
    }

    @Override
    public String getMainState() {
        return this.mainState;
    }

    public String toString() {
        return "AbnSearchResultImpl(dateFormat=" + this.getDateFormat() + ", abn=" + this.getAbn() + ", exception=" + this.isException() + ", exceptionDescription=" + this.getExceptionDescription() + ", recordLastUpdatedDate=" + this.getRecordLastUpdatedDate() + ", organisationName=" + this.getOrganisationName() + ", current=" + this.isCurrent() + ", entityStatus=" + (Object)((Object)this.getEntityStatus()) + ", asicNumber=" + this.getAsicNumber() + ", entityTypeDescription=" + this.getEntityTypeDescription() + ", mainTradingName=" + this.getMainTradingName() + ", mainPostcode=" + this.getMainPostcode() + ", mainState=" + this.getMainState() + ")";
    }

    public static enum EntityType {
        Individual,
        Organisation;

    }

    public static enum EntityStatus {
        Active,
        Cancelled;

    }
}

