/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.company;

import com.anahata.yam.model.company.AbnValue;
import com.anahata.yam.model.search.Searchable;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class Abn
implements Serializable,
Searchable {
    private static int[] WEIGHT_FACTORS = new int[]{10, 1, 3, 5, 7, 9, 11, 13, 15, 17, 19};
    @AbnValue
    private String value;

    public Abn(String value) {
        this.value = StringUtils.defaultString((String)value).replace(" ", "");
    }

    public static boolean validate(String abn) {
        if (StringUtils.isEmpty((CharSequence)abn)) {
            return false;
        }
        if ((abn = abn.replace(" ", "")).length() != 11) {
            return false;
        }
        try {
            Long.valueOf(abn);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int total = 0;
        for (int i = 0; i < 11; ++i) {
            int value = Integer.valueOf(abn.substring(i, i + 1));
            if (i == 0) {
                --value;
            }
            total += value * WEIGHT_FACTORS[i];
        }
        return total % 89 == 0;
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public final String getDisplayValue() {
        if (!Abn.validate(this.value)) {
            return this.value;
        }
        return StringUtils.isBlank((CharSequence)this.value) ? null : this.value.substring(0, 2) + " " + this.value.substring(2, 5) + " " + this.value.substring(5, 8) + " " + this.value.substring(8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Abn)) {
            return false;
        }
        Abn other = (Abn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Abn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String getValue() {
        return this.value;
    }
}

