/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.transport;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.auth.DataFileCredentials;
import com.anahata.util.lang.Nvl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public abstract class AbstractMyobTransport {
    private static final Logger log = LoggerFactory.getLogger(AbstractMyobTransport.class);
    protected static final String MYOB_API_CFTOKEN_HEADER = "x-myobapi-cftoken";
    protected static final String MYOB_API_VERSION_HEADER = "x-myobapi-version";
    protected static final String MYOB_API_KEY_HEADER = "x-myobapi-key";
    protected static final String MYOB_API_AUTHORIZATION_HEADER = "Authorization";
    protected static final String MYOB_API_AUTHORIZATION_HEADER_BEARER = "Bearer ";
    private String apiVersion = "v2";

    public abstract String sendReceiveURL(MyobEndPoint var1, URI var2, String var3, String var4) throws Exception;

    public String sendReceive(MyobEndPoint dataFile, String context, String uID, String queryString, String method, String payLoad) throws Exception {
        URI url = AbstractMyobTransport.makeURI(dataFile, context, uID, queryString, method);
        return this.sendReceiveURL(dataFile, url, method, payLoad);
    }

    protected static String makeCFTokenHeader(DataFileCredentials dataFile) {
        String val = dataFile.getUser() + ":" + dataFile.getPassword();
        return new BASE64Encoder().encode(val.getBytes());
    }

    protected static URI makeURI(MyobEndPoint endpoint, String context, String uID, String query, String method) throws URISyntaxException, UnsupportedEncodingException {
        method = method == null ? "GET" : method.toUpperCase();
        String url = endpoint.getUri();
        if (context != null) {
            url = url + "/" + context;
            if (uID != null) {
                url = url + "/" + uID;
            }
        }
        url = url + "?" + Nvl.nvl((String)query);
        if (method != null && (method.equals("PUT") || method.equals("POST"))) {
            if (!url.endsWith("?")) {
                url = url + "&";
            }
            url = url + "returnBody=true";
        }
        return new URI(url);
    }

    public static void main(String[] args) {
        System.out.println(new BASE64Encoder().encode("Administrator:".getBytes()));
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

