/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.service;

import com.anahata.myob.api.domain.v2.BaseEntity;
import com.anahata.myob.api.domain.v2.EntityPage;
import com.anahata.myob.api.service.AbstractMyobService;
import com.anahata.myob.api.service.exception.MyobException;
import com.anahata.util.lang.builder.DelimitedStringBuilder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityMyobService<T extends EntityPage<U>, U extends BaseEntity>
extends AbstractMyobService {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityMyobService.class);
    protected final Class<T> pageType;
    private final Class<U> entityType;

    protected AbstractEntityMyobService(String context, Class<T> pageType, Class<U> entityType) {
        super(context);
        this.pageType = pageType;
        this.entityType = entityType;
    }

    public List<U> findAll() throws MyobException {
        String json = this.sendReceive(null, null, null, null);
        EntityPage page = (EntityPage)AbstractEntityMyobService.fromJson(json, this.pageType);
        ArrayList ret = new ArrayList();
        Number count = page.getCount();
        if (count.intValue() <= 400) {
            ret.addAll(page.getItems());
        }
        while (!page.isLast()) {
            json = this.sendReceive(null, "$top=" + count, null, null);
            page = (EntityPage)AbstractEntityMyobService.fromJson(json, this.pageType);
            ret.addAll(page.getItems());
        }
        return ret;
    }

    public U find(String uid) throws MyobException {
        String ret = this.sendReceive(uid, null, null, null);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }

    public U update(U item) throws MyobException {
        String ret = this.sendReceive(((BaseEntity)item).getUID(), null, "PUT", AbstractEntityMyobService.toJson(item));
        item = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return item;
    }

    public U create(U item) throws MyobException {
        String ret = this.sendReceive(null, null, "POST", AbstractEntityMyobService.toJson(item));
        return (U)((BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType));
    }

    public U remove(String uid) throws MyobException {
        String ret = this.sendReceive(uid, null, "DELETE", null);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }

    public List<U> find(String filterExpression, String orderBy, Integer top, Integer skip) throws MyobException {
        ArrayList ret = new ArrayList();
        DelimitedStringBuilder dsb = new DelimitedStringBuilder("&");
        if (filterExpression != null) {
            dsb.append("$filter=" + URLEncoder.encode(filterExpression));
        }
        if (orderBy != null) {
            dsb.append("$orderBy=" + URLEncoder.encode(orderBy));
        }
        if (top != null) {
            dsb.append("$top=" + top);
        }
        if (skip != null) {
            dsb.append("$skip=" + skip);
        }
        String json = this.sendReceive(null, dsb.toString(), null, null);
        EntityPage page = (EntityPage)AbstractEntityMyobService.fromJson(json, this.pageType);
        ret.addAll(page.getItems());
        return ret;
    }
}

