/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.auth;

import com.anahata.myob.api.auth.MyobPlugin;
import com.anahata.myob.api.auth.OAuthAccessToken;
import com.google.gson.Gson;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OauthAuthenticator.class);
    private static final String MYOB_OAUTH2_TOKEN_URL = "https://secure.myob.com/oauth2/v1/authorize";
    private static final String MYOB_OAUTH2_ACCOUNTLOGIN_URL = "https://secure.myob.com/oauth2/account/authorize";
    private static final HttpClient httpClient = HttpClientBuilder.create().build();

    public static String getloginUrl(String key, String redirectURL) {
        return "https://secure.myob.com/oauth2/account/authorize?client_id=" + key + "&redirect_uri=" + OauthAuthenticator.encode(redirectURL) + "&response_type=code&scope=CompanyFile";
    }

    public static OAuthAccessToken refreshAccessToken(OAuthAccessToken currentToken) throws Exception {
        ArrayList<NameValuePair> arguments = new ArrayList<NameValuePair>();
        arguments.add((NameValuePair)new BasicNameValuePair("client_id", currentToken.getPlugin().getKey()));
        arguments.add((NameValuePair)new BasicNameValuePair("client_secret", currentToken.getPlugin().getSecret()));
        arguments.add((NameValuePair)new BasicNameValuePair("refresh_token", currentToken.getRefreshToken()));
        arguments.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        OAuthAccessToken ret = OauthAuthenticator.authorize(arguments);
        ret.setPlugin(currentToken.getPlugin());
        return ret;
    }

    public static OAuthAccessToken getAccessToken(@NonNull MyobPlugin plugin, String code) throws Exception {
        if (plugin == null) {
            throw new NullPointerException("plugin");
        }
        ArrayList<NameValuePair> arguments = new ArrayList<NameValuePair>();
        arguments.add((NameValuePair)new BasicNameValuePair("client_id", plugin.getKey()));
        arguments.add((NameValuePair)new BasicNameValuePair("client_secret", plugin.getSecret()));
        arguments.add((NameValuePair)new BasicNameValuePair("code", code));
        arguments.add((NameValuePair)new BasicNameValuePair("redirect_uri", plugin.getRedirectURL()));
        arguments.add((NameValuePair)new BasicNameValuePair("scope", "CompanyFile"));
        arguments.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        OAuthAccessToken ret = OauthAuthenticator.authorize(arguments);
        ret.setPlugin(plugin);
        return ret;
    }

    private static OAuthAccessToken authorize(List<NameValuePair> parameters) throws Exception {
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        HttpPost httpPost = new HttpPost(MYOB_OAUTH2_TOKEN_URL);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        String responseBody = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        log.debug("ResponseBody is {}", (Object)responseBody);
        OAuthAccessToken response = (OAuthAccessToken)new Gson().fromJson(responseBody, OAuthAccessToken.class);
        log.debug("access.token=" + response.getAccessToken());
        log.debug("refresh.token=" + response.getRefreshToken());
        return response;
    }

    private static final String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

