/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.auth;

import com.anahata.myob.api.auth.MyobPlugin;
import com.anahata.myob.api.auth.OauthAuthenticator;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAccessToken
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(OAuthAccessToken.class);
    private MyobPlugin plugin;
    private Date createdOn = new Date();
    @SerializedName(value="access_token")
    private String accessToken;
    @SerializedName(value="refresh_token")
    private String refreshToken;
    @SerializedName(value="token_type")
    private String tokenType;
    @SerializedName(value="expires_in")
    private int expiresIn;
    @SerializedName(value="scope")
    private String scope;

    public OAuthAccessToken(MyobPlugin plugin, String accessToken, String refreshToken, Date createdOn, int expiresIn) {
        this.plugin = plugin;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.createdOn = createdOn;
        this.expiresIn = expiresIn;
    }

    public boolean isExpired(int contingencyMinutes) {
        Date expiryDate = this.getExpiryDate(contingencyMinutes);
        Date now = new Date();
        boolean ret = this.createdOn == null || now.after(expiryDate);
        log.debug("isExpired continency = {} min, expiryDate={}, expired=", new Object[]{contingencyMinutes, expiryDate, ret});
        return ret;
    }

    public Date getExpiryDate(int contingencyMinutes) {
        if (this.createdOn == null) {
            return null;
        }
        return DateUtils.addSeconds((Date)this.createdOn, (int)(this.expiresIn - contingencyMinutes * 60));
    }

    public OAuthAccessToken refresh() throws Exception {
        return OauthAuthenticator.refreshAccessToken(this);
    }

    public String toString() {
        return "OAuthAccessToken{\nplugin=" + this.plugin + "\ncreatedOn=" + this.createdOn + "\naccessToken=" + this.accessToken + "\nrefreshToken=" + this.refreshToken + "\ntokenType=" + this.tokenType + "\nexpiresIn=" + this.expiresIn + "\nscope=" + this.scope + '}';
    }

    public String toShortString() {
        return "OAuthAccessToken{ accessToken=" + this.accessToken.substring(0, 15) + "... , refreshToken=" + this.refreshToken.substring(0, 15) + "... , createdOn=" + this.createdOn + ", expiresIn=" + this.expiresIn + " }";
    }

    public MyobPlugin getPlugin() {
        return this.plugin;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setPlugin(MyobPlugin plugin) {
        this.plugin = plugin;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setExpiresIn(int expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuthAccessToken() {
    }
}

