/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.auth;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.MyobEndPointProvider;
import com.anahata.myob.api.auth.MyobPlugin;
import com.anahata.myob.api.auth.OAuthAccessToken;
import com.anahata.myob.api.auth.OauthAuthenticator;
import com.anahata.myob.api.auth.OauthLoginCallBack;
import java.net.URLDecoder;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JavaFXOAuthAuthenticatorApp
extends Application {
    private static final Logger log = LoggerFactory.getLogger(JavaFXOAuthAuthenticatorApp.class);
    private static final String CODE_PARAMETER = "code=";
    private static MyobPlugin plugin;
    private static OauthLoginCallBack callBack;
    public static OAuthAccessToken ret;
    private static Stage mainStage;

    public static void loginAndGetToken(final MyobPlugin plugin) throws Exception {
        JavaFXOAuthAuthenticatorApp.plugin = plugin;
        callBack = new OauthLoginCallBack(){

            @Override
            public void userLogon(String code) {
                try {
                    ret = OauthAuthenticator.getAccessToken(plugin, code);
                }
                catch (Exception e) {
                    log.error("Exception getting access token", (Throwable)e);
                    throw new RuntimeException(e);
                }
                Platform.exit();
            }
        };
        JavaFXOAuthAuthenticatorApp.launch((String[])new String[0]);
    }

    public void start(Stage stage) throws Exception {
        mainStage = stage;
        JavaFXOAuthAuthenticatorApp.login(stage, plugin, callBack);
    }

    public static void login(final @NonNull Stage stage, @NonNull MyobPlugin plugin, final @NonNull OauthLoginCallBack callBack) throws Exception {
        if (stage == null) {
            throw new NullPointerException("stage");
        }
        if (plugin == null) {
            throw new NullPointerException("plugin");
        }
        if (callBack == null) {
            throw new NullPointerException("callBack");
        }
        final WebView wb = new WebView();
        stage.setWidth(500.0);
        stage.setHeight(500.0);
        stage.setScene(new Scene((Parent)wb));
        stage.show();
        String url = OauthAuthenticator.getloginUrl(plugin.getKey(), plugin.getRedirectURL());
        final Runnable checkLocation = new Runnable(){

            @Override
            public void run() {
                String loc = wb.getEngine().getLocation();
                if (loc.contains(JavaFXOAuthAuthenticatorApp.CODE_PARAMETER)) {
                    String code = URLDecoder.decode(loc.substring(loc.indexOf(JavaFXOAuthAuthenticatorApp.CODE_PARAMETER) + JavaFXOAuthAuthenticatorApp.CODE_PARAMETER.length()));
                    log.debug("myob auth code() = " + code);
                    callBack.userLogon(code);
                    stage.close();
                }
            }
        };
        wb.getEngine().documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                log.debug("wb.getEngine().getDocument().getLocation() newValue= " + wb.getEngine().getLocation() + " UA=" + wb.getEngine().getUserAgent());
                checkLocation.run();
            }
        });
        wb.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                log.debug("wb.getEngine().getLoadWorker() URL {} = state = {}", (Object)wb.getEngine().getLocation(), (Object)newValue);
                checkLocation.run();
            }
        });
        log.debug("Opening {}", (Object)url);
        wb.getEngine().load(url);
    }

    public static void loginAndGetToken(MyobEndPointProvider provider) throws Exception {
        Stage stage = new Stage();
        MyobEndPoint mep = provider.getEndPoint();
        JavaFXOAuthAuthenticatorApp.login(stage, mep.getOauthAccessToken().getPlugin(), code -> {
            try {
                OAuthAccessToken token = OauthAuthenticator.getAccessToken(mep.getOauthAccessToken().getPlugin(), code);
                log.debug("Got token {}", (Object)token);
                mep.setOauthAccessToken(token);
                provider.oauthTokenRefreshed(mep);
            }
            catch (Exception e) {
                log.error("Exception getting access token", (Throwable)e);
            }
        });
    }
}

