/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.transport;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.service.exception.MyobException;
import com.anahata.myob.api.transport.AbstractMyobTransport;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnectionMyobTransport
extends AbstractMyobTransport {
    private static final Logger log = LoggerFactory.getLogger(HttpURLConnectionMyobTransport.class);

    @Override
    public String sendReceive(MyobEndPoint endPoint, String method, String requestBody, String url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("x-myobapi-version", this.getApiVersion());
        if (endPoint.getCredentials() != null) {
            conn.setRequestProperty("x-myobapi-cftoken", HttpURLConnectionMyobTransport.makeCFTokenHeader(endPoint.getCredentials()));
        }
        if (endPoint.getOauthAccessToken() != null) {
            conn.setRequestProperty("Authorization", "Bearer " + endPoint.getOauthAccessToken().getAccessToken());
            conn.setRequestProperty("x-myobapi-key", endPoint.getOauthAccessToken().getPlugin().getKey());
        }
        if (method != null) {
            conn.setRequestMethod(method);
        }
        conn.setRequestProperty("Content-Type", "text/json");
        if (requestBody != null) {
            conn.setDoOutput(true);
            IOUtils.write((String)requestBody, (OutputStream)conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                log.debug("Record is created");
            } else if (conn.getResponseCode() != 200) {
                throw new MyobException(conn.getResponseCode(), conn.getResponseMessage());
            }
        }
        String ret = IOUtils.toString((InputStream)conn.getInputStream());
        log.debug("Received {}", (Object)ret);
        return ret;
    }
}

