/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.service;

import com.anahata.myob.api.domain.v2.BaseEntity;
import com.anahata.myob.api.domain.v2.EntityPage;
import com.anahata.myob.api.service.AbstractMyobService;
import com.anahata.myob.api.service.exception.MyobException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityMyobService<T extends EntityPage<U>, U extends BaseEntity>
extends AbstractMyobService {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityMyobService.class);
    private final Class<T> pageType;
    private final Class<U> entityType;

    protected AbstractEntityMyobService(String context, Class<T> pageType, Class<U> entityType) {
        super(context);
        this.pageType = pageType;
        this.entityType = entityType;
    }

    public List<U> findAll() throws MyobException {
        String json = this.sendReceiveUID(null, null, null);
        EntityPage page = (EntityPage)AbstractEntityMyobService.fromJson(json, this.pageType);
        ArrayList ret = new ArrayList();
        Number count = page.getCount();
        if (count.intValue() <= 400) {
            ret.addAll(page.getItems());
        }
        while (!page.isLast()) {
            json = this.sendReceiveUID(null, null, "?$top=" + count);
            page = (EntityPage)AbstractEntityMyobService.fromJson(json, this.pageType);
            ret.addAll(page.getItems());
        }
        return ret;
    }

    public U find(String uid) throws MyobException {
        String ret = this.sendReceiveUID(null, null, uid);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }

    public U update(U item) throws MyobException {
        String ret = this.sendReceiveUID("PUT", AbstractEntityMyobService.toJson(item), ((BaseEntity)item).getUID());
        item = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return item;
    }

    public U create(U item) throws MyobException {
        String ret = this.sendReceiveUID("POST", AbstractEntityMyobService.toJson(item), null);
        return (U)((BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType));
    }

    public U remove(String uid) throws MyobException {
        String ret = this.sendReceiveUID("DELETE", null, uid);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }
}

