/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.transport;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.service.exception.MyobException;
import com.anahata.myob.api.transport.AbstractMyobTransport;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientMyobTransport
extends AbstractMyobTransport {
    private static final Logger log = LoggerFactory.getLogger(HttpClientMyobTransport.class);
    private static HttpClient httpClient = HttpClientBuilder.create().build();

    @Override
    public String sendReceive(MyobEndPoint dataFile, String context, String method, String requestBody, String uID) throws MalformedURLException, IOException {
        String url = HttpClientMyobTransport.makeURL(dataFile, context, method, uID);
        HttpGet request = new HttpGet(url);
        if (method != null) {
            switch (method) {
                case "POST": {
                    request = new HttpPost(url);
                    break;
                }
                case "PUT": {
                    request = new HttpPut(url);
                    break;
                }
                case "DELETE": {
                    request = new HttpDelete(url);
                }
            }
        }
        request.addHeader("x-myobapi-version", this.getApiVersion());
        if (dataFile.getCredentials() != null) {
            request.addHeader("x-myobapi-cftoken", HttpClientMyobTransport.makeCFTokenHeader(dataFile.getCredentials()));
        }
        if (dataFile.getOauthAccessToken() != null) {
            request.addHeader("Authorization", "Bearer " + dataFile.getOauthAccessToken().getAccessToken());
            request.addHeader("x-myobapi-key", dataFile.getOauthAccessToken().getPlugin().getKey());
        }
        request.addHeader("Content-Type", "text/json");
        if (requestBody != null && request instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new StringEntity(requestBody));
        }
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            String ret = (String)httpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
            log.debug("Got response from MYOB {} " + url, (Object)ret);
            return ret;
        }
        catch (HttpResponseException e) {
            log.debug("Exception caught calling Myob API {}, rethrowing as MyobServiceException", (Throwable)e);
            throw new MyobException(e.getStatusCode(), e.getMessage(), e);
        }
    }
}

