/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.service;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.MyobEndPointProvider;
import com.anahata.myob.api.service.exception.MyobException;
import com.anahata.myob.api.transport.AbstractMyobTransport;
import com.anahata.myob.api.transport.HttpClientMyobTransport;
import com.anahata.util.cdi.Cdi;
import com.google.gson.GsonBuilder;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMyobService {
    private static final Logger log = LoggerFactory.getLogger(AbstractMyobService.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").setPrettyPrinting();
    private AbstractMyobTransport transport = new HttpClientMyobTransport();
    private MyobEndPointProvider endPointProvider;
    protected final String context;

    protected AbstractMyobService(String context) {
        this.context = context;
    }

    protected static <X> X fromJson(String json, Class<X> type) {
        Object item = GSON_BUILDER.create().fromJson(json, type);
        return (X)item;
    }

    protected static String toJson(Object o) {
        String s = GSON_BUILDER.create().toJson(o);
        return s;
    }

    protected String sendReceive(String method, String params, String uId) throws MyobException {
        MyobEndPointProvider p = this.endPointProvider;
        if (p == null) {
            try {
                p = (MyobEndPointProvider)Cdi.get(MyobEndPointProvider.class, (Annotation[])new Annotation[0]);
            }
            catch (Exception e) {
                log.debug("EndPointProvider not ser and could not be looked up via CDI", (Throwable)e);
                throw new MyobException("EndPointProvider not ser and could not be looked up via CDI", e);
            }
        }
        try {
            MyobEndPoint mep = p.getEndPoint();
            p.refreshTokenIfRequired();
            return this.transport.sendReceive(mep, this.context, method, params, uId);
        }
        catch (Exception e) {
            log.error("Exception on MYOB Service", (Throwable)e);
            throw e instanceof MyobException ? (MyobException)e : new MyobException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        Date date = new SimpleDateFormat(DATE_FORMAT).parse("2014-12-06T17:27:07");
        System.out.println(date);
    }

    public void setEndPointProvider(MyobEndPointProvider endPointProvider) {
        this.endPointProvider = endPointProvider;
    }

    public MyobEndPointProvider getEndPointProvider() {
        return this.endPointProvider;
    }
}

