/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.service;

import com.anahata.myob.api.domain.v2.BaseEntity;
import com.anahata.myob.api.domain.v2.EntityPage;
import com.anahata.myob.api.service.AbstractMyobService;
import com.anahata.myob.api.service.exception.MyobException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityMyobService<T extends EntityPage<U>, U extends BaseEntity>
extends AbstractMyobService {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityMyobService.class);
    private final Class<T> pageType;
    private final Class<U> entityType;

    protected AbstractEntityMyobService(String context, Class<T> pageType, Class<U> entityType) {
        super(context);
        this.pageType = pageType;
        this.entityType = entityType;
    }

    public List<U> findAll() throws MyobException {
        String ret = this.sendReceive(null, null, null);
        EntityPage all = (EntityPage)AbstractEntityMyobService.fromJson(ret, this.pageType);
        return all.getItems();
    }

    public U find(String uid) throws MyobException {
        String ret = this.sendReceive(null, null, uid);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }

    public U update(U item) throws MyobException {
        String ret = this.sendReceive("PUT", AbstractEntityMyobService.toJson(item), ((BaseEntity)item).getUID());
        item = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return item;
    }

    public U create(U item) throws MyobException {
        String ret = this.sendReceive("POST", AbstractEntityMyobService.toJson(item), null);
        return (U)((BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType));
    }

    public U remove(String uid) throws MyobException {
        String ret = this.sendReceive("DELETE", null, uid);
        BaseEntity all = (BaseEntity)AbstractEntityMyobService.fromJson(ret, this.entityType);
        return (U)all;
    }
}

