/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api;

import com.anahata.myob.api.auth.DataFileCredentials;
import com.anahata.myob.api.auth.MyobPlugin;
import com.anahata.myob.api.auth.OAuthAccessToken;
import com.anahata.myob.api.auth.OauthAuthenticator;
import java.io.Serializable;
import lombok.NonNull;

public class MyobEndPoint
implements Serializable {
    public static final String CLOUD_ENDPOINT = "https://api.myob.com/accountright/";
    private final String uri;
    private DataFileCredentials credentials;
    private OAuthAccessToken oauthAccessToken;

    public MyobEndPoint(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.uri = uri;
        this.credentials = new DataFileCredentials();
    }

    public MyobEndPoint(@NonNull String uri, DataFileCredentials credentials) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        this.uri = uri;
        this.credentials = credentials;
    }

    public MyobEndPoint(@NonNull String uri, DataFileCredentials credentials, @NonNull OAuthAccessToken oauthCredentials) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (oauthCredentials == null) {
            throw new NullPointerException("oauthCredentials");
        }
        this.uri = uri;
        this.credentials = credentials;
        this.oauthAccessToken = oauthCredentials;
    }

    public synchronized void refreshOAuthToken() throws Exception {
        this.oauthAccessToken = OauthAuthenticator.refreshAccessToken(this.oauthAccessToken);
    }

    public MyobPlugin plugin() {
        return this.oauthAccessToken != null ? this.oauthAccessToken.getPlugin() : null;
    }

    public String toString() {
        return "MyobEndPoint{\nuri=" + this.uri + "\ncredentials=" + this.credentials + "\noauthAccessToken=" + this.oauthAccessToken + '}';
    }

    public void setCredentials(DataFileCredentials credentials) {
        this.credentials = credentials;
    }

    public void setOauthAccessToken(OAuthAccessToken oauthAccessToken) {
        this.oauthAccessToken = oauthAccessToken;
    }

    public String getUri() {
        return this.uri;
    }

    public DataFileCredentials getCredentials() {
        return this.credentials;
    }

    public OAuthAccessToken getOauthAccessToken() {
        return this.oauthAccessToken;
    }
}

