/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.transport;

import com.anahata.myob.api.MyobEndPoint;
import com.anahata.myob.api.auth.DataFileCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public abstract class AbstractMyobTransport {
    private static final Logger log = LoggerFactory.getLogger(AbstractMyobTransport.class);
    protected static final String MYOB_API_CFTOKEN_HEADER = "x-myobapi-cftoken";
    protected static final String MYOB_API_VERSION_HEADER = "x-myobapi-version";
    protected static final String MYOB_API_KEY_HEADER = "x-myobapi-key";
    protected static final String MYOB_API_AUTHORIZATION_HEADER = "Authorization";
    protected static final String MYOB_API_AUTHORIZATION_HEADER_BEARER = "Bearer ";
    private String apiVersion = "v2";

    public abstract String sendReceive(MyobEndPoint var1, String var2, String var3, String var4, String var5) throws Exception;

    protected static String makeCFTokenHeader(DataFileCredentials dataFile) {
        String val = dataFile.getUser() + ":" + dataFile.getPassword();
        return new BASE64Encoder().encode(val.getBytes());
    }

    protected static String makeURL(MyobEndPoint dataFile, String context, String method, String uID) {
        method = method == null ? "GET" : method.toUpperCase();
        String url = dataFile.getUri();
        if (context != null) {
            url = url + "/" + context;
            if (uID != null) {
                url = url + "/" + uID;
            }
        }
        if (method != null && (method.equals("PUT") || method.equals("POST"))) {
            url = url + "?returnBody=true";
        }
        return url;
    }

    public static void main(String[] args) {
        System.out.println(new BASE64Encoder().encode("Administrator:".getBytes()));
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

