/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api;

import com.anahata.myob.api.MyobDataFile;
import com.anahata.myob.api.MyobDataFileProvider;
import com.anahata.myob.api.service.exception.MyobServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class MyobTransport {
    private static final Logger log = LoggerFactory.getLogger(MyobTransport.class);
    protected static final String MYOB_API_CFTOKEN_HEADER = "x-myobapi-cftoken";
    protected static final String MYOB_API_VERSION_HEADER = "x-myobapi-version";
    protected static final String MYOB_API_KEY_HEADER = "x-myobapi-key";
    protected static final String MYOB_API_AUTHORIZATION_HEADER = "Authorization";
    protected static final String MYOB_API_AUTHORIZATION_HEADER_BEARER = "Bearer ";
    private String apiVersion = "v2";

    public String sendReceive(MyobDataFileProvider provider, String method, @NonNull String context, String requestBody, String uID) throws MalformedURLException, IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        MyobDataFile dataFile = provider.getDataFile();
        String url = uID != null ? dataFile.getFileURL() + "/" + context + "/" + uID : dataFile.getFileURL() + "/" + context;
        if (method != null && (method.equals("PUT") || method.equals("POST"))) {
            url = url + "?returnBody=true";
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty(MYOB_API_CFTOKEN_HEADER, MyobTransport.makeAuthKey(dataFile));
        conn.setRequestProperty(MYOB_API_VERSION_HEADER, this.getApiVersion());
        if (dataFile.isCloud()) {
            conn.setRequestProperty(MYOB_API_AUTHORIZATION_HEADER, MYOB_API_AUTHORIZATION_HEADER_BEARER + dataFile.getOauthCredentials().getAccessToken());
            conn.setRequestProperty(MYOB_API_KEY_HEADER, dataFile.getOauthCredentials().getClientId());
        }
        if (method != null) {
            conn.setRequestMethod(method);
        }
        conn.setRequestProperty("Content-Type", "text/json");
        if (requestBody != null) {
            conn.setDoOutput(true);
            IOUtils.write((String)requestBody, (OutputStream)conn.getOutputStream());
            if (conn.getResponseCode() == 201) {
                log.debug("Recode is Created");
            } else if (conn.getResponseCode() != 200) {
                throw new MyobServiceException(conn.getResponseCode(), conn.getResponseMessage());
            }
        }
        String ret = IOUtils.toString((InputStream)conn.getInputStream());
        log.debug("Received {}", (Object)ret);
        return ret;
    }

    private static String makeAuthKey(MyobDataFile dataFile) {
        String val = dataFile.getUser() + ":" + dataFile.getPassword();
        return new BASE64Encoder().encode(val.getBytes());
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

