/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api.service;

import com.anahata.myob.api.AppPropertiesMyobDataFile;
import com.anahata.myob.api.MyobDataFile;
import com.anahata.myob.api.MyobTransport;
import com.anahata.myob.api.domain.Page;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public abstract class AbstractMyobService<T extends Page, U> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMyobService.class);
    private MyobTransport transport = new MyobTransport();
    private final String context;
    private final Class<T> pageType;
    private final Class<U> entityType;
    @Inject
    private Instance<AppPropertiesMyobDataFile> appPropertiesDataFileFactory;

    public AbstractMyobService(MyobDataFile dataFile, String context, Class<T> pageType, Class<U> entityType) {
        if (dataFile != null) {
            this.transport.setDataFile(dataFile);
        }
        this.context = context;
        this.pageType = pageType;
        this.entityType = entityType;
    }

    @PostConstruct
    private void init() {
        if (this.transport.getDataFile() == null) {
            this.transport.setDataFile((MyobDataFile)this.appPropertiesDataFileFactory.get());
        }
    }

    public List<U> findAll() throws MalformedURLException, IOException {
        String ret = this.sendReceive(null, null);
        Gson gson = new GsonBuilder().create();
        Page all = (Page)gson.fromJson(ret, this.pageType);
        Validate.isTrue((all.getNextPageLink() == null ? 1 : 0) != 0, (String)"pagination not implemented yet", (Object[])new Object[0]);
        return all.getItems();
    }

    public U update(U item) throws MalformedURLException, IOException {
        String params = new Gson().toJson(item);
        String ret = this.sendReceive("PUT", params);
        Gson gson = new GsonBuilder().create();
        item = gson.fromJson(ret, this.entityType);
        return item;
    }

    protected String sendReceive(String method, String params) throws IOException {
        return this.transport.sendReceive(method, this.context, params);
    }

    @ConstructorProperties(value={"context", "pageType", "entityType"})
    public AbstractMyobService(String context, Class<T> pageType, Class<U> entityType) {
        this.context = context;
        this.pageType = pageType;
        this.entityType = entityType;
    }
}

