/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.myob.api;

import com.anahata.myob.api.MyobDataFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class MyobTransport {
    private static final Logger log = LoggerFactory.getLogger(MyobTransport.class);
    protected static final String MYOB_API_CFTOKEN_HEADER = "x-myobapi-cftoken";
    protected static final String MYOB_API_VERSION_HEADER = "x-myobapi-version";
    private String apiVersion = "v2";
    private MyobDataFile dataFile;

    public String sendReceive(String method, @NonNull String context, String requestBody) throws MalformedURLException, IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        URL url = new URL(this.dataFile.getEndpoint() + "/" + context);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty(MYOB_API_CFTOKEN_HEADER, this.makeAuthKey());
        conn.setRequestProperty(MYOB_API_VERSION_HEADER, this.getApiVersion());
        if (method != null) {
            conn.setRequestMethod(method);
        }
        conn.setRequestProperty("Content-Type", "text/json");
        if (requestBody != null) {
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            IOUtils.write((String)requestBody, (Writer)writer);
            if (conn.getResponseCode() != 200) {
                throw new IOException(conn.getResponseMessage() + "   " + conn.getResponseCode());
            }
        }
        String ret = IOUtils.toString((InputStream)conn.getInputStream());
        log.debug("Received {}", (Object)ret);
        return ret;
    }

    private String makeAuthKey() {
        String val = this.dataFile.getUser() + ":" + this.dataFile.getPassword();
        return new BASE64Encoder().encode(val.getBytes());
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setDataFile(MyobDataFile dataFile) {
        this.dataFile = dataFile;
    }

    public MyobDataFile getDataFile() {
        return this.dataFile;
    }
}

