/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.metamodel;

import com.anahata.util.metamodel.MetaModel;
import com.anahata.util.metamodel.MetaModelProperty;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class MetaModelGenerator
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(MetaModelGenerator.class);
    @Parameter(required=true)
    private List<String> classes;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/metamodel")
    private String outputDirectory;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.classes == null || this.classes.isEmpty()) {
            throw new MojoExecutionException("No classes were listed, at least one is required");
        }
        try {
            ClassRealm c = (ClassRealm)Thread.currentThread().getContextClassLoader();
            c.addURL(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            for (URL uRL : this.buildClassPath()) {
                c.addURL(uRL);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception building classpath", e);
        }
        JCodeModel jcm = new JCodeModel();
        ArrayList sourceClasses = new ArrayList();
        ArrayList<JDefinedClass> definedClasses = new ArrayList<JDefinedClass>();
        for (String className : this.classes) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
                sourceClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Could not reference class: " + className, (Exception)e);
            }
            try {
                definedClasses.add(this.createClass(jcm, clazz));
            }
            catch (JClassAlreadyExistsException e) {
                throw new MojoExecutionException("Class defined twice: " + className, (Exception)((Object)e));
            }
        }
        for (JDefinedClass definedClass : definedClasses) {
            for (JFieldVar var : definedClass.fields().values()) {
                if (!(var.type() instanceof JDefinedClass)) continue;
                JDefinedClass jdclass = (JDefinedClass)var.type();
                String string = jdclass._package().name() + "." + jdclass.name();
            }
        }
        try {
            File file = new File(this.outputDirectory);
            file.mkdirs();
            jcm.build(file, file);
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("Error creating output files", (Exception)iOException);
        }
    }

    private JDefinedClass createClass(JCodeModel jcm, Class clazz) throws JClassAlreadyExistsException {
        JDefinedClass jdc = jcm._class(clazz.getName() + "_mm");
        for (PropertyDescriptor pd : PropertyUtils.getPropertyDescriptors((Class)clazz)) {
            if (pd.getName().equals("class")) continue;
            this.createProperty(jcm, jdc, clazz, pd);
        }
        jdc._extends(jcm.ref(MetaModel.class));
        jdc.field(25, (JType)jdc, "INSTANCE", (JExpression)JExpr._new((JClass)jdc));
        JMethod constructor = jdc.constructor(1);
        JInvocation invoke = constructor.body().invoke("super");
        invoke.arg(JExpr.dotclass((JClass)jcm.ref(clazz)));
        return jdc;
    }

    private void createProperty(JCodeModel jcm, JDefinedClass jdc, Class clazz, PropertyDescriptor pd) throws JClassAlreadyExistsException {
        String fieldName = pd.getName();
        System.out.println("Creating public static class for field " + fieldName + " on=" + jdc.fullName());
        try {
            JDefinedClass fieldClass = jdc._class(17, fieldName);
            fieldClass._extends(jcm.ref(MetaModelProperty.class));
            fieldClass.field(25, (JType)fieldClass, "INSTANCE", (JExpression)JExpr._new((JClass)fieldClass));
            JMethod constructor = fieldClass.constructor(1);
            JInvocation invoke = constructor.body().invoke("super");
            invoke.arg(JExpr.dotclass((JClass)jcm.ref(clazz)));
            invoke.arg(JExpr.dotclass((JClass)jcm._ref(pd.getPropertyType()).boxify()));
            invoke.arg(fieldName);
        }
        catch (Exception e) {
            log.error("Exception generating metamodel property", (Throwable)e);
            throw new RuntimeException("Exception generating metamodel property for " + pd.getName() + " on class" + jdc.name() + " . This can happen when a field and its corresponding getter do not match in case like: user1product and the getter or setter being user1Product (with upper case P)", e);
        }
        System.out.println("Creating public static class " + fieldName + " on=" + jdc.fullName() + " OK");
    }

    private URL[] buildClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            log.debug("Adding artifact to classpath: " + a);
            urls.add(a.getFile().toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

