/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.util;

import com.anahata.webstart.util.IOUtil;
import com.anahata.webstart.util.JarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JarUtil.class, hint="default")
public class DefaultJarUtil
implements JarUtil {
    @Requirement
    protected IOUtil ioUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateManifestEntries(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        Manifest manifest = this.createManifest(jar, manifestentries);
        File updatedUnprocessedJarFile = new File(jar.getParent(), jar.getName() + "_updateManifestEntriesJar");
        ZipFile originalJar = null;
        JarOutputStream targetJar = null;
        try {
            originalJar = new ZipFile(jar);
            targetJar = new JarOutputStream((OutputStream)new FileOutputStream(updatedUnprocessedJarFile), manifest);
            Enumeration<? extends ZipEntry> entries = originalJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                targetJar.putNextEntry(newEntry);
                if (!entry.isDirectory()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = originalJar.getInputStream(entry);
                        org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)targetJar);
                        inputStream.close();
                    }
                    finally {
                        org.apache.maven.shared.utils.io.IOUtil.close((InputStream)inputStream);
                    }
                }
                targetJar.closeEntry();
            }
            targetJar.close();
            originalJar.close();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while updating manifest of " + jar.getName(), (Exception)e);
            }
            catch (Throwable throwable) {
                org.apache.maven.shared.utils.io.IOUtil.close(targetJar);
                this.ioUtil.close(originalJar);
                throw throwable;
            }
        }
        org.apache.maven.shared.utils.io.IOUtil.close((OutputStream)targetJar);
        this.ioUtil.close(originalJar);
        this.ioUtil.deleteFile(jar);
        this.ioUtil.renameTo(updatedUnprocessedJarFile, jar);
    }

    protected Manifest createManifest(File jar, Map<String, String> manifestentries) throws MojoExecutionException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null || manifest.getMainAttributes().isEmpty()) {
                manifest = new Manifest();
                manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            if (manifest.getMainAttributes().containsKey(Attributes.Name.CLASS_PATH)) {
                System.out.println("Removing " + Attributes.Name.CLASS_PATH + " MANIFEST entry from " + jar);
                manifest.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
            }
            Set<Map.Entry<String, String>> entrySet = manifestentries.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                manifest.getMainAttributes().putValue(entry.getKey(), entry.getValue());
            }
            System.out.println("-----Removing entries with signatures-------");
            block6: for (String string : new ArrayList<String>(manifest.getEntries().keySet())) {
                Attributes atts = manifest.getEntries().get(string);
                for (Map.Entry<Object, Object> entry : atts.entrySet()) {
                    if (!entry.getKey().toString().toLowerCase().contains("digest")) continue;
                    Attributes ret = manifest.getEntries().remove(string);
                    System.out.println("Removed " + ret.keySet() + " " + ret.values());
                    continue block6;
                }
            }
            System.out.println("Final Manifest for " + jar);
            System.out.println("------ Main attributes-----");
            for (Object object : manifest.getMainAttributes().keySet()) {
                System.out.println(object + " = " + manifest.getMainAttributes().get(object));
            }
            System.out.println("-----Entries-------");
            for (String string : manifest.getEntries().keySet()) {
                System.out.println(string + " = " + manifest.getEntries().get(string).values());
            }
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading manifest from " + jar.getAbsolutePath(), (Exception)e);
        }
        finally {
            this.ioUtil.close(jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(File jar, File fileToAdd, String zipEntryName) throws MojoExecutionException {
        File updatedUnprocessedJarFile = new File(jar.getParent(), jar.getName() + "_addFileJar");
        ZipFile originalJar = null;
        JarOutputStream targetJar = null;
        try {
            originalJar = new ZipFile(jar);
            targetJar = new JarOutputStream(new FileOutputStream(updatedUnprocessedJarFile));
            Enumeration<? extends ZipEntry> entries = originalJar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (zipEntryName.equals(entry.getName())) continue;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                targetJar.putNextEntry(newEntry);
                if (!entry.isDirectory()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = originalJar.getInputStream(entry);
                        org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)targetJar);
                        inputStream.close();
                    }
                    finally {
                        org.apache.maven.shared.utils.io.IOUtil.close((InputStream)inputStream);
                    }
                }
                targetJar.closeEntry();
            }
            ZipEntry newEntry = new ZipEntry(zipEntryName);
            targetJar.putNextEntry(newEntry);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(fileToAdd);
                org.codehaus.plexus.util.IOUtil.copy((InputStream)inputStream, (OutputStream)targetJar);
                ((InputStream)inputStream).close();
            }
            catch (Throwable throwable) {
                org.apache.maven.shared.utils.io.IOUtil.close(inputStream);
                throw throwable;
            }
            org.apache.maven.shared.utils.io.IOUtil.close((InputStream)inputStream);
            targetJar.close();
            originalJar.close();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while adding " + fileToAdd.getAbsolutePath() + " as " + zipEntryName + " to " + jar.getName(), (Exception)e);
            }
            catch (Throwable throwable) {
                org.apache.maven.shared.utils.io.IOUtil.close(targetJar);
                this.ioUtil.close(originalJar);
                throw throwable;
            }
        }
        org.apache.maven.shared.utils.io.IOUtil.close((OutputStream)targetJar);
        this.ioUtil.close(originalJar);
        this.ioUtil.deleteFile(jar);
        this.ioUtil.renameTo(updatedUnprocessedJarFile, jar);
    }

    @Override
    public void deleteFile(File jar, String location) throws MojoExecutionException {
        HashMap<String, String> zip_properties = new HashMap<String, String>();
        zip_properties.put("create", "false");
        String absolutePath = jar.getAbsolutePath();
        if (!absolutePath.startsWith("/")) {
            absolutePath = "///" + absolutePath.replace("\\", "/");
        }
        URI zip_disk = URI.create("jar:file:" + absolutePath);
        System.out.println("deleting " + zip_disk);
        try (FileSystem zipfs = FileSystems.newFileSystem(zip_disk, zip_properties);){
            Path pathInZipfile = zipfs.getPath(location, new String[0]);
            if (Files.exists(pathInZipfile, new LinkOption[0])) {
                System.out.println("About to delete  " + location);
                Files.delete(pathInZipfile);
            }
            System.out.println("File successfully deleted");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new MojoExecutionException("Exception deleting INDEX.LIST", (Exception)ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        URI zip_disk = new URI("jar:file:///E:/Projects/links/links-bms/links-bms-web/target/jnlp/lib/unprocessed_ch.qos.cal10n-cal10n-api__V0.8.1.jar");
        System.out.println("deleting " + zip_disk);
        HashMap<String, String> zip_properties = new HashMap<String, String>();
        zip_properties.put("create", "false");
        FileSystem zipfs = FileSystems.newFileSystem(zip_disk, zip_properties, null);
        Throwable throwable = null;
        if (zipfs != null) {
            if (throwable != null) {
                try {
                    zipfs.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                zipfs.close();
            }
        }
    }
}

