/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.util;

import com.anahata.webstart.JarResource;
import com.anahata.webstart.util.ArtifactUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArtifactUtil.class, hint="default")
public class DefaultArtifactUtil
extends AbstractLogEnabled
implements ArtifactUtil {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;

    @Override
    public Artifact createArtifact(JarResource jarResource) {
        if (jarResource.getClassifier() == null) {
            return this.artifactFactory.createArtifact(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "runtime", "jar");
        }
        return this.artifactFactory.createArtifactWithClassifier(jarResource.getGroupId(), jarResource.getArtifactId(), jarResource.getVersion(), "jar", jarResource.getClassifier());
    }

    @Override
    public MavenProject resolveFromReactor(Artifact artifact, MavenProject mp, List<MavenProject> reactorProjects) throws MojoExecutionException {
        MavenProject result = null;
        String artifactId = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        if (CollectionUtils.isNotEmpty(reactorProjects)) {
            for (MavenProject reactorProject : reactorProjects) {
                if (!reactorProject.getArtifactId().equals(artifactId) || !reactorProject.getGroupId().equals(groupId)) continue;
                result = reactorProject;
                break;
            }
        }
        return result;
    }

    @Override
    public void resolveFromRepositories(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws MojoExecutionException {
        try {
            this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Could not resolv artifact: " + artifact, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Could not find artifact: " + artifact, (Exception)((Object)e));
        }
    }

    @Override
    public Set<Artifact> resolveTransitively(Set<Artifact> jarResourceArtifacts, Set<MavenProject> siblingProjects, Artifact originateArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactFilter artifactFilter, Map managedVersions) throws MojoExecutionException {
        LinkedHashSet<Artifact> resultArtifacts = new LinkedHashSet<Artifact>();
        if (CollectionUtils.isNotEmpty(siblingProjects)) {
            for (MavenProject siblingProject : siblingProjects) {
                Set artifacts = siblingProject.getArtifacts();
                for (Artifact artifact : artifacts) {
                    if (!artifactFilter.include(artifact)) continue;
                    resultArtifacts.add(artifact);
                }
            }
        }
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(jarResourceArtifacts, originateArtifact, managedVersions, localRepository, remoteRepositories, this.artifactMetadataSource, artifactFilter);
            resultArtifacts.addAll(result.getArtifacts());
            return resultArtifacts;
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Could not resolv transitive dependencies", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Could not find transitive dependencies ", (Exception)((Object)e));
        }
    }

    @Override
    public boolean artifactContainsClass(Artifact artifact, String mainClass) throws MojoExecutionException {
        URL url;
        boolean containsClass = true;
        try {
            url = artifact.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not get artifact url: " + artifact.getFile(), (Exception)e);
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{url});
        Class<?> c = null;
        try {
            c = Class.forName(mainClass, false, cl);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().debug("artifact " + artifact + " doesn't contain the main class: " + mainClass);
            containsClass = false;
        }
        catch (Throwable t) {
            this.getLogger().info("artifact " + artifact + " seems to contain the main class: " + mainClass + " but the jar doesn't seem to contain all dependencies " + t.getMessage());
        }
        if (c != null) {
            this.getLogger().debug("Checking if the loaded class contains a main method.");
            try {
                c.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().warn("The specified main class (" + mainClass + ") doesn't seem to contain a main method... " + "Please check your configuration." + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warn("Something failed while checking if the main class contains the main() method. This is probably due to the limited classpath we have provided to the class loader. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method... " + e.getMessage());
            }
            catch (Throwable t) {
                this.getLogger().error("Unknown error: Couldn't check if the main class has a main method. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method...", t);
            }
        }
        return containsClass;
    }
}

