/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.sign;

import com.anahata.webstart.sign.SignConfig;
import com.anahata.webstart.sign.SignTool;
import com.anahata.webstart.util.IOUtil;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ConcurrentJarSigner {
    int threads;
    ExecutorService executor;

    public ConcurrentJarSigner() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ConcurrentJarSigner(int threads) {
        this.threads = threads;
        this.executor = Executors.newFixedThreadPool(threads);
    }

    public void execute(File[] jarFiles, IOUtil ioUtil, SignTool signTool, SignConfig signConfig, Log logger, boolean signVerify) throws MojoExecutionException {
        logger.info((CharSequence)("Signing jars with " + this.threads + " threads"));
        long startTime = System.nanoTime();
        for (File jarFile : jarFiles) {
            SignJarRunnable task = new SignJarRunnable(jarFile, ioUtil, signTool, signConfig, logger, signVerify);
            this.executor.execute(task);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Error shutting down ConcurrentJarSigner", (Exception)e);
        }
        finally {
            long endTime = System.nanoTime();
            long elapsedTime = (endTime - startTime) / 1000000000L;
            logger.info((CharSequence)("Signing took " + elapsedTime + " seconds."));
        }
    }

    private class SignJarRunnable
    implements Runnable {
        private File jarFile;
        private IOUtil ioUtil;
        private SignTool signTool;
        private SignConfig signConfig;
        private Log logger;
        private boolean signVerify;

        private SignJarRunnable(File jarFile, IOUtil ioUtil, SignTool signTool, SignConfig signConfig, Log logger, boolean signVerify) {
            this.jarFile = jarFile;
            this.ioUtil = ioUtil;
            this.signTool = signTool;
            this.signConfig = signConfig;
            this.logger = logger;
            this.signVerify = signVerify;
        }

        @Override
        public void run() {
            File signedJar = this.toProcessFile(this.jarFile);
            try {
                this.ioUtil.deleteFile(signedJar);
                this.logger.info((CharSequence)("Sign " + signedJar.getName()));
                this.signTool.sign(this.signConfig, this.jarFile, signedJar);
                this.logger.info((CharSequence)("lastModified signedJar:" + signedJar.lastModified() + " unprocessed signed Jar:" + this.jarFile.lastModified()));
                if (this.signVerify) {
                    this.logger.info((CharSequence)("Verify signature of " + signedJar.getName()));
                    this.signTool.verify(this.signConfig, signedJar, true);
                }
                this.ioUtil.deleteFile(this.jarFile);
            }
            catch (MojoExecutionException e) {
                this.logger.error((CharSequence)("Jar signing failed! " + e.getMessage()));
            }
        }

        private File toProcessFile(File source) {
            if (!source.getName().startsWith("unprocessed_")) {
                throw new IllegalStateException(source.getName() + " does not start with " + "unprocessed_");
            }
            String targetFilename = source.getName().substring("unprocessed_".length());
            return new File(source.getParentFile(), targetFilename);
        }
    }
}

