/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.generator;

import com.anahata.webstart.ResolvedJarResource;
import com.anahata.webstart.generator.AbstractGenerator;
import com.anahata.webstart.generator.GeneratorTechnicalConfig;
import com.anahata.webstart.generator.JarResourceGeneratorConfig;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class JarResourcesGenerator
extends AbstractGenerator<JarResourceGeneratorConfig> {
    private Log log;

    public JarResourcesGenerator(Log log, GeneratorTechnicalConfig technicalConfig, JarResourceGeneratorConfig extraConfig) {
        super(log, technicalConfig, extraConfig);
        this.log = log;
    }

    @Override
    protected String getDependenciesText() {
        String jarResourcesText = "";
        String libPath = ((JarResourceGeneratorConfig)this.getExtraConfig()).getLibPath();
        Collection<ResolvedJarResource> jarResources = ((JarResourceGeneratorConfig)this.getExtraConfig()).getJarResources();
        if (!jarResources.isEmpty()) {
            int multiplier = 100;
            StringBuilder buffer = new StringBuilder(100 * jarResources.size());
            buffer.append(EOL);
            for (ResolvedJarResource jarResource : jarResources) {
                if (!jarResource.isIncludeInJnlp()) continue;
                String type = jarResource.isNativelib() ? "nativelib" : "jar";
                buffer.append("<" + type + " href=\"");
                if (StringUtils.isNotEmpty((String)libPath)) {
                    buffer.append(libPath);
                    buffer.append('/');
                }
                buffer.append(jarResource.getHrefValue());
                buffer.append("\"");
                if (jarResource.isOutputJarVersion()) {
                    buffer.append(" version=\"").append(jarResource.getVersion()).append("\"");
                }
                if (jarResource.getDownload() != null && !jarResource.getDownload().isEmpty()) {
                    buffer.append(" download=\"").append(jarResource.getDownload()).append("\"");
                }
                if (jarResource.getMainClass() != null) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>").append(EOL);
            }
            jarResourcesText = buffer.toString();
        }
        this.log.info((CharSequence)("class= " + this.getClass().getSimpleName() + " -jarResourcesText= " + jarResourcesText));
        return jarResourcesText;
    }
}

