/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.generator;

import com.anahata.webstart.dependency.filenaming.DependencyFilenameStrategy;
import com.anahata.webstart.generator.GeneratorExtraConfigWithDeps;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;

public abstract class AbstractGeneratorExtraConfigWithDeps
implements GeneratorExtraConfigWithDeps {
    private final String libPath;
    private final boolean pack200;
    private final boolean outputJarVersions;
    private String download;
    private final boolean useUniqueVersions;
    private final Artifact artifactWithMainClass;
    private final DependencyFilenameStrategy dependencyFilenameStrategy;

    public AbstractGeneratorExtraConfigWithDeps(String libPath, boolean pack200, boolean outputJarVersions, String download, boolean useUniqueVersions, Artifact artifactWithMainClass, DependencyFilenameStrategy dependencyFilenameStrategy) {
        this.libPath = libPath;
        this.pack200 = pack200;
        this.outputJarVersions = outputJarVersions;
        this.download = download;
        this.useUniqueVersions = useUniqueVersions;
        this.artifactWithMainClass = artifactWithMainClass;
        this.dependencyFilenameStrategy = dependencyFilenameStrategy;
    }

    @Override
    public boolean isPack200() {
        return this.pack200;
    }

    @Override
    public boolean isOutputJarVersions() {
        return this.outputJarVersions;
    }

    @Override
    public boolean isUseUniqueVersions() {
        return this.useUniqueVersions;
    }

    @Override
    public String getLibPath() {
        return this.libPath;
    }

    @Override
    public boolean isArtifactWithMainClass(Artifact artifact) {
        return this.artifactWithMainClass != null && this.artifactWithMainClass.equals(artifact);
    }

    @Override
    public String getDependencyFilename(Artifact artifact, Boolean outputJarVersion, Boolean useUniqueVersions) {
        return this.dependencyFilenameStrategy.getDependencyFilename(artifact, outputJarVersion, useUniqueVersions);
    }

    @Override
    public String getDownload() {
        return StringUtils.isBlank((String)this.download) ? "progress" : this.download;
    }
}

