/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency.task;

import com.anahata.webstart.dependency.JnlpDependencyConfig;
import com.anahata.webstart.dependency.task.AbstractJnlpTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTaskException;
import com.anahata.webstart.sign.SignTool;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="UnsignTask", instantiationStrategy="per-lookup")
public class UnsignTask
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "UnsignTask";
    @Requirement
    private SignTool signTool;

    @Override
    public void check(JnlpDependencyConfig config) {
        boolean jarSigned;
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isSign()) {
            throw new IllegalStateException("Can't sign if config.isSign is false");
        }
        File file = config.getArtifact().getFile();
        try {
            jarSigned = this.signTool.isJarSigned(file);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        if (jarSigned && !config.isCanUnsign()) {
            throw new IllegalStateException("Can't unsign the config.artifact.file if config.isCanUsign is false");
        }
    }

    @Override
    public File execute(JnlpDependencyConfig config, File jarFile) throws JnlpDependencyTaskException {
        boolean jarSigned;
        try {
            jarSigned = JarSignerUtil.isArchiveSigned((File)jarFile);
        }
        catch (IOException e) {
            throw new JnlpDependencyTaskException("Could not detect if jar signed: " + jarFile, e);
        }
        if (jarSigned) {
            this.verboseLog(config, "Unsign jar " + jarFile);
            try {
                JarSignerUtil.unsignArchive((File)jarFile);
            }
            catch (IOException e) {
                throw new JnlpDependencyTaskException("Could not find unsign jar " + jarFile, e);
            }
        } else {
            this.verboseLog(config, "Jar " + jarFile + " is not signed.");
        }
        return jarFile;
    }
}

