/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency.task;

import com.anahata.webstart.dependency.JnlpDependencyConfig;
import com.anahata.webstart.dependency.task.AbstractJnlpTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTaskException;
import com.anahata.webstart.pack200.Pack200Tool;
import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="UnPack200Task", instantiationStrategy="per-lookup")
public class UnPack200Task
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "UnPack200Task";
    @Requirement(role=Pack200Tool.class)
    private Pack200Tool pack200Tool;

    @Override
    public void check(JnlpDependencyConfig config) {
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isPack200()) {
            throw new IllegalStateException("Can't pack200 if config.isPack200 is false");
        }
    }

    @Override
    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        this.verboseLog(config, "Unpack 200 file: " + file);
        try {
            File result = this.pack200Tool.unpackJar(file);
            this.getLogger().debug("Unpacked 200 file: " + result);
            return result;
        }
        catch (IOException e) {
            throw new JnlpDependencyTaskException("Could not pack200 jars: ", e);
        }
    }
}

