/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency.task;

import com.anahata.webstart.dependency.JnlpDependencyConfig;
import com.anahata.webstart.dependency.task.AbstractJnlpTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTask;
import com.anahata.webstart.dependency.task.JnlpDependencyTaskException;
import com.anahata.webstart.sign.SignConfig;
import com.anahata.webstart.sign.SignTool;
import com.anahata.webstart.util.IOUtil;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="SignTask", instantiationStrategy="per-lookup")
public class SignTask
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "SignTask";
    @Requirement
    private SignTool signTool;
    @Requirement
    private IOUtil ioUtil;

    @Override
    public void check(JnlpDependencyConfig config) {
        boolean jarSigned;
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isSign()) {
            throw new IllegalStateException("Can't sign if config.isSign is false");
        }
        File file = config.getArtifact().getFile();
        try {
            jarSigned = this.signTool.isJarSigned(file);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        if (jarSigned && !config.isCanUnsign()) {
            throw new IllegalStateException("Can't unsign the config.artifact.file if config.isCanUsign is false");
        }
    }

    @Override
    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        SignConfig sign = config.getSign();
        boolean signVerify = sign.isVerify();
        File signedJar = new File(file.getParentFile(), file.getName() + ".sign");
        try {
            this.ioUtil.deleteFile(signedJar);
        }
        catch (MojoExecutionException e) {
            throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
        }
        this.verboseLog(config, "Sign " + signedJar.getName());
        try {
            this.signTool.sign(sign, file, signedJar);
        }
        catch (MojoExecutionException e) {
            throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
        }
        this.getLogger().debug("lastModified signedJar:" + signedJar.lastModified() + " not signed Jar:" + file.lastModified());
        if (signVerify) {
            this.verboseLog(config, "Verify signature of " + signedJar.getName());
            try {
                this.signTool.verify(sign, signedJar, config.isVerbose());
            }
            catch (MojoExecutionException e) {
                throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
            }
        }
        return signedJar;
    }
}

