/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency.filenaming;

import com.anahata.webstart.dependency.filenaming.AbstractDependencyFilenameStrategy;
import com.anahata.webstart.dependency.filenaming.DependencyFilenameStrategy;
import com.anahata.webstart.dependency.filenaming.UniqueSnapshotVersionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=DependencyFilenameStrategy.class, hint="full")
public class FullDependencyFilenameStrategy
extends AbstractDependencyFilenameStrategy
implements DependencyFilenameStrategy {
    public static final String ROLE_HINT = "full";

    @Override
    public String getDependencyFileBasename(Artifact artifact, Boolean outputJarVersion, Boolean useUniqueVersions) {
        String filename = artifact.getGroupId() + "-" + artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            filename = filename + "-" + artifact.getClassifier();
        }
        if (outputJarVersion != null) {
            filename = outputJarVersion != false ? filename + "__V" : filename + "-";
            filename = useUniqueVersions != null && useUniqueVersions != false ? filename + UniqueSnapshotVersionUtils.getUniqueVersion(artifact) : filename + artifact.getVersion();
        }
        return filename;
    }
}

