/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency;

import com.anahata.webstart.dependency.JnlpDependencyConfig;
import com.anahata.webstart.dependency.task.JnlpDependencyTask;
import java.io.File;
import org.apache.maven.artifact.Artifact;

public class JnlpDependencyRequest {
    private final JnlpDependencyConfig config;
    private final JnlpDependencyTask[] tasks;
    private final File originalFile;
    private final File finalFile;
    private final boolean uptodate;

    public JnlpDependencyRequest(JnlpDependencyConfig config, JnlpDependencyTask ... tasks) {
        this.config = config;
        this.tasks = tasks;
        this.originalFile = this.buildOriginalFile();
        this.finalFile = this.buildFinalFile();
        File incomingFile = this.getConfig().getArtifact().getFile();
        long limitDate = incomingFile.lastModified();
        this.uptodate = this.originalFile.exists() && this.originalFile.lastModified() > limitDate && this.finalFile.exists() && this.finalFile.lastModified() > limitDate;
    }

    public JnlpDependencyConfig getConfig() {
        return this.config;
    }

    public JnlpDependencyTask[] getTasks() {
        return this.tasks;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public boolean isUptodate() {
        return this.uptodate;
    }

    public File getFinalFile() {
        return this.finalFile;
    }

    private File buildOriginalFile() {
        File workingDirectory = this.config.getWorkingDirectory();
        Artifact artifact = this.config.getArtifact();
        String fileName = this.config.getDependencyFilenameStrategy().getDependencyFilename(artifact, false, false);
        return new File(workingDirectory, fileName);
    }

    private File buildFinalFile() {
        File finalDirectory = this.config.getFinalDirectory();
        String filename = this.config.getDependencyFilenameStrategy().getDependencyFilename(this.config.getArtifact(), this.config.isOutputJarVersion(), this.config.isUseUniqueVersions());
        if (this.config.isPack200()) {
            filename = filename + ".pack";
        }
        if (this.config.isGzip()) {
            filename = filename + ".gz";
        }
        return new File(finalDirectory, filename);
    }
}

