/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency;

import com.anahata.webstart.dependency.JnlpDependencyGlobalConfig;
import com.anahata.webstart.dependency.filenaming.DependencyFilenameStrategy;
import com.anahata.webstart.sign.SignConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;

public class JnlpDependencyConfig {
    private final JnlpDependencyGlobalConfig globalConfig;
    private final Artifact artifact;
    private final boolean outputJarVersion;
    private final boolean useUniqueVersions;
    private final String download;
    private File workingDirectory;

    public JnlpDependencyConfig(JnlpDependencyGlobalConfig globalConfig, Artifact artifact, String finalName, boolean outputJarVersion, boolean useUniqueVersions, String download) {
        this.globalConfig = globalConfig;
        this.artifact = artifact;
        this.outputJarVersion = outputJarVersion;
        this.useUniqueVersions = useUniqueVersions;
        this.download = download;
        this.workingDirectory = new File(globalConfig.getWorkingDirectory(), finalName);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isOutputJarVersion() {
        return this.outputJarVersion;
    }

    public boolean isUseUniqueVersions() {
        return this.useUniqueVersions;
    }

    public DependencyFilenameStrategy getDependencyFilenameStrategy() {
        return this.globalConfig.getDependencyFilenameStrategy();
    }

    public File getFinalDirectory() {
        return this.globalConfig.getFinalDirectory();
    }

    public boolean isPack200() {
        return this.globalConfig.isPack200();
    }

    public List<String> getPack200PassFiles() {
        return this.globalConfig.getPack200PassFiles();
    }

    public boolean isGzip() {
        return this.globalConfig.isGzip();
    }

    public boolean isVerbose() {
        return this.globalConfig.isVerbose();
    }

    public SignConfig getSign() {
        return this.globalConfig.getSign();
    }

    public Map<String, String> getUpdateManifestEntries() {
        return this.globalConfig.getUpdateManifestEntries();
    }

    public boolean isUnsignAlreadySignedJars() {
        return this.globalConfig.isUnsignAlreadySignedJars();
    }

    public boolean isCanUnsign() {
        return this.globalConfig.isCanUnsign();
    }

    public boolean isSign() {
        return this.globalConfig.isSign();
    }

    public boolean isUpdateManifest() {
        return this.globalConfig.isUpdateManifest();
    }
}

