/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart.dependency;

import com.anahata.webstart.dependency.JnlpDependencyConfig;
import com.anahata.webstart.dependency.JnlpDependencyRequest;
import com.anahata.webstart.dependency.JnlpDependencyRequestConsumer;
import com.anahata.webstart.dependency.JnlpDependencyRequestConsumerConfig;
import com.anahata.webstart.dependency.JnlpDependencyRequests;
import com.anahata.webstart.dependency.JnlpDependencyResult;
import com.anahata.webstart.dependency.JnlpDependencyResults;
import com.anahata.webstart.dependency.task.JnlpDependencyTask;
import com.anahata.webstart.util.IOUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=JnlpDependencyRequestConsumer.class)
public class DefaultJnlpDependencyRequestConsumer
extends AbstractLogEnabled
implements JnlpDependencyRequestConsumer {
    @Requirement
    private IOUtil ioUtil;

    @Override
    public JnlpDependencyResults execute(JnlpDependencyRequestConsumerConfig config, JnlpDependencyRequests requests) {
        this.getLogger().info("Process " + requests.getNbRequests() + " dependencies.");
        RequestExecutor executor = new RequestExecutor(this.getLogger(), this.ioUtil, config);
        executor.registerRequests(requests.getRequests());
        JnlpDependencyResults results = executor.terminatesAndWaits();
        return results;
    }

    private static class RequestTask
    implements Runnable {
        private final Logger logger;
        private final IOUtil ioUtil;
        private final JnlpDependencyRequest request;
        private JnlpDependencyResult result;

        private RequestTask(Logger logger, IOUtil ioUtil, JnlpDependencyRequest request) {
            this.logger = logger;
            this.ioUtil = ioUtil;
            this.request = request;
            this.result = new JnlpDependencyResult(request);
        }

        @Override
        public void run() {
            JnlpDependencyConfig config = this.request.getConfig();
            File workingFile = this.request.getOriginalFile();
            try {
                this.ioUtil.copyFile(config.getArtifact().getFile(), workingFile);
                File workingDirectory = config.getWorkingDirectory();
                JnlpDependencyTask[] tasks = this.request.getTasks();
                int length = tasks.length;
                for (int i = 0; i < length; ++i) {
                    JnlpDependencyTask task = tasks[i];
                    File newDirectory = new File(workingDirectory, i + "_" + task.getClass().getSimpleName());
                    this.ioUtil.copyFileToDirectoryIfNecessary(workingFile, newDirectory);
                    workingFile = new File(newDirectory, workingFile.getName());
                    this.logger.debug(String.format("[task %s] (%s): workingFile: %s", i, task, workingFile));
                    workingFile = task.execute(config, workingFile);
                }
                this.ioUtil.copyFile(workingFile, this.request.getFinalFile());
            }
            catch (Exception e) {
                this.result.setError(e);
            }
            this.logger.info("Dependency " + config.getArtifact().getId() + " treated.");
        }
    }

    private static class RequestExecutor
    extends ThreadPoolExecutor {
        private final JnlpDependencyRequestConsumerConfig config;
        private final Logger logger;
        private final IOUtil ioUtil;
        private final JnlpDependencyResults results;

        public RequestExecutor(Logger logger, IOUtil ioUtil, JnlpDependencyRequestConsumerConfig config) {
            super(config.getMaxThreads(), config.getMaxThreads(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
            this.logger = logger;
            this.ioUtil = ioUtil;
            this.config = config;
            this.results = new JnlpDependencyResults();
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            boolean withError;
            super.afterExecute(r, t);
            RequestTask task = (RequestTask)r;
            JnlpDependencyResult result = task.result;
            this.results.registerResult(task.request, result);
            boolean bl = withError = t != null;
            if (withError) {
                result.setError(t);
                if (this.config.isFailFast()) {
                    this.logger.warn("Fail fast after first dependency processing error.");
                    this.shutdownNow();
                }
            }
        }

        public JnlpDependencyResults terminatesAndWaits() {
            this.shutdown();
            try {
                this.awaitTermination(172800L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.error("Could not stop the executor after two days...", (Throwable)e);
            }
            return this.results;
        }

        public void registerRequests(List<JnlpDependencyRequest> dependencyRequests) {
            for (JnlpDependencyRequest dependencyRequest : dependencyRequests) {
                RequestTask newtask = new RequestTask(this.logger, this.ioUtil, dependencyRequest);
                JnlpDependencyResult result = newtask.result;
                if (result.isUptodate()) {
                    if (this.config.isVerbose()) {
                        this.logger.info("Skip up-to-date dependency: " + dependencyRequest.getConfig().getArtifact().getId());
                    }
                    this.results.registerResult(newtask.request, result);
                    continue;
                }
                if (this.config.isVerbose()) {
                    this.logger.info("Process dependency: " + dependencyRequest.getConfig().getArtifact().getId());
                }
                this.execute(newtask);
            }
        }
    }
}

