/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart;

import com.anahata.webstart.AbstractBaseJnlpMojo;
import com.anahata.webstart.JarResource;
import com.anahata.webstart.JnlpFile;
import com.anahata.webstart.ResolvedJarResource;
import com.anahata.webstart.ResolvedJnlpFile;
import com.anahata.webstart.dependency.filenaming.UniqueSnapshotVersionUtils;
import com.anahata.webstart.generator.GeneratorTechnicalConfig;
import com.anahata.webstart.generator.JarResourceGeneratorConfig;
import com.anahata.webstart.generator.JarResourcesGenerator;
import com.anahata.webstart.generator.VersionXmlGenerator;
import com.anahata.webstart.util.ArtifactUtil;
import com.anahata.webstart.util.IOUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.InversionArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="jnlp-download-servlet", requiresProject=true, inheritByDefault=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JnlpDownloadServletMojo
extends AbstractBaseJnlpMojo {
    private static final String BUILT_IN_SERVLET_TEMPLATE_FILENAME = "default-jnlp-servlet-template.vm";
    private static final String SERVLET_TEMPLATE_FILENAME = "servlet-template.vm";
    @Parameter(property="jnlp.outputDirectoryName", defaultValue="webstart")
    private String outputDirectoryName;
    @Parameter(required=true)
    private List<JnlpFile> jnlpFiles;
    @Parameter
    private List<JarResource> commonJarResources;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkConfiguration();
        IOUtil ioUtil = this.getIoUtil();
        ioUtil.makeDirectoryIfNecessary(this.getWorkDirectory());
        ioUtil.copyResources(this.getResourcesDirectory(), this.getWorkDirectory());
        this.getLog().info((CharSequence)"-- Prepare commons jar resources");
        Set<Object> resolvedCommonJarResources = CollectionUtils.isEmpty(this.commonJarResources) ? Collections.emptySet() : this.resolveJarResources(this.commonJarResources, null);
        LinkedHashSet<ResolvedJarResource> allResolvedJarResources = new LinkedHashSet<ResolvedJarResource>();
        allResolvedJarResources.addAll(resolvedCommonJarResources);
        this.getLog().info((CharSequence)("-- Prepare jnlp files allResolvedJarResources before we start: " + allResolvedJarResources.size()));
        this.getLog().info((CharSequence)"-- Prepare jnlp files");
        LinkedHashSet<ResolvedJnlpFile> resolvedJnlpFiles = new LinkedHashSet<ResolvedJnlpFile>();
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            this.verboseLog("prepare jnlp " + jnlpFile);
            Set<ResolvedJarResource> resolvedJarResources = this.resolveJarResources(jnlpFile.getJarResources(), resolvedCommonJarResources);
            allResolvedJarResources.addAll(resolvedJarResources);
            ResolvedJnlpFile resolvedJnlpFile = new ResolvedJnlpFile(jnlpFile, resolvedJarResources);
            resolvedJnlpFiles.add(resolvedJnlpFile);
        }
        this.signOrRenameJars();
        for (ResolvedJnlpFile resolvedJnlpFile : resolvedJnlpFiles) {
            this.generateJnlpFile(resolvedJnlpFile, this.getLibPath());
        }
        File outputDir = new File(this.getProject().getBuild().getDirectory(), this.getProject().getBuild().getFinalName() + File.separator + this.outputDirectoryName);
        ioUtil.copyDirectoryStructure(this.getWorkDirectory(), outputDir);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    private void checkConfiguration() throws MojoExecutionException {
        this.checkDependencyFilenameStrategy();
        if (CollectionUtils.isEmpty(this.jnlpFiles)) {
            throw new MojoExecutionException("Configuration error: At least one <jnlpFile> element must be specified");
        }
        if (this.jnlpFiles.size() == 1 && StringUtils.isEmpty((String)this.jnlpFiles.get(0).getOutputFilename())) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified in single set of jnlpFiles. Using default output file name: launch.jnlp.");
            this.jnlpFiles.get(0).setOutputFilename("launch.jnlp");
        }
        LinkedHashSet<String> filenames = new LinkedHashSet<String>(this.jnlpFiles.size());
        for (JnlpFile jnlpFile : this.jnlpFiles) {
            if (!filenames.add(jnlpFile.getOutputFilename())) {
                throw new MojoExecutionException("Configuration error: Unique JNLP filenames must be provided. The following file name appears more than once [" + jnlpFile.getOutputFilename() + "].");
            }
            this.checkJnlpFileConfiguration(jnlpFile);
        }
        if (CollectionUtils.isNotEmpty(this.commonJarResources)) {
            for (JarResource jarResource : this.commonJarResources) {
                this.checkMandatoryJarResourceFields(jarResource);
                if (jarResource.getMainClass() == null) continue;
                throw new MojoExecutionException("Configuration Error: A mainClass must not be specified on a JarResource in the commonJarResources collection.");
            }
            for (JnlpFile jnlpFile : this.jnlpFiles) {
                for (JarResource jarResource : jnlpFile.getJarResources()) {
                    if (!this.commonJarResources.contains(jarResource)) continue;
                    String message = "Configuration Error: The jar resource element for artifact " + jarResource + " defined in common jar resources is duplicated in the jar " + "resources configuration of the jnlp file identified by the template file " + jnlpFile.getInputTemplate() + ".";
                    throw new MojoExecutionException(message);
                }
            }
        }
    }

    private void checkJnlpFileConfiguration(JnlpFile jnlpFile) throws MojoExecutionException {
        List<JarResource> jnlpJarResources;
        if (StringUtils.isBlank((String)jnlpFile.getOutputFilename())) {
            throw new MojoExecutionException("Configuration error: An outputFilename must be specified for each jnlpFile element");
        }
        if (StringUtils.isNotBlank((String)jnlpFile.getTemplateFilename())) {
            this.getLog().warn((CharSequence)"jnlpFile.templateFilename is deprecated (since 1.0-beta-5), use now the jnlpFile.inputTemplate instead.");
            jnlpFile.setInputTemplate(jnlpFile.getTemplateFilename());
        }
        if (CollectionUtils.isEmpty(jnlpJarResources = jnlpFile.getJarResources())) {
            throw new MojoExecutionException("Configuration error: A non-empty <jarResources> element must be specified in the plugin configuration for the JNLP file named [" + jnlpFile.getOutputFilename() + "]");
        }
        JarResource mainJarResource = null;
        JarResource progressJarResource = null;
        for (JarResource jarResource : jnlpJarResources) {
            this.checkMandatoryJarResourceFields(jarResource);
            if (jarResource.getMainClass() != null) {
                if (mainJarResource != null) {
                    throw new MojoExecutionException("Configuration error: More than one <jarResource> element has been declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
                }
                jnlpFile.setMainClass(jarResource.getMainClass());
                mainJarResource = jarResource;
            }
            if (jarResource.getProgressClass() == null) continue;
            if (progressJarResource != null) {
                throw new MojoExecutionException("Configuration error: More than one <jarResource> element has been declared with a <progressClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
            }
            jnlpFile.setProgressClass(jarResource.getProgressClass());
            progressJarResource = jarResource;
        }
        if (mainJarResource == null) {
            throw new MojoExecutionException("Configuration error: Exactly one <jarResource> element must be declared with a <mainClass> element in the configuration for JNLP file [" + jnlpFile.getOutputFilename() + "]");
        }
    }

    private void checkMandatoryJarResourceFields(JarResource jarResource) throws MojoExecutionException {
        if (!jarResource.isMandatoryField()) {
            throw new MojoExecutionException("Configuration error: groupId, artifactId or version missing for jarResource[" + jarResource + "].");
        }
    }

    private Set<ResolvedJarResource> resolveJarResources(Collection<JarResource> configuredJarResources, Set<ResolvedJarResource> commonJarResources) throws MojoExecutionException {
        Object artifact;
        LinkedHashSet<ResolvedJarResource> collectedJarResources = new LinkedHashSet<ResolvedJarResource>();
        if (commonJarResources != null) {
            collectedJarResources.addAll(commonJarResources);
        }
        ArtifactUtil artifactUtil = this.getArtifactUtil();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        LinkedHashSet<MavenProject> siblingProjects = new LinkedHashSet<MavenProject>();
        for (JarResource jarResource : configuredJarResources) {
            artifact = artifactUtil.createArtifact(jarResource);
            MavenProject siblingProject = artifactUtil.resolveFromReactor((Artifact)artifact, this.getProject(), this.reactorProjects);
            this.getLog().info((CharSequence)("Procesisng jarResource \n\t" + jarResource.toString() + "\n\tSiblingProject=" + siblingProject));
            if (siblingProject == null) {
                artifactUtil.resolveFromRepositories((Artifact)artifact, this.getRemoteRepositories(), this.getLocalRepository());
                artifacts.add((Artifact)artifact);
            } else {
                artifact = siblingProject.getArtifact();
                siblingProjects.add(siblingProject);
                artifacts.add((Artifact)artifact);
                artifact.setResolved(true);
            }
            if (StringUtils.isNotBlank((String)jarResource.getMainClass())) {
                if (artifact == null) {
                    throw new IllegalStateException("Implementation Error: The given jarResource cannot be checked for a main class until the underlying artifact has been resolved: [" + jarResource + "]");
                }
                boolean containsMainClass = artifactUtil.artifactContainsClass((Artifact)artifact, jarResource.getMainClass());
                if (!containsMainClass) {
                    throw new MojoExecutionException("The jar specified by the following jarResource does not contain the declared main class:" + jarResource);
                }
            }
            ResolvedJarResource resolvedJarResource = new ResolvedJarResource(jarResource, (Artifact)artifact);
            this.getLog().info((CharSequence)(" Add jarResource (configured): " + jarResource));
            collectedJarResources.add(resolvedJarResource);
        }
        if (!this.isExcludeTransitive()) {
            AndArtifactFilter artifactFilter = new AndArtifactFilter();
            artifactFilter.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
            artifactFilter.add((ArtifactFilter)new InversionArtifactFilter((ArtifactFilter)new TypeArtifactFilter("pom")));
            Set<Artifact> set = this.getArtifactUtil().resolveTransitively(artifacts, siblingProjects, this.getProject().getArtifact(), this.getLocalRepository(), this.getRemoteRepositories(), (ArtifactFilter)artifactFilter, this.getProject().getManagedVersionMap());
            for (Artifact resolvedArtifact : set) {
                ResolvedJarResource newJarResource = new ResolvedJarResource(resolvedArtifact);
                if (collectedJarResources.contains(newJarResource)) continue;
                this.getLog().info((CharSequence)("Add jarResource (transitive): " + newJarResource));
                collectedJarResources.add(newJarResource);
            }
        }
        for (ResolvedJarResource resolvedJarResource : collectedJarResources) {
            artifact = resolvedJarResource.getArtifact();
            String filenameWithVersion = this.getDependencyFilenameStrategy().getDependencyFilename((Artifact)artifact, true, this.isUseUniqueVersions());
            try {
                this.getLog().info((CharSequence)("Copyingfile to lib directory filenameWithVersion " + filenameWithVersion + "\t\n artifact " + artifact.toString() + "\t\n artifact version" + artifact.getVersion() + "\t\n artifact baseVersion" + artifact.getBaseVersion() + "\t\n artifact selectedVersion" + artifact.getSelectedVersion() + "\t\n artifact metadataList" + artifact.getMetadataList() + "\t\n uniqueVersions() " + this.isUseUniqueVersions()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean copied = this.copyJarAsUnprocessedToDirectoryIfNecessary(artifact.getFile(), this.getLibDirectory(), filenameWithVersion);
            if (copied) {
                String name = artifact.getFile().getName();
                this.verboseLog("Adding " + name + " to modifiedJnlpArtifacts list.");
                this.getModifiedJnlpArtifacts().add(name.substring(0, name.lastIndexOf(46)));
            }
            this.getLog().info((CharSequence)("preparing fileName for \t\n" + artifact.toString() + "\t\n jarResource.isOutputJarVersion() " + resolvedJarResource.isOutputJarVersion() + "\t\n uniqueVersions() " + this.isUseUniqueVersions()));
            String filename = this.getDependencyFilenameStrategy().getDependencyFilename((Artifact)artifact, null, false);
            this.getLog().info((CharSequence)("hrefValue = " + filename + " useUniqueV " + this.isUseUniqueVersions()));
            resolvedJarResource.setHrefValue(filename);
            if (!this.isUseUniqueVersions()) continue;
            String uniqueVer = UniqueSnapshotVersionUtils.getUniqueVersion((Artifact)artifact);
            resolvedJarResource.setVersion(uniqueVer);
        }
        return collectedJarResources;
    }

    private void generateJnlpFile(ResolvedJnlpFile jnlpFile, String libPath) throws MojoExecutionException {
        File templateFile;
        File templateDirectory;
        File jnlpOutputFile = new File(this.getWorkDirectory(), jnlpFile.getOutputFilename());
        Set<ResolvedJarResource> jarResources = jnlpFile.getJarResources();
        if (StringUtils.isNotBlank((String)jnlpFile.getInputTemplateResourcePath())) {
            templateDirectory = new File(jnlpFile.getInputTemplateResourcePath());
            this.getLog().debug((CharSequence)("Use jnlp directory : " + templateDirectory));
        } else {
            templateDirectory = this.getTemplateDirectory();
            this.getLog().debug((CharSequence)("Use default template directory : " + templateDirectory));
        }
        if (StringUtils.isBlank((String)jnlpFile.getInputTemplate())) {
            this.getLog().debug((CharSequence)"Jnlp servlet template file name not specified. Checking if default output file name exists: servlet-template.vm");
            templateFile = new File(templateDirectory, SERVLET_TEMPLATE_FILENAME);
            if (templateFile.isFile()) {
                jnlpFile.setInputTemplate(SERVLET_TEMPLATE_FILENAME);
            } else {
                this.getLog().debug((CharSequence)"Jnlp servlet template file not found in default location. Using inbuilt one.");
            }
        } else {
            templateFile = new File(templateDirectory, jnlpFile.getInputTemplate());
            if (!templateFile.isFile()) {
                throw new MojoExecutionException("The specified JNLP servlet template does not exist: [" + templateFile + "]");
            }
        }
        String templateFileName = jnlpFile.getInputTemplate();
        GeneratorTechnicalConfig generatorTechnicalConfig = new GeneratorTechnicalConfig(this.getProject(), templateDirectory, BUILT_IN_SERVLET_TEMPLATE_FILENAME, jnlpOutputFile, templateFileName, jnlpFile.getMainClass(), jnlpFile.getProgressClass(), this.getWebstartJarURLForVelocity(), this.getEncoding());
        JarResourceGeneratorConfig jarResourceGeneratorConfig = new JarResourceGeneratorConfig(jarResources, libPath, this.getCodebase(), jnlpFile.getProperties());
        JarResourcesGenerator jnlpGenerator = new JarResourcesGenerator(this.getLog(), generatorTechnicalConfig, jarResourceGeneratorConfig);
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("The following error occurred attempting to generate the JNLP deployment descriptor: " + e, e);
        }
    }

    private void generateVersionXml(Set<ResolvedJarResource> jarResources) throws MojoExecutionException {
        VersionXmlGenerator generator = new VersionXmlGenerator(this.getEncoding());
        generator.generate(this.getLibDirectory(), jarResources);
    }
}

