/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.webstart;

import com.anahata.webstart.JnlpFileType;
import com.anahata.webstart.dependency.filenaming.DependencyFilenameStrategy;
import com.anahata.webstart.pack200.Pack200Config;
import com.anahata.webstart.pack200.Pack200Tool;
import com.anahata.webstart.sign.ConcurrentJarSigner;
import com.anahata.webstart.sign.SignConfig;
import com.anahata.webstart.sign.SignTool;
import com.anahata.webstart.util.ArtifactUtil;
import com.anahata.webstart.util.IOUtil;
import com.anahata.webstart.util.JarUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractBaseJnlpMojo
extends AbstractMojo {
    private static final String DEFAULT_RESOURCES_DIR = "src/main/jnlp/resources";
    public static final String UNPROCESSED_PREFIX = "unprocessed_";
    public static final String JAR_SUFFIX = ".jar";
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="jnlp.workDirectory", defaultValue="${project.build.directory}/jnlp", required=true)
    private File workDirectory;
    @Parameter(property="jnlp.libPath", defaultValue="")
    protected String libPath;
    @Parameter(property="jnlp.resourcesDirectory")
    private File resourcesDirectory;
    @Parameter(property="jnlp.templateDirectory", defaultValue="${project.basedir}/src/main/jnlp", required=true)
    private File templateDirectory;
    @Parameter
    private Pack200Config pack200;
    @Parameter
    private SignConfig sign;
    @Parameter(property="jnlp.gzip", defaultValue="false")
    private boolean gzip;
    @Parameter(property="webstart.verbose", alias="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="jnlp.excludeTransitive")
    private boolean excludeTransitive;
    @Parameter(property="jnlp.codebase", defaultValue="${project.url}/jnlp")
    private String codebase;
    @Parameter(property="jnlp.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="jnlp.unsign", alias="unsign", defaultValue="false")
    private boolean unsignAlreadySignedJars;
    @Parameter(property="jnlp.canUnsign", defaultValue="true")
    private boolean canUnsign;
    @Parameter
    private Map<String, String> updateManifestEntries;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List<?> compileClassPath;
    @Parameter(property="jnlp.filenameMapping", defaultValue="simple", required=true)
    private String filenameMapping;
    @Parameter(property="jnlp.useUniqueVersions", defaultValue="false")
    private boolean useUniqueVersions;
    @Component
    private SignTool signTool;
    @Component(role=Pack200Tool.class)
    private Pack200Tool pack200Tool;
    @Component
    private ArtifactUtil artifactUtil;
    @Component
    private IOUtil ioUtil;
    @Component(hint="default")
    private JarUtil jarUtil;
    @Component(role=DependencyFilenameStrategy.class)
    private Map<String, DependencyFilenameStrategy> dependencyFilenameStrategyMap;
    private final List<String> modifiedJnlpArtifacts = new ArrayList<String>();
    private final FileFilter unprocessedJarFileFilter;
    private final FileFilter processedJarFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(AbstractBaseJnlpMojo.JAR_SUFFIX) && !pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX);
        }
    };
    private final FileFilter unprocessedPack200FileFilter;
    private DependencyFilenameStrategy dependencyFilenameStrategy;

    public AbstractBaseJnlpMojo() {
        this.unprocessedJarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && pathname.getName().endsWith(AbstractBaseJnlpMojo.JAR_SUFFIX);
            }
        };
        this.unprocessedPack200FileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(AbstractBaseJnlpMojo.UNPROCESSED_PREFIX) && (pathname.getName().endsWith(".jar.pack.gz") || pathname.getName().endsWith(".jar.pack"));
            }
        };
    }

    public abstract MavenProject getProject();

    public String getLibPath() {
        if (StringUtils.isBlank((String)this.libPath)) {
            return null;
        }
        return this.libPath;
    }

    public boolean isPack200() {
        return this.pack200 != null && this.pack200.isEnabled();
    }

    public List<String> getPack200PassFiles() {
        return this.pack200 == null ? null : this.pack200.getPassFiles();
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected File getLibDirectory() {
        if (this.getLibPath() != null) {
            return new File(this.getWorkDirectory(), this.getLibPath());
        }
        return this.getWorkDirectory();
    }

    protected File getResourcesDirectory() {
        if (this.resourcesDirectory == null) {
            this.resourcesDirectory = new File(this.getProject().getBasedir(), DEFAULT_RESOURCES_DIR);
        }
        return this.resourcesDirectory;
    }

    protected File getTemplateDirectory() {
        return this.templateDirectory;
    }

    protected ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    protected SignConfig getSign() {
        return this.sign;
    }

    protected String getCodebase() {
        return this.codebase;
    }

    protected boolean isGzip() {
        return this.gzip;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    protected List<String> getModifiedJnlpArtifacts() {
        return this.modifiedJnlpArtifacts;
    }

    protected String getEncoding() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = "utf-8";
            this.getLog().warn((CharSequence)("No encoding defined, will use the default one : " + this.encoding));
        }
        return this.encoding;
    }

    protected DependencyFilenameStrategy getDependencyFilenameStrategy() {
        if (this.dependencyFilenameStrategy == null) {
            this.dependencyFilenameStrategy = this.dependencyFilenameStrategyMap.get(this.filenameMapping);
        }
        return this.dependencyFilenameStrategy;
    }

    protected boolean isUseUniqueVersions() {
        return this.useUniqueVersions;
    }

    protected void checkDependencyFilenameStrategy() throws MojoExecutionException {
        if (this.getDependencyFilenameStrategy() == null) {
            this.dependencyFilenameStrategy = this.dependencyFilenameStrategyMap.get(this.filenameMapping);
            if (this.dependencyFilenameStrategy == null) {
                throw new MojoExecutionException("Could not find filenameMapping named '" + this.filenameMapping + "', use one of the following one: " + this.dependencyFilenameStrategyMap.keySet());
            }
        }
    }

    protected boolean copyJarAsUnprocessedToDirectoryIfNecessary(File sourceFile, File targetDirectory, String targetFilename) throws MojoExecutionException {
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile is null");
        }
        if (targetFilename == null) {
            targetFilename = sourceFile.getName();
        }
        File signedTargetFile = new File(targetDirectory, targetFilename);
        File unsignedTargetFile = this.toUnprocessFile(targetDirectory, targetFilename);
        File packedTargetFile = new File(targetDirectory, targetFilename + ".pack.gz");
        this.getLog().info((CharSequence)("Source file " + sourceFile + " " + new Date(sourceFile.lastModified())));
        this.getLog().info((CharSequence)("packedTargetFile " + packedTargetFile + " " + new Date(packedTargetFile.lastModified())));
        boolean shouldCopy = !signedTargetFile.exists() || signedTargetFile.lastModified() < sourceFile.lastModified();
        shouldCopy &= !unsignedTargetFile.exists() || unsignedTargetFile.lastModified() < sourceFile.lastModified();
        if (shouldCopy &= !packedTargetFile.exists() || packedTargetFile.lastModified() < sourceFile.lastModified()) {
            this.getIoUtil().copyFile(sourceFile, unsignedTargetFile);
        } else {
            this.getLog().info((CharSequence)("Source file hasn't changed. Do not reprocess " + packedTargetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    protected void signOrRenameJars() throws MojoExecutionException {
        if (this.sign != null) {
            int signedJars;
            try {
                ClassLoader loader = this.getCompileClassLoader();
                this.sign.init(this.getWorkDirectory(), this.getLog().isDebugEnabled(), this.signTool, loader);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Could not create classloader", (Exception)e);
            }
            if (this.unsignAlreadySignedJars) {
                this.removeExistingSignatures(this.getLibDirectory());
            }
            if (this.isPack200()) {
                this.unpackJars(this.getLibDirectory());
                this.ioUtil.deleteFiles(this.getLibDirectory(), this.unprocessedPack200FileFilter);
            }
            if (MapUtils.isNotEmpty(this.updateManifestEntries)) {
                this.updateManifestEntries(this.getLibDirectory());
            }
            if ((signedJars = this.signJars(this.getLibDirectory())) != this.getModifiedJnlpArtifacts().size()) {
                throw new IllegalStateException("The number of signed artifacts (" + signedJars + ") differ from the number of modified " + "artifacts (" + this.getModifiedJnlpArtifacts().size() + "). Implementation error");
            }
        } else {
            this.makeUnprocessedFilesFinal(this.getLibDirectory());
        }
        if (this.isPack200()) {
            this.verboseLog("-- Pack jars");
            this.pack200Jars(this.getLibDirectory(), this.processedJarFileFilter);
        }
        this.getLog().info((CharSequence)"deleting processedJarFiles and leaving pack200 jars only");
        this.ioUtil.deleteFiles(this.getLibDirectory(), this.processedJarFileFilter);
    }

    protected void pack200Jars(File directory, FileFilter filter) throws MojoExecutionException {
        try {
            this.getPack200Tool().packJars(directory, filter, this.isGzip(), this.getPack200PassFiles());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not pack200 jars: ", (Exception)e);
        }
    }

    protected URL findDefaultTemplateURL(JnlpFileType fileType) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource(fileType.getDefaultTemplateName());
    }

    protected String getWebstartJarURLForVelocity() {
        String url = this.findDefaultTemplateURL(JnlpFileType.application).toString();
        return url.substring(0, url.indexOf("!") + 2);
    }

    protected boolean isJarSigned(File jarFile) throws MojoExecutionException {
        return this.signTool.isJarSigned(jarFile);
    }

    protected ArtifactUtil getArtifactUtil() {
        return this.artifactUtil;
    }

    protected IOUtil getIoUtil() {
        return this.ioUtil;
    }

    protected JarUtil getJarUtil() {
        return this.jarUtil;
    }

    protected Pack200Tool getPack200Tool() {
        return this.pack200Tool;
    }

    protected void verboseLog(String msg) {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)msg);
        } else {
            this.getLog().debug((CharSequence)msg);
        }
    }

    private void unpackJars(File directory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"-- Unpack jars before sign operation ");
        this.verboseLog("see http://docs.oracle.com/javase/7/docs/technotes/guides/deployment/deployment-guide/pack200.html");
        this.pack200Jars(directory, this.unprocessedJarFileFilter);
        try {
            this.getPack200Tool().unpackJars(directory, this.unprocessedPack200FileFilter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not unpack200 jars: ", (Exception)e);
        }
    }

    private int makeUnprocessedFilesFinal(File directory) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(this.unprocessedJarFileFilter);
        this.getLog().debug((CharSequence)("makeUnprocessedFilesFinal in " + directory + " found " + jarFiles.length + " file(s) to rename"));
        if (jarFiles.length == 0) {
            return 0;
        }
        for (File unprocessedJarFile : jarFiles) {
            File finalJar = this.toProcessFile(unprocessedJarFile);
            this.ioUtil.deleteFile(finalJar);
            this.ioUtil.renameTo(unprocessedJarFile, finalJar);
        }
        return jarFiles.length;
    }

    private void updateManifestEntries(File directory) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(this.unprocessedJarFileFilter);
        this.getLog().info((CharSequence)"-- Update manifest entries");
        this.getLog().debug((CharSequence)("updateManifestEntries in " + directory + " found " + jarFiles.length + " jar(s) to treat"));
        if (jarFiles.length == 0) {
            return;
        }
        for (File unprocessedJarFile : jarFiles) {
            this.verboseLog("Update manifest " + this.toProcessFile(unprocessedJarFile).getName());
            this.jarUtil.updateManifestEntries(unprocessedJarFile, this.updateManifestEntries);
            this.jarUtil.deleteFile(unprocessedJarFile, "/META-INF/INDEX.LIST");
        }
    }

    private int signJars(File directory) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(this.unprocessedJarFileFilter);
        this.getLog().info((CharSequence)"-- Sign jars");
        this.getLog().debug((CharSequence)("signJars in " + directory + " found " + jarFiles.length + " jar(s) to sign"));
        if (jarFiles.length == 0) {
            return 0;
        }
        boolean signVerify = this.sign.isVerify();
        ConcurrentJarSigner jarSigner = new ConcurrentJarSigner(this.sign.getThreads());
        jarSigner.execute(jarFiles, this.ioUtil, this.signTool, this.sign, this.getLog(), signVerify);
        return jarFiles.length;
    }

    private int removeExistingSignatures(File workDirectory) throws MojoExecutionException {
        File[] jarFiles;
        this.getLog().info((CharSequence)"-- Remove existing signatures");
        File tempDir = new File(workDirectory, "temp_extracted_jars");
        this.ioUtil.removeDirectory(tempDir);
        this.ioUtil.makeDirectoryIfNecessary(tempDir);
        for (File jarFile : jarFiles = workDirectory.listFiles(this.unprocessedJarFileFilter)) {
            if (this.isJarSigned(jarFile)) {
                if (!this.canUnsign) {
                    throw new MojoExecutionException("neverUnsignAlreadySignedJar is set to true and a jar file [" + jarFile + " was asked to be unsign,\n please prefer use in this case an extension for " + "signed jars or not set to true the neverUnsignAlreadySignedJar parameter, Make " + "your choice:)");
                }
                this.verboseLog("Remove signature " + this.toProcessFile(jarFile).getName());
                this.signTool.unsign(jarFile, this.isVerbose());
                continue;
            }
            this.verboseLog("Skip not signed " + this.toProcessFile(jarFile).getName());
        }
        this.ioUtil.removeDirectory(tempDir);
        return jarFiles.length;
    }

    private ClassLoader getCompileClassLoader() throws MalformedURLException {
        URL[] urls = new URL[this.compileClassPath.size()];
        for (int i = 0; i < urls.length; ++i) {
            URL url;
            String spec = this.compileClassPath.get(i).toString();
            urls[i] = url = new File(spec).toURI().toURL();
        }
        return new URLClassLoader(urls);
    }

    private File toUnprocessFile(File targetDirectory, String sourceName) {
        if (sourceName.startsWith(UNPROCESSED_PREFIX)) {
            throw new IllegalStateException(sourceName + " does start with " + UNPROCESSED_PREFIX);
        }
        String targetFilename = UNPROCESSED_PREFIX + sourceName;
        return new File(targetDirectory, targetFilename);
    }

    private File toProcessFile(File source) {
        if (!source.getName().startsWith(UNPROCESSED_PREFIX)) {
            throw new IllegalStateException(source.getName() + " does not start with " + UNPROCESSED_PREFIX);
        }
        String targetFilename = source.getName().substring(UNPROCESSED_PREFIX.length());
        return new File(source.getParentFile(), targetFilename);
    }
}

