/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.xml;

import es.pablo.util.Util;
import java.io.File;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.jar.Attributes;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlTableParser
extends DefaultHandler {
    private final String TABLE = "table";
    private final String TD = "td";
    private final String TR = "tr";
    ArrayList<ArrayList> rows = new ArrayList();
    ArrayList row = new ArrayList();
    Object cell = "";
    static NumberFormat nf = new DecimalFormat("0.00");

    private HtmlTableParser() {
    }

    public static ArrayList parse(File f) throws Exception {
        String s = Util.getFileAsString(f);
        return HtmlTableParser.parse(s);
    }

    public static ArrayList parse(String s) throws Exception {
        String header = "";
        if (s.indexOf("<?xml") == -1) {
            header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><!DOCTYPE table [<!ENTITY nbsp \"&#160;\">]>" + s;
        }
        s = s.replace("border=\"1\" id style", "border=\"1\" style");
        s = s.replace("&nbsp;", " ");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser saxParser = factory.newSAXParser();
        HtmlTableParser handler = new HtmlTableParser();
        saxParser.parse(new InputSource(new StringReader(s)), (DefaultHandler)handler);
        handler.dump();
        return handler.rows;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("table".equals(qName)) {
            this.rows = new ArrayList();
        }
        if ("tr".equals(qName)) {
            this.row = new ArrayList();
        }
        if ("td".equals(qName)) {
            this.cell = "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String strValue = new String(ch, start, length).trim();
        float floatValue = 0.0f;
        try {
            floatValue = NumberFormat.getCurrencyInstance(new Locale("es", "ES")).parse(strValue).floatValue();
            this.cell = Float.valueOf(floatValue);
        }
        catch (Exception e) {
            this.cell = strValue;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("tr".equalsIgnoreCase(qName)) {
            this.rows.add(this.row);
            this.row = new ArrayList();
        }
        if ("td".equalsIgnoreCase(qName)) {
            this.row.add(this.cell);
        }
    }

    public void dump() {
        for (ArrayList arrayList : this.rows) {
        }
    }

    public static void main(String[] s) throws Exception {
        DecimalFormat nf = new DecimalFormat("0.00");
    }
}

