/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.util.thread;

import es.pablo.util.thread.Queue;
import es.pablo.util.thread.TaskWrapper;

public class ThreadPool {
    public static ThreadPool currentThreadPool = null;
    public Queue queue = new Queue();

    public ThreadPool(int threads) {
        for (int i = 0; i < threads; ++i) {
            Thread t = new Thread((Runnable)new WorkerThread(), "WorkerThread: " + (i + 1));
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask(Runnable task) {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.enqueue(task);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueEmpty() {
        Queue queue = this.queue;
        synchronized (queue) {
            return this.queue.isEmpty();
        }
    }

    public static void invokeLater(ThreadPool thp, Runnable task) {
        thp.doTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(ThreadPool thp, Runnable task) {
        TaskWrapper tw = new TaskWrapper(task);
        Runnable runnable = tw.task;
        synchronized (runnable) {
            try {
                thp.doTask(tw);
                tw.task.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tw = null;
        }
    }

    public static void invokeLater(Runnable task) {
        if (currentThreadPool == null) {
            currentThreadPool = new ThreadPool(20);
        }
        currentThreadPool.doTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable task) {
        if (currentThreadPool == null) {
            currentThreadPool = new ThreadPool(20);
        }
        TaskWrapper tw = new TaskWrapper(task);
        Runnable runnable = tw.task;
        synchronized (runnable) {
            try {
                currentThreadPool.doTask(tw);
                tw.task.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tw = null;
        }
    }

    private class WorkerThread
    implements Runnable {
        private WorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable task = null;
                Queue queue = ThreadPool.this.queue;
                synchronized (queue) {
                    try {
                        if (ThreadPool.this.queue.isEmpty()) {
                            ThreadPool.this.queue.wait();
                        } else {
                            task = (Runnable)ThreadPool.this.queue.dequeue();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (task == null) continue;
                task.run();
            }
        }
    }
}

