/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.util.thread;

import es.pablo.util.thread.FIFOQueueEnumerator;
import es.pablo.util.thread.LIFOQueueEnumerator;
import es.pablo.util.thread.QueueElement;
import java.util.Enumeration;

public class Queue {
    int length = 0;
    QueueElement head = null;
    QueueElement tail = null;

    public synchronized void enqueue(Object obj) {
        QueueElement newElt = new QueueElement(obj);
        if (this.head == null) {
            this.head = newElt;
            this.tail = newElt;
            this.length = 1;
        } else {
            newElt.next = this.head;
            this.head.prev = newElt;
            this.head = newElt;
            ++this.length;
        }
    }

    public synchronized Object dequeue() {
        QueueElement elt = this.tail;
        this.tail = elt.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        --this.length;
        return elt.obj;
    }

    public synchronized boolean isEmpty() {
        return this.tail == null;
    }

    public final synchronized Enumeration elements() {
        return new LIFOQueueEnumerator(this);
    }

    public final synchronized Enumeration reverseElements() {
        return new FIFOQueueEnumerator(this);
    }

    public synchronized void dump(String msg) {
        System.err.println(">> " + msg);
        System.err.println("[" + this.length + " elt(s); head = " + (this.head == null ? "null" : this.head.obj + "") + " tail = " + (this.tail == null ? "null" : this.tail.obj + ""));
        QueueElement cursor = this.head;
        QueueElement last = null;
        while (cursor != null) {
            System.err.println("  " + cursor);
            last = cursor;
            cursor = cursor.next;
        }
        if (last != this.tail) {
            System.err.println("  tail != last: " + this.tail + ", " + last);
        }
        System.err.println("]");
    }
}

