/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.util;

import es.pablo.jee.ejb.exception.InvalidParameterException;
import es.pablo.jee.entity.ServerFile;
import es.pablo.util.ErrorDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingException;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Util {
    private static final String SMTP_AUTH_USER = "magefrigorbackup@gmail.com";
    private static final String SMTP_AUTH_PWD = "magefrigor";
    private static final String SMTP_HOST_NAME = "smtp.gmail.com";
    private static final int SMTP_HOST_PORT = 465;
    private static final String FOOTER = "\n\nMENSAJE GENERADO AUTOMATICAMENTE, POR FAVOR, NO RESPONDA A ESTE MENSAJE. \n\n ";
    public static final String[] LE = new String[]{"<td align=\"left\" colspan=\"2\"><a class=\"detallesText vinculo\" onclick=\"window.open('", "'"};
    public transient int b;
    static final Map<String, int[]> fileCache = Collections.synchronizedMap(new HashMap());
    static final Map<String, byte[]> fileCache2 = Collections.synchronizedMap(new HashMap());
    public static JDialog downloadMonitor;
    public static JLabel monitoredImage;

    public static String nn(Object o) {
        return o != null ? o.toString() : "";
    }

    public static Locale getAsLocale(String to) {
        if (to.contains("-")) {
            return new Locale(to.substring(0, 2), to.substring(3, 5));
        }
        return new Locale(to);
    }

    public static String quitaAzentos(String s) {
        return s.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n").replace("\u00c1", "A").replace("\u00c9", "E").replace("\u00cd", "I").replace("\u00d3", "O").replace("\u00da", "U").replace("\u00d1", "N").replace("\u20ac", "EUR");
    }

    public static String noHtml(String s, boolean lineSeparator) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("\\<.*?\\>", "");
        if (!lineSeparator) {
            s = s.replaceAll("\n", " ");
            s = s.replaceAll("\r", " ");
        }
        return s;
    }

    public static String collection2String(Collection col, boolean commas) {
        return Util.collection2String(col, commas, false);
    }

    public static String collection2String(Collection col, boolean commas, boolean quote) {
        StringBuffer sb = new StringBuffer();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (quote) {
                sb.append("'");
            }
            sb.append(it.next());
            if (quote) {
                sb.append("'");
            }
            if (!it.hasNext() || !commas) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static int countOccurences(String s, String pattern) {
        int i = s.indexOf(pattern, 0);
        int occ = 0;
        while (i != -1 && i < pattern.length()) {
            ++occ;
            i = s.indexOf(pattern, i + 1);
        }
        return occ;
    }

    public static String findString(String[] keys, String s) {
        int f;
        int i = s.indexOf(keys[0]);
        if (i != -1 && (f = s.indexOf(keys[1], i += keys[0].length())) != -1) {
            return s.substring(i, f).trim();
        }
        return null;
    }

    public static String makeMetaHeaders(String title, String desc, String keyWords) {
        return Util.makeMetaHeaders(title, desc, keyWords, null);
    }

    public static String makeSEKeys(String yahoo, String google, String msn) {
        return "<META content=\"" + yahoo + "\" name=\"y_key\"/><META content=\"" + google + "\" name=\"verify-v1\"/><META content=\"" + msn + "\" name=\"msvalidate.01\"/>";
    }

    public static String makeMetaHeaders(String title, String desc, String keyWords, String favIconUrl) {
        String s = "\n<meta name='Keywords' content='" + keyWords + "'/>\n<meta name='description' content='" + desc + "'/>\n<meta name='abstract' content='" + desc + "'/>";
        if (favIconUrl != null) {
            s = s + "<LINK HREF=\"" + favIconUrl + "\" REL=\"SHORTCUT ICON\"/>";
        }
        return s;
    }

    public static String preparaParaURL(String s) {
        s = s.toLowerCase().replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u").replace("\u00f1", "n");
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            if (Character.isLetterOrDigit(ca[i])) continue;
            ca[i] = 45;
        }
        return new String(ca);
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return Util.getWindowForComponent(parentComponent.getParent());
    }

    public static Object[] getImageAndFileFromClipBoard(int maxSize) throws Exception {
        List l;
        File f = null;
        ImageIcon ii = null;
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (l = (List)t.getTransferData(DataFlavor.javaFileListFlavor)).size() > 0) {
            f = (File)l.get(0);
        }
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            ii = f != null ? new ImageIcon(f.toURI().toURL()) : new ImageIcon((Image)t.getTransferData(DataFlavor.imageFlavor));
            if (maxSize != -1) {
                ii = new ImageIcon(Util.getScaledImage(ii, maxSize));
            }
            RenderedImage rendered = Util.getRenderedImage(ii);
            if (f == null) {
                f = new File("" + System.currentTimeMillis());
                f.deleteOnExit();
                ImageIO.write(rendered, "JPEG", f);
            }
        }
        return new Object[]{f, ii};
    }

    public static RenderedImage getRenderedImage(ImageIcon ii) {
        RenderedImage rendered = null;
        Image image = ii.getImage();
        if (image instanceof RenderedImage) {
            rendered = (RenderedImage)((Object)image);
        } else {
            BufferedImage buffered = new BufferedImage(ii.getIconWidth(), ii.getIconHeight(), 1);
            Graphics2D g = buffered.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            rendered = buffered;
        }
        return rendered;
    }

    public static Dimension getScaledDimension(int width, int height, int maxSize) {
        if (maxSize == -1) {
            return new Dimension(width, height);
        }
        int newWidth = width;
        int newHeight = height;
        if (width > maxSize && width >= height) {
            newWidth = maxSize;
            float factor = (float)maxSize / (float)width;
            newHeight = (int)((float)height * factor);
        } else if (height > maxSize) {
            newHeight = maxSize;
            float factor = (float)maxSize / (float)height;
            newWidth = (int)((float)width * factor);
        }
        if (newWidth == 0) {
            newWidth = 20;
        }
        if (newHeight == 0) {
            newHeight = 20;
        }
        return new Dimension(newWidth, newHeight);
    }

    public static float getScaledFactor(int width, int height, int maxSize) {
        if (maxSize == -1) {
            return 1.0f;
        }
        if (width > maxSize && width >= height) {
            float factor = (float)maxSize / (float)width;
            return factor;
        }
        if (height > maxSize) {
            float factor = (float)maxSize / (float)height;
            return factor;
        }
        return 1.0f;
    }

    public static Image getScaledImage(ImageIcon ii, int maxSize) {
        float factor;
        if (maxSize == -1) {
            return ii.getImage();
        }
        int width = ii.getImage().getWidth(ii.getImageObserver());
        int height = ii.getImage().getHeight(ii.getImageObserver());
        int newWidth = width;
        int newHeight = height;
        if (width > maxSize && width >= height) {
            newWidth = maxSize;
            factor = (float)maxSize / (float)width;
            newHeight = (int)((float)height * factor);
        } else if (height > maxSize) {
            newHeight = maxSize;
            factor = (float)maxSize / (float)height;
            newWidth = (int)((float)width * factor);
        }
        if (newWidth == 0) {
            newWidth = 20;
        }
        if (newHeight == 0) {
            newHeight = 20;
        }
        Image scaledImage = ii.getImage().getScaledInstance(newWidth, newHeight, 4);
        return scaledImage;
    }

    public static void writeToDisc(es.pablo.jee.entity.File f, ServerFile sf) throws Exception {
        File parent = new File(f.value());
        if (parent.exists() && !parent.isDirectory()) {
            throw new InvalidParameterException(parent + " no es un directorio");
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File master = new File(parent, sf.name);
        int duplId = 2;
        while (master.exists()) {
            sf.name = "(" + duplId++ + ")" + sf.name;
            master = new File(parent, sf.name);
        }
        Util.writeFile(master, sf.data);
        if (f.copies() != null) {
            for (String s : f.copies()) {
                parent = new File(s);
                if (parent.exists() && !parent.isDirectory()) {
                    throw new InvalidParameterException(parent + " no es un directorio");
                }
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                File file = new File(parent, sf.name);
                try {
                    Util.writeFile(file, sf.data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeFile(File f, int[] data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f), 4096);
        int idx = 0;
        while (idx < data.length) {
            bos.write(data[idx++]);
        }
        bos.close();
        fileCache.put(f.toString(), Arrays.copyOf(data, data.length));
    }

    public static void writeFile(File f, byte[] data) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f), 4096);
        int idx = 0;
        while (idx < data.length) {
            bos.write(data[idx++] & 0xFF);
        }
        bos.close();
        fileCache2.put(f.toString(), Arrays.copyOf(data, data.length));
    }

    public static ServerFile readFromDisc(es.pablo.jee.entity.File f, String name) throws Exception {
        File dir = new File(f.value());
        File file = new File(dir, name);
        return new ServerFile(file);
    }

    public static byte[] readFileToByteArr(File sourceFile) throws Exception {
        byte[] data = fileCache2.get(sourceFile.toString());
        if (data != null) {
            if (data.length > 0) {
                return Arrays.copyOf(data, data.length);
            }
            return null;
        }
        try {
            int theChar;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
            data = new byte[bis.available()];
            int idx = 0;
            while ((theChar = bis.read()) != -1) {
                data[idx++] = (byte)theChar;
            }
            bis.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            fileCache.put(sourceFile.toString(), new int[0]);
        }
        fileCache2.put(sourceFile.toString(), Arrays.copyOf(data, data.length));
        return data;
    }

    public static int[] readFile(File sourceFile) throws Exception {
        int[] data = fileCache.get(sourceFile.toString());
        if (data != null) {
            if (data.length > 0) {
                return Arrays.copyOf(data, data.length);
            }
            return null;
        }
        try {
            int theChar;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile), 4096);
            data = new int[bis.available()];
            int idx = 0;
            while ((theChar = bis.read()) != -1) {
                data[idx++] = theChar;
            }
            bis.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            fileCache.put(sourceFile.toString(), new int[0]);
        }
        fileCache.put(sourceFile.toString(), Arrays.copyOf(data, data.length));
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSetToFile(Set<String> s, File aFile) throws Exception {
        if (!aFile.exists()) {
            aFile.getParentFile().mkdirs();
            aFile.createNewFile();
        }
        String ls = System.getProperty("line.separator");
        try (BufferedWriter output = new BufferedWriter(new FileWriter(aFile));){
            for (String str : s) {
                output.write(str);
                output.write(ls);
            }
        }
        output.close();
    }

    public static Set<String> readSetFromFile(File aFile) throws Exception {
        HashSet<String> ret = new HashSet<String>();
        if (!aFile.exists()) {
            aFile.getParentFile().mkdirs();
            aFile.createNewFile();
            return ret;
        }
        String str = Util.getFileAsString(aFile);
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret;
    }

    public static File writeStringToFile(String s, String fileName) throws Exception {
        File f = new File(fileName);
        return Util.writeStringToFile(s, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeStringToFile(String s, File f) throws Exception {
        if (!f.exists()) {
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(f);
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                pw.println(st.nextToken());
            }
            File file = f;
            return file;
        }
    }

    public static String getFileAsString2(File aFile) throws Exception {
        StringBuffer fileData = new StringBuffer((int)aFile.length());
        BufferedReader reader = new BufferedReader(new FileReader(aFile));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public static String getFileAsString(File aFile) {
        return Util.getFileAsString(aFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(File aFile, String encoding) {
        if (aFile.length() > 4000000L) {
            return "";
        }
        StringBuffer contents = new StringBuffer(32);
        try {
            FileInputStream is = new FileInputStream(aFile);
            InputStreamReader isr = encoding != null ? new InputStreamReader((InputStream)is, encoding) : new InputStreamReader(is);
            try (BufferedReader input = new BufferedReader(isr);){
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            return contents.toString();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println("On file : " + aFile + " " + aFile.length());
            contents.toString();
            return "";
        }
    }

    public static String getStreamAsString(InputStream stream) {
        return Util.getStreamAsString(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String encoding) {
        StringBuffer contents = new StringBuffer(32);
        try {
            InputStreamReader isr = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            try (BufferedReader input = new BufferedReader(isr);){
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            return contents.toString();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println("On stream: " + stream);
            contents.toString();
            return "";
        }
    }

    public static int getNext(Set<String> set, String s, int idx0) {
        char c;
        int endIdx;
        if ((idx0 = s.indexOf("http://", idx0)) == -1) {
            return -1;
        }
        for (endIdx = idx0 + 7; endIdx != -1 && (Character.isLetterOrDigit(c = s.charAt(endIdx)) || c == '_' || c == '-' || c == '.' || c == '*'); ++endIdx) {
        }
        if (endIdx > idx0 + 7) {
            String url = s.substring(idx0, endIdx).trim();
            if (!url.startsWith("http://")) {
                url = "http://" + url;
            }
            set.add(url);
        }
        return endIdx;
    }

    public static Set getUrls(File dir, boolean recurse) {
        File[] files;
        HashSet<String> ret = new HashSet<String>();
        for (File f : files = dir.listFiles()) {
            if (!f.isDirectory()) {
                try {
                    String s = Util.getFileAsString(f);
                    Set<String> set = Util.getUrls(s);
                    ret.addAll(set);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!recurse) continue;
            ret.addAll(Util.getUrls(f, recurse));
        }
        return ret;
    }

    public static Set<String> getUrls(String s) {
        HashSet<String> set = new HashSet<String>();
        int idx = 0;
        while ((idx = Util.getNext(set, s, idx)) != -1) {
        }
        return set;
    }

    private static int getNextImage(Set<String> set, String s, int idx0) {
        if ((idx0 = s.indexOf("\"http://", idx0)) != -1) {
            String subs;
            String lc;
            int idx1 = s.indexOf("\"", idx0 + 1);
            if (idx1 != -1 && ((lc = (subs = s.substring(idx0 + 1, idx1)).toLowerCase()).endsWith("jpg") || lc.endsWith("jpeg") || lc.endsWith("gif") || lc.endsWith("png"))) {
                set.add(subs);
            }
            return idx1;
        }
        return -1;
    }

    private static int getNextImageBySrc(Set<String> set, String s, int idx0) {
        String key = "src=\"";
        if ((idx0 = s.indexOf("src=\"", idx0)) != -1) {
            String subs;
            String lc;
            int idx1 = s.indexOf("\"", idx0 + key.length());
            if (idx1 != -1 && ((lc = (subs = s.substring(idx0 + key.length(), idx1)).toLowerCase()).endsWith("jpg") || lc.endsWith("jpeg") || lc.endsWith("gif") || lc.endsWith("png"))) {
                set.add(subs);
            }
            return idx1;
        }
        return -1;
    }

    public static Set<String> getImagesBySrc(String s) {
        HashSet<String> set = new HashSet<String>();
        int idx = 0;
        while ((idx = Util.getNextImageBySrc(set, s, idx)) != -1) {
        }
        return set;
    }

    public static Set<String> getImages(String s) {
        HashSet<String> set = new HashSet<String>();
        int idx = 0;
        while ((idx = Util.getNextImage(set, s, idx)) != -1) {
        }
        return set;
    }

    public static List<File> getGoogleImagesFor(File downloadDir, String s, String urlFilter, List<String> exclude) throws Exception {
        boolean showedDownloadMonitor = false;
        if (!downloadMonitor.isVisible()) {
            downloadMonitor.setVisible(true);
            downloadMonitor.setTitle(s);
            showedDownloadMonitor = true;
        }
        String url = "http://images.google.es/images?hl=es&q=" + URLEncoder.encode(s) + "&gbv=2";
        String googleImagesResult = Util.getTextFromUrl(new URL(url));
        Set<String> imageUrls = Util.getImages(googleImagesResult);
        ArrayList<File> ret = new ArrayList<File>();
        for (String str : imageUrls) {
            if (urlFilter != null && str.indexOf(urlFilter) == -1) continue;
            if (exclude != null) {
                for (String _s : exclude) {
                    if (str.indexOf(_s) == -1) continue;
                }
            }
            try {
                File f = Util.download(str, downloadDir, false);
                if (downloadMonitor.isVisible()) {
                    try {
                        ImageIcon ii = new ImageIcon(Util.getScaledImage(new ImageIcon(f.toURI().toURL()), 150));
                        monitoredImage.setIcon(ii);
                        monitoredImage.repaint();
                        downloadMonitor.pack();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (f == null || !f.exists()) continue;
                ret.add(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (showedDownloadMonitor) {
            downloadMonitor.setVisible(false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File download(String address, File dir, boolean forceDownload) {
        File ret = null;
        OutputStream out = null;
        HttpURLConnection conn = null;
        InputStream in = null;
        try {
            int numRead;
            URL url;
            String simpleName;
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((simpleName = (url = new URL(address)).getFile()).lastIndexOf("/") != -1) {
                simpleName = simpleName.substring(simpleName.lastIndexOf("/") + 1);
                simpleName = simpleName.hashCode() + simpleName.substring(simpleName.lastIndexOf("."));
            }
            if (simpleName.lastIndexOf("\\") != -1) {
                simpleName = simpleName.substring(simpleName.lastIndexOf("\\"));
            }
            if (simpleName.lastIndexOf("?") != -1) {
                simpleName = simpleName.substring(0, simpleName.lastIndexOf("?"));
            }
            if ((ret = new File(dir, simpleName)).exists() && ret.length() > 0L) {
                if (!forceDownload) {
                    File file = ret;
                    return file;
                }
                int idx = 1;
                while (ret.exists()) {
                    ret = new File(dir, "(" + idx++ + ")" + simpleName);
                }
            }
            out = new BufferedOutputStream(new FileOutputStream(ret));
            conn = (HttpURLConnection)url.openConnection();
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString() + " Eliminando: n" + ret);
            ret.delete();
            ret = null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (ret != null && ret.length() == 0L) {
                    ret.delete();
                    return null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return ret;
    }

    public static File downloadFile(URL url, File dir) throws Exception {
        return Util.downloadFile(url, dir, null);
    }

    public static File downloadFile(URL url, File dir, String encoding) throws Exception {
        return Util.downloadFile(url, dir, null, encoding, false);
    }

    public static File downloadFile(URL url, File dir, String encoding, boolean forcedownload) throws Exception {
        return Util.downloadFile(url, dir, null, encoding, forcedownload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(URL url, File dir, String fileName, String encoding, boolean forcedownload) throws Exception {
        File outputFile;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (fileName == null) {
            String simpleName = url.getFile();
            if (simpleName.lastIndexOf("/") != -1) {
                simpleName = simpleName.substring(simpleName.lastIndexOf("/"));
            }
            if (simpleName.lastIndexOf("\\") != -1) {
                simpleName = simpleName.substring(simpleName.lastIndexOf("\\"));
            }
            if (simpleName.lastIndexOf("?") != -1) {
                simpleName = simpleName.substring(0, simpleName.lastIndexOf("?"));
            }
            fileName = simpleName;
        }
        if (!(outputFile = new File(dir, fileName)).exists()) {
            outputFile.createNewFile();
        } else if (outputFile.length() != 0L && !forcedownload) {
            return outputFile;
        }
        HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
        urlc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
        int responseCode = urlc.getResponseCode();
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            InputStream is = urlc.getInputStream();
            InputStreamReader isr = encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            FileWriter fw = new FileWriter(outputFile);
            bw = new BufferedWriter(fw);
            int c = -1;
            while ((c = br.read()) != -1) {
                bw.write(c);
            }
        }
        catch (Exception e) {
            System.err.println("Error downloading File From URL:" + url + " Exception is:" + e.getClass().getSimpleName() + ":" + e.getMessage());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (bw != null) {
                bw.close();
            }
        }
        return outputFile;
    }

    public static String getTextFromUrl(URL url) throws Exception {
        return Util.getTextFromUrl(url, null, null);
    }

    public static String getTextFromUrl(URL url, String method) throws Exception {
        return Util.getTextFromUrl(url, method, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextFromUrl(URL url, String method, String encoding) throws Exception {
        StringBuffer htmlPage;
        block13: {
            HttpURLConnection h;
            HttpURLConnection urlc = null;
            htmlPage = new StringBuffer();
            try {
                urlc = (HttpURLConnection)url.openConnection();
                if (method != null) {
                    urlc.setRequestMethod(method);
                }
                urlc.setRequestProperty("User-Agent", "Googlebot Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
                if (!(urlc instanceof HttpURLConnection)) break block13;
                h = urlc;
                int responseCode = h.getResponseCode();
                if (responseCode != 200) {
                    htmlPage.append("Got " + responseCode + " ( " + h.getResponseMessage() + ") Response Code from :" + url);
                    break block13;
                }
                try (BufferedReader br = null;){
                    InputStreamReader isr = encoding == null ? new InputStreamReader(h.getInputStream()) : new InputStreamReader(h.getInputStream(), encoding);
                    br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        htmlPage.append(line);
                        htmlPage.append("\n");
                    }
                }
            }
            finally {
                if (urlc != null && urlc instanceof HttpURLConnection) {
                    h = urlc;
                    h.disconnect();
                }
            }
        }
        return htmlPage.toString();
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        sha1hash = md.digest();
        return Util.convertToHex(sha1hash);
    }

    public static String SHA1(List<String> args) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        for (String text : args) {
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
        }
        sha1hash = md.digest();
        return Util.convertToHex(sha1hash);
    }

    public static String pruneString(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        return s;
    }

    public static Date getDate(Calendar c) {
        return new Date(c.get(1) - 1900, c.get(2), c.get(5));
    }

    public static Date getZeroTime(Date d) {
        Date d2 = new Date(d.getYear(), d.getMonth(), d.getDate());
        d2.setHours(0);
        d2.setMinutes(0);
        d2.setSeconds(0);
        return d2;
    }

    public static boolean sameDay(Date d1, Date d2) {
        return d1.getYear() == d2.getYear() && d1.getMonth() == d2.getMonth() && d1.getDate() == d2.getDate();
    }

    public static Date getNextDayZeroTime(Date d) {
        Date d2 = Util.getZeroTime(d);
        d2.setDate(d2.getDate() + 1);
        return d2;
    }

    public static Date getOneMonthBefore(Date d) {
        Date d2 = Util.getZeroTime(d);
        d2.setMonth(d2.getMonth() - 1);
        return d2;
    }

    public static GregorianCalendar getCalendar(Date d) {
        GregorianCalendar gc = new GregorianCalendar(new Locale("es", "ES"));
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        gc.set(5, d.getDate());
        gc.set(2, d.getMonth());
        gc.set(1, 1900 + d.getYear());
        return gc;
    }

    public static Date getLastDayOfMonth(Date d) {
        GregorianCalendar gc = Util.getCalendar(d);
        gc.add(2, 1);
        gc.set(5, 1);
        gc.add(5, -1);
        return Util.getDate(gc);
    }

    public static Date getFirstDayOfNextMonth(Date d) {
        GregorianCalendar gc = Util.getCalendar(d);
        gc.add(2, 1);
        gc.set(5, 1);
        return Util.getDate(gc);
    }

    public static Date getFirstDayOfMonth(Date d) {
        GregorianCalendar gc = Util.getCalendar(d);
        gc.set(5, 1);
        return Util.getDate(gc);
    }

    public static Date getFirstDayOfYear(Date d) {
        GregorianCalendar gc = Util.getCalendar(Util.getZeroTime(d));
        gc.set(5, 1);
        gc.set(2, 0);
        return Util.getDate(gc);
    }

    public static Date[] getWeek(Date d) {
        Date[] ret = new Date[2];
        GregorianCalendar gc = new GregorianCalendar(new Locale("es", "ES"));
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        gc.set(5, d.getDate());
        gc.set(2, d.getMonth());
        gc.set(1, 1900 + d.getYear());
        int offset = gc.get(7);
        int fdow = gc.getFirstDayOfWeek();
        gc.add(5, fdow - offset);
        ret[0] = Util.getDate(gc);
        gc.add(5, 7);
        ret[1] = Util.getDate(gc);
        return ret;
    }

    public static String getFile(String fileName) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(fis);
        int c = -1;
        StringBuffer sb = new StringBuffer();
        do {
            c = isr.read();
            sb.append((char)c);
        } while (c != -1);
        isr.close();
        return sb.toString();
    }

    public static void show(Object o, Throwable error) {
        if (o instanceof Component) {
            Util.show((Component)o, error);
        } else {
            Util.show(null, error);
        }
    }

    public static void show(Component source, Throwable error) {
        new ErrorDialog(source, error);
    }

    public static String toString(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bos));
        return bos.toString();
    }

    public static void show(Component source, String message) {
        System.err.println("WARNING: " + message);
        JOptionPane.showMessageDialog(source, message, "Atenci\u00f3n", 2);
    }

    public static void sendGoogleMail(String user, String password, String email, String subject, String body, File file) throws NamingException, MessagingException, IOException {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtps");
        props.put("mail.smtps.host", SMTP_HOST_NAME);
        props.put("mail.smtps.auth", "true");
        Session mailSession = Session.getDefaultInstance((Properties)props);
        mailSession.setDebug(false);
        Transport transport = mailSession.getTransport();
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(subject);
        message.setFrom((Address)InternetAddress.parse((String)user, (boolean)false)[0]);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email, (boolean)false));
        message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)"koalarescue@gmail.com", (boolean)false));
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        part.setText(body + " " + FOOTER);
        mp.addBodyPart((BodyPart)part);
        if (file != null) {
            MimeBodyPart part2 = new MimeBodyPart();
            part2.attachFile(file);
            mp.addBodyPart((BodyPart)part2);
        }
        message.setContent((Multipart)mp);
        transport.connect(SMTP_HOST_NAME, 465, user, password);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public static void sendMail(String host, String user, String password, String email, String subject, String body, File file) throws NamingException, MessagingException, IOException {
        Util.sendMail(host, user, password, 25, email, subject, body, false, file);
    }

    public static void sendMail(String host, String user, String password, int port, String email, String subject, String body, boolean html, File file) throws NamingException, MessagingException, IOException {
        Util.sendMail(host, user, password, port, email, subject, body, html, file, null);
    }

    public static void sendMail(String host, String user, String password, int port, String email, String subject, String body, boolean html, File file, String replyTo) throws NamingException, MessagingException, IOException {
        if (email.toUpperCase().equals(email)) {
            email = email.toLowerCase();
        }
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", (Object)port);
        props.put("mail.debug", (Object)false);
        Session mailSession = Session.getDefaultInstance((Properties)props);
        mailSession.setDebug(false);
        Transport transport = mailSession.getTransport("smtp");
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(subject);
        message.setFrom((Address)InternetAddress.parse((String)user, (boolean)false)[0]);
        if (replyTo != null) {
            message.setReplyTo((Address[])InternetAddress.parse((String)replyTo, (boolean)false));
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email, (boolean)false));
        message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)"koalarescue@gmail.com", (boolean)false));
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        if (!html) {
            part.setText(body + " \n\n --- Mensaje generado autom\u00e1ticamente ----");
        } else {
            part.setText(body, "UTF-8", "html");
        }
        mp.addBodyPart((BodyPart)part);
        if (file != null) {
            MimeBodyPart part2 = new MimeBodyPart();
            part2.attachFile(file);
            mp.addBodyPart((BodyPart)part2);
        }
        message.setContent((Multipart)mp);
        transport.connect(host, port, user, password);
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    public static List<Map<String, String>> getTPVParameters(List<String> mails) {
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        for (String s : mails) {
            HashMap<String, String> m = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(s, ";\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                line = line.replace("\n", "");
                StringTokenizer st2 = new StringTokenizer(line, ":;");
                String n = "";
                if (st2.hasMoreTokens()) {
                    n = st2.nextToken(":");
                }
                String v = "";
                while (st2.hasMoreTokens()) {
                    v = v + st2.nextToken(";");
                }
                if (v.startsWith(":")) {
                    v = v.substring(1);
                }
                v = v.replace("\n", "").trim();
                m.put(n, v);
            }
            ret.add(m);
        }
        return ret;
    }

    public static List getMails(String user, String password, String host, String from) throws Exception {
        Properties prop = new Properties();
        Session sesion = Session.getInstance((Properties)prop);
        Store store = sesion.getStore("pop3");
        store.connect(host, user, password);
        Folder folder = store.getFolder("INBOX");
        ArrayList ret = Util.getMails(folder, from);
        try {
            folder.close(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            store.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static List getGoogleMails(String user, String password, String from) throws Exception {
        Properties prop = new Properties();
        prop.setProperty("mail.pop3.starttls.enable", "false");
        prop.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        prop.setProperty("mail.pop3.socketFactory.fallback", "false");
        prop.setProperty("mail.pop3.port", "995");
        prop.setProperty("mail.pop3.socketFactory.port", "995");
        Session sesion = Session.getInstance((Properties)prop);
        Store store = sesion.getStore("pop3");
        store.connect("pop.gmail.com", user, password);
        Folder folder = store.getFolder("INBOX");
        ArrayList ret = Util.getMails(folder, from);
        try {
            folder.close(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            store.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static ArrayList getMails(Folder folder, String from) throws MessagingException {
        ArrayList<Object> ret = new ArrayList<Object>();
        folder.open(2);
        Message[] mensajes = folder.getMessages();
        InternetAddress tpv = new InternetAddress(from);
        Date aMonthAgo = new Date();
        aMonthAgo.setDate(aMonthAgo.getDate() - 7);
        for (int i = 0; i < mensajes.length; ++i) {
            try {
                mensajes[i].setFlag(Flags.Flag.DELETED, true);
                if (from == null || mensajes[i].getFrom()[0].equals((Object)tpv)) {
                    if (mensajes[i].getSentDate() != null && mensajes[i].getSentDate().before(aMonthAgo)) {
                        mensajes[i].setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    if (mensajes[i].isMimeType("text/plain")) {
                        ret.add(mensajes[i].getContent());
                        continue;
                    }
                    if (!mensajes[i].isMimeType("multipart/*")) continue;
                    Multipart multi = (Multipart)mensajes[i].getContent();
                    ArrayList subRet = new ArrayList();
                    for (int j = 0; j < multi.getCount(); ++j) {
                        BodyPart unaParte = multi.getBodyPart(j);
                        if (!unaParte.isMimeType("text/plain")) continue;
                        ret.add(unaParte.getContent());
                    }
                    if (subRet.size() == 1) {
                        ret.add(subRet.get(0));
                        continue;
                    }
                    if (subRet.size() <= 1) continue;
                    ret.add(subRet);
                    continue;
                }
                mensajes[i].setFlag(Flags.Flag.DELETED, true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static Object[] doPost(String _url, String referer, Map<String, String> m) throws UnsupportedEncodingException {
        StringBuffer data = new StringBuffer();
        for (String s : m.keySet()) {
            if (data.length() > 0) {
                data.append("&");
            }
            data.append(URLEncoder.encode(s, "UTF-8") + "=" + URLEncoder.encode(m.get(s), "UTF-8"));
        }
        return Util.doPost(_url, referer, data.toString());
    }

    public static Object[] doPost(String _url, String referer, List<String[]> l) throws UnsupportedEncodingException {
        StringBuffer data = new StringBuffer();
        for (String[] s : l) {
            if (data.length() > 0) {
                data.append("&");
            }
            data.append(URLEncoder.encode(s[0], "UTF-8") + "=" + URLEncoder.encode(s[1], "UTF-8"));
        }
        return Util.doPost(_url, referer, data.toString());
    }

    public static Object[] doPost(String _url, String referer, String postData) {
        try {
            String line;
            URL url = new URL(_url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            OutputStreamWriter wr = null;
            if (postData.length() > 0) {
                conn.setDoOutput(true);
                if (referer != null) {
                    conn.setRequestProperty("referer", referer);
                }
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(postData.toString());
                wr.flush();
            }
            Map<String, List<String>> map = conn.getHeaderFields();
            InputStream is = conn.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader rd = new BufferedReader(isr);
            StringBuffer data = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                data.append(line);
            }
            if (wr != null) {
                wr.close();
            }
            rd.close();
            return new Object[]{data.toString(), map};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Date d = Util.getFirstDayOfYear(new Date());
    }

    public static class MyCookieStore
    implements CookieStore {
        private Map<String, CookieList> map = new HashMap<String, CookieList>();
        private HttpCookie lastCookie;

        private static String getDomainFromHost(String host) {
            StringTokenizer st = new StringTokenizer(host, ".");
            ArrayList<String> ret = new ArrayList<String>();
            while (st.hasMoreElements()) {
                ret.add(0, st.nextToken());
            }
            return "." + ret.get(1) + "." + ret.get(0);
        }

        @Override
        public void add(URI uri, HttpCookie cookie) {
            ArrayList<HttpCookie> l;
            CookieList cl = this.map.get(uri.getHost());
            if (cl == null) {
                cl = new CookieList();
                this.map.put(uri.getHost(), cl);
            }
            if ((l = cl.cookies.get(uri)) == null) {
                l = new ArrayList();
                cl.cookies.put(uri, l);
            }
            l.add(cookie);
            cl.lastCookie = cookie;
            this.lastCookie = cookie;
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            ArrayList<HttpCookie> ret = null;
            CookieList cookies = this.map.get(uri.getHost());
            if (cookies != null) {
                ArrayList<HttpCookie> cl = cookies.cookies.get(uri);
                if (cl == null || cl.isEmpty()) {
                    if (cookies.lastCookie != null) {
                        ret = new ArrayList();
                        ret.add(cookies.lastCookie);
                        return ret;
                    }
                } else {
                    ret = cl;
                }
            } else {
                ret = new ArrayList<HttpCookie>();
                if (this.lastCookie != null) {
                    ret.add(this.lastCookie);
                }
            }
            return ret;
        }

        @Override
        public List<HttpCookie> getCookies() {
            ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
            Collection<CookieList> all = this.map.values();
            for (CookieList cl : all) {
                Collection<ArrayList<HttpCookie>> cl2 = cl.cookies.values();
                for (ArrayList<HttpCookie> al : cl2) {
                    ret.addAll(al);
                }
            }
            return ret;
        }

        @Override
        public List<URI> getURIs() {
            ArrayList<URI> ret = new ArrayList<URI>();
            Collection<CookieList> all = this.map.values();
            for (CookieList cl : all) {
                Set<URI> cl2 = cl.cookies.keySet();
                ret.addAll(cl2);
            }
            return ret;
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            CookieList cookies = this.map.get(uri.getHost());
            if (cookies == null) {
                return false;
            }
            ArrayList<HttpCookie> al = cookies.cookies.get(uri);
            if (al == null || !al.contains(cookie)) {
                return false;
            }
            al.remove(cookie);
            return true;
        }

        @Override
        public boolean removeAll() {
            this.map.clear();
            return true;
        }
    }

    public static class MyCookieStore2
    implements CookieStore {
        private volatile boolean acceptCookies = true;
        Map<String, HttpCookie> cookiesMap = new HashMap<String, HttpCookie>();

        @Override
        public void add(URI uri, HttpCookie cookie) {
            if (this.acceptCookies) {
                this.cookiesMap.put(cookie.getName(), cookie);
            }
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            List<HttpCookie> ret = this.getCookies();
            return ret;
        }

        @Override
        public List<HttpCookie> getCookies() {
            ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
            for (Map.Entry<String, HttpCookie> e : this.cookiesMap.entrySet()) {
                ret.add(e.getValue());
            }
            return ret;
        }

        @Override
        public List<URI> getURIs() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void removeByCookieName(String cookieName) {
            this.cookiesMap.remove(cookieName);
        }

        @Override
        public boolean removeAll() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class CookieList {
        public HashMap<URI, ArrayList<HttpCookie>> cookies = new HashMap();
        public HttpCookie lastCookie = null;

        private CookieList() {
        }
    }

    public static class CookiePolicyAcceptNone
    implements CookiePolicy {
        @Override
        public boolean shouldAccept(URI uri, HttpCookie cookie) {
            return false;
        }
    }

    public static class MyCookiePolicy
    implements CookiePolicy {
        @Override
        public boolean shouldAccept(URI uri, HttpCookie cookie) {
            return true;
        }
    }
}

