/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.util;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JFormattedTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortPesoReader {
    private static final Logger log = LoggerFactory.getLogger(SerialPortPesoReader.class);
    public transient float peso;
    private PesoListener listener;
    private JFormattedTextField pesoField;
    private List<CommPort> openPorts = Collections.synchronizedList(new ArrayList());

    public synchronized void setPeso(float peso) {
        this.peso = peso;
    }

    public synchronized float getPeso() {
        return this.peso;
    }

    public SerialPortPesoReader(JFormattedTextField pesoField) {
        this(null, pesoField);
    }

    public SerialPortPesoReader(PesoListener listener) {
        this(listener, null);
    }

    public SerialPortPesoReader(PesoListener listener, JFormattedTextField pesoField) {
        this.listener = listener;
        this.pesoField = pesoField;
        log.info("Serial port peso reader. listener = " + listener);
        log.info("Serial port peso reader. pesofield = " + pesoField);
        try {
            log.info("Serial port peso reader Cconnecting ");
            this.connect();
            log.info("Serial port peso reader connected ");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("error connecting to serial port", t);
            System.err.println("Error Puerto serie");
        }
    }

    void connect() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("Registering shutdown hook");
                SerialPortPesoReader.this.closePorts();
                log.info("shutdown hook registered");
            }
        });
        log.info("CommPortIdentifier.getPortIdentifiers()");
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            log.info("portId " + portId.getName() + " " + portId.getPortType());
            try {
                if (portId.getPortType() != 1) continue;
                if (portId.isCurrentlyOwned()) {
                    log.info("Error: Port is currently in use");
                    continue;
                }
                System.out.println("Opening port " + portId.getName());
                CommPort commPort = portId.open(this.getClass().getName(), 2000);
                this.openPorts.add(commPort);
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(9600, 8, 1, 0);
                InputStream in = serialPort.getInputStream();
                OutputStream out = serialPort.getOutputStream();
                new Thread(new SerialReader(in, out, commPort)).start();
                log.info("Opened ports " + this.openPorts);
            }
            catch (PortInUseException piue) {
                log.error("Error opening port:" + portId.getName() + " currentOwner " + piue.currentOwner);
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error("Error opening port:" + portId.getName() + " currentOwner " + portId.getCurrentOwner(), t);
            }
        }
    }

    public void closePorts() {
        log.info("Closing ports " + this.openPorts);
        for (CommPort cp : this.openPorts) {
            try {
                cp.close();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                log.error("error closing port", t);
            }
        }
    }

    public void finalize() {
        this.closePorts();
    }

    public static interface PesoListener {
        public void onPeso(float var1);
    }

    public class SerialReader
    implements Runnable {
        private InputStream in;
        private OutputStream out;
        private CommPort commPort;

        public SerialReader(InputStream in, OutputStream out, CommPort commPort) {
            this.in = in;
            this.out = out;
            this.commPort = commPort;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[12];
            int len = -1;
            System.out.println("Reader started on port " + this.commPort.getName());
            block6: while (true) {
                try {
                    while (true) {
                        this.out.write("$".getBytes());
                        len = this.in.read(buffer);
                        String s = new String(buffer, 2, 8);
                        s = s.trim();
                        if (Math.random() < 0.01) {
                            System.out.println("len= " + len + " bytes");
                            System.out.println("Buffer: " + Arrays.toString(buffer));
                            System.out.println("String: " + s);
                        }
                        try {
                            float f = Float.parseFloat(s);
                            SerialPortPesoReader.this.setPeso(f);
                            if (SerialPortPesoReader.this.listener != null) {
                                SerialPortPesoReader.this.listener.onPeso(f);
                            }
                            if (SerialPortPesoReader.this.pesoField != null) {
                                SerialPortPesoReader.this.pesoField.setValue(new Float(f));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("Could not parse peso " + s);
                        }
                        try {
                            Thread.sleep(100L);
                            continue block6;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

