/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.swing;

import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;

public class PatternFormatter
extends JFormattedTextField.AbstractFormatter {
    String pattern;
    boolean nullable;
    boolean uppercase;
    public BarcodeParser barcodeParser;

    public PatternFormatter(String pattern, boolean uppercase, boolean nullable) {
        this.pattern = pattern;
        this.uppercase = uppercase;
        this.nullable = nullable;
    }

    public void setBarcodeParser(BarcodeParser barcodeParser) {
        this.barcodeParser = barcodeParser;
    }

    @Override
    public Object stringToValue(String s) throws ParseException {
        if (this.barcodeParser != null) {
            s = this.barcodeParser.parseString(s);
        }
        if (s == null && !this.nullable) {
            throw new ParseException("null value not allowed", -1);
        }
        String ret = null;
        ret = this.uppercase ? s.toUpperCase() : s;
        if (this.nullable && s.isEmpty()) {
            ret = "";
        } else {
            if (!this.nullable && s.isEmpty()) {
                throw new ParseException(s + " es obligatiorio ", -1);
            }
            if (this.pattern.length() > 0 && !Pattern.matches(this.pattern, ret)) {
                throw new ParseException(s + " debe estar en formato " + this.pattern, -1);
            }
        }
        return ret;
    }

    @Override
    public String valueToString(Object o) throws ParseException {
        if (o instanceof String) {
            return (String)this.stringToValue((String)o);
        }
        throw new ParseException("not a string " + o, -1);
    }

    public static abstract class BarcodeParser {
        public abstract String parseString(String var1);
    }
}

