/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.swing;

import es.pablo.jee.ejb.jms.PersistenceEvent;
import es.pablo.jee.ejb.jms.Refreshable;
import es.pablo.jee.ejb.jms.Refresher;
import es.pablo.jee.entity.ServerFile;
import es.pablo.util.Util;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ImagenRenderer
extends DefaultTableCellRenderer.UIResource
implements Refreshable {
    private String baseURL;
    private boolean showText;
    private int maxSize = -1;
    private String property;
    private static Map<Object, ImageIcon> cache = Collections.synchronizedMap(new HashMap());

    public ImagenRenderer(String baseURL, boolean showText) {
        this.baseURL = baseURL;
        this.showText = showText;
        this.maxSize = 150;
        super.setHorizontalAlignment(0);
    }

    public ImagenRenderer(Class c, String property, boolean showText, int scaled) throws Exception {
        this.showText = showText;
        this.maxSize = scaled;
        Refresher.getInstance().subscribe(c, this);
        super.setHorizontalAlignment(0);
    }

    @Override
    public void refresh(PersistenceEvent pe) throws Exception {
        if (PersistenceEvent.Type.UPDATE.equals((Object)pe.type) || PersistenceEvent.Type.FULL_REFRESH.equals((Object)pe.type)) {
            ImagenRenderer.flushCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        Map<Object, ImageIcon> map = cache;
        synchronized (map) {
            cache = Collections.synchronizedMap(new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ImageIcon icon = null;
        if (value == null || value.toString().length() == 0) {
            this.setText("Sin im\u00e1gen");
            this.setIcon(null);
            return this;
        }
        String errorMsg = "";
        Map<Object, ImageIcon> map = cache;
        synchronized (map) {
            if (!cache.containsKey(value)) {
                try {
                    URL url = null;
                    if (this.baseURL != null) {
                        url = new URL(this.baseURL + value);
                    } else if (value instanceof ServerFile) {
                        File f = ((ServerFile)value).getTempFile();
                        url = f.toURI().toURL();
                    }
                    if (url != null) {
                        icon = new ImageIcon(url);
                    }
                    if (icon != null) {
                        icon.setImage(Util.getScaledImage(icon, this.maxSize));
                    }
                    cache.put(value, icon);
                }
                catch (Throwable t) {
                    this.setIcon(null);
                    errorMsg = "Error:" + value + " " + t.getMessage();
                    cache.put(value, null);
                }
            } else {
                icon = cache.get(value);
            }
        }
        this.setIcon(icon);
        if (icon != null) {
            int h;
            int n = h = icon.getIconHeight() < 15 ? 15 : icon.getIconHeight();
            if (table.getRowHeight(row) < h) {
                table.setRowHeight(row, h);
            }
            if (this.showText) {
                icon.setDescription("" + value);
            } else {
                icon.setDescription("");
            }
        } else {
            this.setText(errorMsg);
        }
        return this;
    }
}

