/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.swing;

import es.pablo.jee.entity.LobFile;
import es.pablo.jee.entity.ServerFile;
import es.pablo.util.Util;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.EventObject;
import javax.imageio.ImageIO;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class FileCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JButton button;
    JFileChooser jfc;
    JComponent parentComponent;
    File currentFile = null;
    protected static final String EDIT = "edit";
    es.pablo.jee.entity.Image image;
    Class targetClass;

    public FileCellEditor(JComponent parentComponent, es.pablo.jee.entity.Image image, Class targetClass) {
        this.parentComponent = parentComponent;
        this.image = image;
        this.targetClass = targetClass;
        this.button = new JButton();
        this.button.setActionCommand(EDIT);
        this.button.setBorderPainted(false);
        this.button.setText("Seleccione fichero");
        this.jfc = new JFileChooser();
        this.jfc.setDialogType(0);
        this.jfc.setFileSelectionMode(0);
        this.button.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int maxSize = this.image != null ? this.image.maxSize() : -1;
            Object[] ret = Util.getImageAndFileFromClipBoard(maxSize);
            if (ret != null) {
                File f = (File)ret[0];
                ImageIcon ii = (ImageIcon)ret[1];
                if (f != null) {
                    JLabel label = new JLabel("Tomar " + f.getName() + " del portapaeles", ii, 0);
                    int answ = JOptionPane.showConfirmDialog(null, label, "Tomar del portapapeles?", 1);
                    if (answ == 0) {
                        this.currentFile = f;
                        this.stopCellEditing();
                        return;
                    }
                    if (answ == 2) {
                        this.currentFile = null;
                        this.cancelCellEditing();
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            Util.show(this, (Throwable)ex);
        }
        int ret = this.jfc.showOpenDialog(this.parentComponent);
        if (ret == 0) {
            this.currentFile = this.jfc.getSelectedFile();
            this.stopCellEditing();
        } else if (ret == -1) {
            this.currentFile = null;
        } else {
            this.currentFile = null;
            super.cancelCellEditing();
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentFile != null && !this.currentFile.isDirectory()) {
            try {
                if (this.image != null && this.image.maxSize() != -1) {
                    ImageIcon ii = new ImageIcon(this.currentFile.toURI().toURL());
                    Image scaled = Util.getScaledImage(ii, this.image.maxSize());
                    ii.setImage(scaled);
                    RenderedImage rendered = Util.getRenderedImage(ii);
                    String s = this.currentFile.getName().replace(" ", "");
                    File f = new File("x" + s);
                    f.deleteOnExit();
                    ImageIO.write(rendered, "JPEG", f);
                    this.currentFile = f;
                }
                Object o = null;
                if (this.targetClass.equals(LobFile.class)) {
                    o = new LobFile(this.currentFile);
                } else if (this.targetClass.equals(ServerFile.class)) {
                    ServerFile sf = new ServerFile(this.currentFile);
                    sf.name = System.currentTimeMillis() + sf.name;
                    o = sf;
                } else {
                    o = Util.readFileToByteArr(this.currentFile);
                }
                return o;
            }
            catch (Exception e) {
                Util.show(this, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.jfc.setSelectedFile(new File(value.toString()));
        }
        return this.button;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }
}

