/*
 * Decompiled with CFR 0.152.
 */
package es.pablo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public class DecimalCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Object ERROR = new Object();
    DecimalFormat formatter;
    JTextField component = new JTextField();
    boolean nullable;
    Border normalBorder;

    public DecimalCellEditor(DecimalFormat formatter, boolean nullable) {
        this.formatter = formatter;
        this.nullable = nullable;
        this.normalBorder = this.component.getBorder();
        this.component.setHorizontalAlignment(4);
        this.component.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DecimalCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text = "";
        if (value != null) {
            text = this.formatter.format(value);
        }
        this.component.setText(text);
        System.out.println("returning editor + " + value + " text= " + text);
        return this.component;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getCellEditorValue() == ERROR) {
            this.component.setBorder(new LineBorder(Color.red));
            return false;
        }
        this.component.setBorder(this.normalBorder);
        return super.stopCellEditing();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getCellEditorValue() {
        String s;
        try {
            s = this.component.getText();
            System.out.println("getCellEditorValue getText()=" + s);
            if (s.trim().isEmpty() && this.nullable) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
            return ERROR;
        }
        try {
            Number ret = this.formatter.parse(s);
            System.out.println("returning " + ret + " class = " + ret.getClass());
            return ret;
        }
        catch (Exception exception) {
            return ERROR;
        }
    }
}

